% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/organizations_operations.R
\name{organizations_list_policies_for_target}
\alias{organizations_list_policies_for_target}
\title{Lists the policies that are directly attached to the specified target
root, organizational unit (OU), or account}
\usage{
organizations_list_policies_for_target(TargetId, Filter, NextToken,
  MaxResults)
}
\arguments{
\item{TargetId}{[required] The unique identifier (ID) of the root, organizational unit, or account
whose policies you want to list.

The \href{http://wikipedia.org/wiki/regex}{regex pattern} for a target ID
string requires one of the following:
\itemize{
\item \strong{Root} - A string that begins with \"r-\" followed by from 4 to 32
lowercase letters or digits.
\item \strong{Account} - A string that consists of exactly 12 digits.
\item \strong{Organizational unit (OU)} - A string that begins with \"ou-\"
followed by from 4 to 32 lowercase letters or digits (the ID of the
root that the OU is in). This string is followed by a second \"-\"
dash and from 8 to 32 additional lowercase letters or digits.
}}

\item{Filter}{[required] The type of policy that you want to include in the returned list.}

\item{NextToken}{Use this parameter if you receive a \code{NextToken} response in a previous
request that indicates that there is more output available. Set it to
the value of the previous call\'s \code{NextToken} response to indicate where
the output should continue from.}

\item{MaxResults}{(Optional) Use this to limit the number of results you want included per
page in the response. If you do not include this parameter, it defaults
to a value that is specific to the operation. If additional items exist
beyond the maximum you specify, the \code{NextToken} response element is
present and has a value (is not null). Include that value as the
\code{NextToken} request parameter in the next call to the operation to get
the next part of the results. Note that Organizations might return fewer
results than the maximum even when there are more results available. You
should check \code{NextToken} after every operation to ensure that you
receive all of the results.}
}
\description{
Lists the policies that are directly attached to the specified target
root, organizational unit (OU), or account. You must specify the policy
type that you want included in the returned list.
}
\details{
Always check the \code{NextToken} response parameter for a \code{null} value when
calling a \verb{List*} operation. These operations can occasionally return an
empty set of results even when there are more results available. The
\code{NextToken} response parameter value is \code{null} \emph{only} when there are no
more results to display.

This operation can be called only from the organization\'s master
account.
}
\section{Request syntax}{
\preformatted{svc$list_policies_for_target(
  TargetId = "string",
  Filter = "SERVICE_CONTROL_POLICY"|"TAG_POLICY",
  NextToken = "string",
  MaxResults = 123
)
}
}

\examples{
# The following example shows how to get a list of all service control
# policies (SCPs) of the type specified by the Filter parameter, that are
# directly attached to an account. The returned list does not include
# policies that apply to the account because of inheritance from its
# location in an OU hierarchy:/n/n
\dontrun{svc$list_policies_for_target(
  Filter = "SERVICE_CONTROL_POLICY",
  TargetId = "444444444444"
)}

}
\keyword{internal}
