% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pi_service.R
\name{pi}
\alias{pi}
\title{AWS Performance Insights}
\usage{
pi()
}
\description{
AWS Performance Insights enables you to monitor and explore different
dimensions of database load based on data captured from a running RDS
instance. The guide provides detailed information about Performance
Insights data types, parameters and errors. For more information about
Performance Insights capabilities see \href{http://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_PerfInsights.html}{Using Amazon RDS Performance Insights}
in the \emph{Amazon RDS User Guide}.

The AWS Performance Insights API provides visibility into the
performance of your RDS instance, when Performance Insights is enabled
for supported engine types. While Amazon CloudWatch provides the
authoritative source for AWS service vended monitoring metrics, AWS
Performance Insights offers a domain-specific view of database load
measured as Average Active Sessions and provided to API consumers as a
2-dimensional time-series dataset. The time dimension of the data
provides DB load data for each time point in the queried time range, and
each time point decomposes overall load in relation to the requested
dimensions, such as SQL, Wait-event, User or Host, measured at that time
point.
}
\section{Operations}{

\tabular{ll}{
\link[=pi_describe_dimension_keys]{describe_dimension_keys} \tab For a specific time period, retrieve the top N dimension keys for a metric \cr
\link[=pi_get_resource_metrics]{get_resource_metrics} \tab Retrieve Performance Insights metrics for a set of data sources, over a time period
}
}

\examples{
\donttest{svc <- pi()
svc$describe_dimension_keys(
  Foo = 123
)}

}
