% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cloudformation_operations.R
\name{cloudformation_delete_stack}
\alias{cloudformation_delete_stack}
\title{Deletes a specified stack}
\usage{
cloudformation_delete_stack(StackName, RetainResources, RoleARN,
  ClientRequestToken)
}
\arguments{
\item{StackName}{[required] The name or the unique stack ID that is associated with the stack.}

\item{RetainResources}{For stacks in the \code{DELETE_FAILED} state, a list of resource logical IDs
that are associated with the resources you want to retain. During
deletion, AWS CloudFormation deletes the stack but does not delete the
retained resources.

Retaining resources is useful when you cannot delete a resource, such as
a non-empty S3 bucket, but you want to delete the stack.}

\item{RoleARN}{The Amazon Resource Name (ARN) of an AWS Identity and Access Management
(IAM) role that AWS CloudFormation assumes to delete the stack. AWS
CloudFormation uses the role's credentials to make calls on your
behalf.

If you don't specify a value, AWS CloudFormation uses the role that was
previously associated with the stack. If no role is available, AWS
CloudFormation uses a temporary session that is generated from your user
credentials.}

\item{ClientRequestToken}{A unique identifier for this \code{DeleteStack} request. Specify this token
if you plan to retry requests so that AWS CloudFormation knows that
you're not attempting to delete a stack with the same name. You might
retry \code{DeleteStack} requests to ensure that AWS CloudFormation
successfully received them.

All events triggered by a given stack operation are assigned the same
client request token, which you can use to track operations. For
example, if you execute a \code{CreateStack} operation with the token
\code{token1}, then all the \code{StackEvents} generated by that operation will
have \code{ClientRequestToken} set as \code{token1}.

In the console, stack operations display the client request token on the
Events tab. Stack operations that are initiated from the console use the
token format \emph{Console-StackOperation-ID}, which helps you easily
identify the stack operation . For example, if you create a stack using
the console, each stack event would be assigned the same token in the
following format:
\code{Console-CreateStack-7f59c3cf-00d2-40c7-b2ff-e75db0987002}.}
}
\description{
Deletes a specified stack. Once the call completes successfully, stack
deletion starts. Deleted stacks do not show up in the DescribeStacks API
if the deletion has been completed successfully.
}
\section{Request syntax}{
\preformatted{svc$delete_stack(
  StackName = "string",
  RetainResources = list(
    "string"
  ),
  RoleARN = "string",
  ClientRequestToken = "string"
)
}
}

\keyword{internal}
