% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ssm_operations.R
\name{ssm_describe_document_permission}
\alias{ssm_describe_document_permission}
\title{Describes the permissions for a Systems Manager document}
\usage{
ssm_describe_document_permission(Name, PermissionType)
}
\arguments{
\item{Name}{[required] The name of the document for which you are the owner.}

\item{PermissionType}{[required] The permission type for the document. The permission type can be
\emph{Share}.}
}
\value{
A list with the following syntax:\preformatted{list(
  AccountIds = list(
    "string"
  ),
  AccountSharingInfoList = list(
    list(
      AccountId = "string",
      SharedDocumentVersion = "string"
    )
  )
)
}
}
\description{
Describes the permissions for a Systems Manager document. If you created
the document, you are the owner. If a document is shared, it can either
be shared privately (by specifying a user's AWS account ID) or publicly
(\emph{All}).
}
\section{Request syntax}{
\preformatted{svc$describe_document_permission(
  Name = "string",
  PermissionType = "Share"
)
}
}

\keyword{internal}
