% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/servicecatalog_operations.R
\name{servicecatalog_list_organization_portfolio_access}
\alias{servicecatalog_list_organization_portfolio_access}
\title{Lists the organization nodes that have access to the specified portfolio}
\usage{
servicecatalog_list_organization_portfolio_access(AcceptLanguage,
  PortfolioId, OrganizationNodeType, PageToken, PageSize)
}
\arguments{
\item{AcceptLanguage}{The language code.
\itemize{
\item \code{en} - English (default)
\item \code{jp} - Japanese
\item \code{zh} - Chinese
}}

\item{PortfolioId}{[required] The portfolio identifier. For example, \verb{port-2abcdext3y5fk}.}

\item{OrganizationNodeType}{[required] The organization node type that will be returned in the output.
\itemize{
\item \code{ORGANIZATION} - Organization that has access to the portfolio.
\item \code{ORGANIZATIONAL_UNIT} - Organizational unit that has access to the
portfolio within your organization.
\item \code{ACCOUNT} - Account that has access to the portfolio within your
organization.
}}

\item{PageToken}{The page token for the next set of results. To retrieve the first set of
results, use null.}

\item{PageSize}{The maximum number of items to return with this call.}
}
\value{
A list with the following syntax:\preformatted{list(
  OrganizationNodes = list(
    list(
      Type = "ORGANIZATION"|"ORGANIZATIONAL_UNIT"|"ACCOUNT",
      Value = "string"
    )
  ),
  NextPageToken = "string"
)
}
}
\description{
Lists the organization nodes that have access to the specified
portfolio. This API can only be called by the management account in the
organization or by a delegated admin.

If a delegated admin is de-registered, they can no longer perform this
operation.
}
\section{Request syntax}{
\preformatted{svc$list_organization_portfolio_access(
  AcceptLanguage = "string",
  PortfolioId = "string",
  OrganizationNodeType = "ORGANIZATION"|"ORGANIZATIONAL_UNIT"|"ACCOUNT",
  PageToken = "string",
  PageSize = 123
)
}
}

\keyword{internal}
