% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/licensemanager_operations.R
\name{licensemanager_create_grant_version}
\alias{licensemanager_create_grant_version}
\title{Creates a new version of the specified grant}
\usage{
licensemanager_create_grant_version(ClientToken, GrantArn, GrantName,
  AllowedOperations, Status, SourceVersion)
}
\arguments{
\item{ClientToken}{[required] Unique, case-sensitive identifier that you provide to ensure the
idempotency of the request.}

\item{GrantArn}{[required] Amazon Resource Name (ARN) of the grant.}

\item{GrantName}{Grant name.}

\item{AllowedOperations}{Allowed operations for the grant.}

\item{Status}{Grant status.}

\item{SourceVersion}{Current version of the grant.}
}
\value{
A list with the following syntax:\preformatted{list(
  GrantArn = "string",
  Status = "PENDING_WORKFLOW"|"PENDING_ACCEPT"|"REJECTED"|"ACTIVE"|"FAILED_WORKFLOW"|"DELETED"|"PENDING_DELETE"|"DISABLED",
  Version = "string"
)
}
}
\description{
Creates a new version of the specified grant.
}
\section{Request syntax}{
\preformatted{svc$create_grant_version(
  ClientToken = "string",
  GrantArn = "string",
  GrantName = "string",
  AllowedOperations = list(
    "CreateGrant"|"CheckoutLicense"|"CheckoutBorrowLicense"|"CheckInLicense"|"ExtendConsumptionLicense"|"ListPurchasedLicenses"|"CreateToken"
  ),
  Status = "PENDING_WORKFLOW"|"PENDING_ACCEPT"|"REJECTED"|"ACTIVE"|"FAILED_WORKFLOW"|"DELETED"|"PENDING_DELETE"|"DISABLED",
  SourceVersion = "string"
)
}
}

\keyword{internal}
