% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cloudformation_operations.R
\name{cloudformation_list_stack_sets}
\alias{cloudformation_list_stack_sets}
\title{Returns summary information about stack sets that are associated with
the user}
\usage{
cloudformation_list_stack_sets(NextToken, MaxResults, Status)
}
\arguments{
\item{NextToken}{If the previous paginated request didn't return all of the remaining
results, the response object's \code{NextToken} parameter value is set to a
token. To retrieve the next set of results, call
\code{\link[=cloudformation_list_stack_sets]{list_stack_sets}} again and assign
that token to the request object's \code{NextToken} parameter. If there are
no remaining results, the previous response object's \code{NextToken}
parameter is set to \code{null}.}

\item{MaxResults}{The maximum number of results to be returned with a single call. If the
number of available results exceeds this maximum, the response includes
a \code{NextToken} value that you can assign to the \code{NextToken} request
parameter to get the next set of results.}

\item{Status}{The status of the stack sets that you want to get summary information
about.}
}
\value{
A list with the following syntax:\preformatted{list(
  Summaries = list(
    list(
      StackSetName = "string",
      StackSetId = "string",
      Description = "string",
      Status = "ACTIVE"|"DELETED",
      AutoDeployment = list(
        Enabled = TRUE|FALSE,
        RetainStacksOnAccountRemoval = TRUE|FALSE
      ),
      PermissionModel = "SERVICE_MANAGED"|"SELF_MANAGED",
      DriftStatus = "DRIFTED"|"IN_SYNC"|"UNKNOWN"|"NOT_CHECKED",
      LastDriftCheckTimestamp = as.POSIXct(
        "2015-01-01"
      )
    )
  ),
  NextToken = "string"
)
}
}
\description{
Returns summary information about stack sets that are associated with
the user.
}
\section{Request syntax}{
\preformatted{svc$list_stack_sets(
  NextToken = "string",
  MaxResults = 123,
  Status = "ACTIVE"|"DELETED"
)
}
}

\keyword{internal}
