% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sagemaker_operations.R
\name{sagemaker_list_inference_experiments}
\alias{sagemaker_list_inference_experiments}
\title{Returns the list of all inference experiments}
\usage{
sagemaker_list_inference_experiments(
  NameContains = NULL,
  Type = NULL,
  StatusEquals = NULL,
  CreationTimeAfter = NULL,
  CreationTimeBefore = NULL,
  LastModifiedTimeAfter = NULL,
  LastModifiedTimeBefore = NULL,
  SortBy = NULL,
  SortOrder = NULL,
  NextToken = NULL,
  MaxResults = NULL
)
}
\arguments{
\item{NameContains}{Selects inference experiments whose names contain this name.}

\item{Type}{Selects inference experiments of this type. For the possible types of
inference experiments, see
\code{\link[=sagemaker_create_inference_experiment]{create_inference_experiment}}.}

\item{StatusEquals}{Selects inference experiments which are in this status. For the possible
statuses, see
\code{\link[=sagemaker_describe_inference_experiment]{describe_inference_experiment}}.}

\item{CreationTimeAfter}{Selects inference experiments which were created after this timestamp.}

\item{CreationTimeBefore}{Selects inference experiments which were created before this timestamp.}

\item{LastModifiedTimeAfter}{Selects inference experiments which were last modified after this
timestamp.}

\item{LastModifiedTimeBefore}{Selects inference experiments which were last modified before this
timestamp.}

\item{SortBy}{The column by which to sort the listed inference experiments.}

\item{SortOrder}{The direction of sorting (ascending or descending).}

\item{NextToken}{The response from the last list when returning a list large enough to
need tokening.}

\item{MaxResults}{The maximum number of results to select.}
}
\description{
Returns the list of all inference experiments.

See \url{https://www.paws-r-sdk.com/docs/sagemaker_list_inference_experiments/} for full documentation.
}
\keyword{internal}
