% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/personalize_operations.R
\name{personalize_create_dataset_import_job}
\alias{personalize_create_dataset_import_job}
\title{Creates a job that imports training data from your data source (an
Amazon S3 bucket) to an Amazon Personalize dataset}
\usage{
personalize_create_dataset_import_job(
  jobName,
  datasetArn,
  dataSource,
  roleArn,
  tags = NULL,
  importMode = NULL,
  publishAttributionMetricsToS3 = NULL
)
}
\arguments{
\item{jobName}{[required] The name for the dataset import job.}

\item{datasetArn}{[required] The ARN of the dataset that receives the imported data.}

\item{dataSource}{[required] The Amazon S3 bucket that contains the training data to import.}

\item{roleArn}{[required] The ARN of the IAM role that has permissions to read from the Amazon S3
data source.}

\item{tags}{A list of
\href{https://docs.aws.amazon.com/personalize/latest/dg/tagging-resources.html}{tags}
to apply to the dataset import job.}

\item{importMode}{Specify how to add the new records to an existing dataset. The default
import mode is \code{FULL}. If you haven't imported bulk records into the
dataset previously, you can only specify \code{FULL}.
\itemize{
\item Specify \code{FULL} to overwrite all existing bulk data in your dataset.
Data you imported individually is not replaced.
\item Specify \code{INCREMENTAL} to append the new records to the existing data
in your dataset. Amazon Personalize replaces any record with the
same ID with the new one.
}}

\item{publishAttributionMetricsToS3}{If you created a metric attribution, specify whether to publish metrics
for this import job to Amazon S3}
}
\description{
Creates a job that imports training data from your data source (an Amazon S3 bucket) to an Amazon Personalize dataset. To allow Amazon Personalize to import the training data, you must specify an IAM service role that has permission to read from the data source, as Amazon Personalize makes a copy of your data and processes it internally. For information on granting access to your Amazon S3 bucket, see \href{https://docs.aws.amazon.com/personalize/latest/dg/granting-personalize-s3-access.html}{Giving Amazon Personalize Access to Amazon S3 Resources}.

See \url{https://www.paws-r-sdk.com/docs/personalize_create_dataset_import_job/} for full documentation.
}
\keyword{internal}
