# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common new_handlers new_service set_config merge_config
NULL

#' Amazon SageMaker geospatial capabilities
#'
#' @description
#' Provides APIs for creating and managing SageMaker geospatial resources.
#'
#' @param
#' config
#' Optional configuration of credentials, endpoint, and/or region.
#' \itemize{
#' \item{\strong{credentials}: \itemize{
#' \item{\strong{creds}: \itemize{
#' \item{\strong{access_key_id}: AWS access key ID}
#' \item{\strong{secret_access_key}: AWS secret access key}
#' \item{\strong{session_token}: AWS temporary session token}
#' }}
#' \item{\strong{profile}: The name of a profile to use. If not given, then the default profile is used.}
#' \item{\strong{anonymous}: Set anonymous credentials.}
#' }}
#' \item{\strong{endpoint}: The complete URL to use for the constructed client.}
#' \item{\strong{region}: The AWS Region used in instantiating the client.}
#' \item{\strong{close_connection}: Immediately close all HTTP connections.}
#' \item{\strong{timeout}: The time in seconds till a timeout exception is thrown when attempting to make a connection. The default is 60 seconds.}
#' \item{\strong{s3_force_path_style}: Set this to `true` to force the request to use path-style addressing, i.e. `http://s3.amazonaws.com/BUCKET/KEY`.}
#' \item{\strong{sts_regional_endpoint}: Set sts regional endpoint resolver to regional or legacy \url{https://docs.aws.amazon.com/sdkref/latest/guide/feature-sts-regionalized-endpoints.html}}
#' }
#' @param
#' credentials
#' Optional credentials shorthand for the config parameter
#' \itemize{
#' \item{\strong{creds}: \itemize{
#' \item{\strong{access_key_id}: AWS access key ID}
#' \item{\strong{secret_access_key}: AWS secret access key}
#' \item{\strong{session_token}: AWS temporary session token}
#' }}
#' \item{\strong{profile}: The name of a profile to use. If not given, then the default profile is used.}
#' \item{\strong{anonymous}: Set anonymous credentials.}
#' }
#' @param
#' endpoint
#' Optional shorthand for complete URL to use for the constructed client.
#' @param
#' region
#' Optional shorthand for AWS Region used in instantiating the client.
#'
#' @section Service syntax:
#' ```
#' svc <- sagemakergeospatialcapabilities(
#'   config = list(
#'     credentials = list(
#'       creds = list(
#'         access_key_id = "string",
#'         secret_access_key = "string",
#'         session_token = "string"
#'       ),
#'       profile = "string",
#'       anonymous = "logical"
#'     ),
#'     endpoint = "string",
#'     region = "string",
#'     close_connection = "logical",
#'     timeout = "numeric",
#'     s3_force_path_style = "logical",
#'     sts_regional_endpoint = "string"
#'   ),
#'   credentials = list(
#'     creds = list(
#'       access_key_id = "string",
#'       secret_access_key = "string",
#'       session_token = "string"
#'     ),
#'     profile = "string",
#'     anonymous = "logical"
#'   ),
#'   endpoint = "string",
#'   region = "string"
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' svc <- sagemakergeospatialcapabilities()
#' svc$delete_earth_observation_job(
#'   Foo = 123
#' )
#' }
#'
#' @section Operations:
#' \tabular{ll}{
#'  \link[=sagemakergeospatialcapabilities_delete_earth_observation_job]{delete_earth_observation_job} \tab Use this operation to delete an Earth Observation job\cr
#'  \link[=sagemakergeospatialcapabilities_delete_vector_enrichment_job]{delete_vector_enrichment_job} \tab Use this operation to delete a Vector Enrichment job\cr
#'  \link[=sagemakergeospatialcapabilities_export_earth_observation_job]{export_earth_observation_job} \tab Use this operation to export results of an Earth Observation job and optionally source images used as input to the EOJ to an Amazon S3 location\cr
#'  \link[=sagemakergeospatialcapabilities_export_vector_enrichment_job]{export_vector_enrichment_job} \tab Use this operation to copy results of a Vector Enrichment job to an Amazon S3 location\cr
#'  \link[=sagemakergeospatialcapabilities_get_earth_observation_job]{get_earth_observation_job} \tab Get the details for a previously initiated Earth Observation job\cr
#'  \link[=sagemakergeospatialcapabilities_get_raster_data_collection]{get_raster_data_collection} \tab Use this operation to get details of a specific raster data collection\cr
#'  \link[=sagemakergeospatialcapabilities_get_tile]{get_tile} \tab Gets a web mercator tile for the given Earth Observation job\cr
#'  \link[=sagemakergeospatialcapabilities_get_vector_enrichment_job]{get_vector_enrichment_job} \tab Retrieves details of a Vector Enrichment Job for a given job Amazon Resource Name (ARN)\cr
#'  \link[=sagemakergeospatialcapabilities_list_earth_observation_jobs]{list_earth_observation_jobs} \tab Use this operation to get a list of the Earth Observation jobs associated with the calling Amazon Web Services account\cr
#'  \link[=sagemakergeospatialcapabilities_list_raster_data_collections]{list_raster_data_collections} \tab Use this operation to get raster data collections\cr
#'  \link[=sagemakergeospatialcapabilities_list_tags_for_resource]{list_tags_for_resource} \tab Lists the tags attached to the resource\cr
#'  \link[=sagemakergeospatialcapabilities_list_vector_enrichment_jobs]{list_vector_enrichment_jobs} \tab Retrieves a list of vector enrichment jobs\cr
#'  \link[=sagemakergeospatialcapabilities_search_raster_data_collection]{search_raster_data_collection} \tab Allows you run image query on a specific raster data collection to get a list of the satellite imagery matching the selected filters\cr
#'  \link[=sagemakergeospatialcapabilities_start_earth_observation_job]{start_earth_observation_job} \tab Use this operation to create an Earth observation job\cr
#'  \link[=sagemakergeospatialcapabilities_start_vector_enrichment_job]{start_vector_enrichment_job} \tab Creates a Vector Enrichment job for the supplied job type\cr
#'  \link[=sagemakergeospatialcapabilities_stop_earth_observation_job]{stop_earth_observation_job} \tab Use this operation to stop an existing earth observation job\cr
#'  \link[=sagemakergeospatialcapabilities_stop_vector_enrichment_job]{stop_vector_enrichment_job} \tab Stops the Vector Enrichment job for a given job ARN\cr
#'  \link[=sagemakergeospatialcapabilities_tag_resource]{tag_resource} \tab The resource you want to tag\cr
#'  \link[=sagemakergeospatialcapabilities_untag_resource]{untag_resource} \tab The resource you want to untag
#' }
#'
#' @return
#' A client for the service. You can call the service's operations using
#' syntax like `svc$operation(...)`, where `svc` is the name you've assigned
#' to the client. The available operations are listed in the
#' Operations section.
#'
#' @rdname sagemakergeospatialcapabilities
#' @export
sagemakergeospatialcapabilities <- function(config = list(), credentials = list(), endpoint = NULL, region = NULL) {
  config <- merge_config(
    config,
    list(
      credentials = credentials,
      endpoint = endpoint,
      region = region
    )
  )
  svc <- .sagemakergeospatialcapabilities$operations
  svc <- set_config(svc, config)
  return(svc)
}

# Private API objects: metadata, handlers, interfaces, etc.
.sagemakergeospatialcapabilities <- list()

.sagemakergeospatialcapabilities$operations <- list()

.sagemakergeospatialcapabilities$metadata <- list(
  service_name = "sagemakergeospatialcapabilities",
  endpoints = list("*" = list(endpoint = "sagemaker-geospatial.{region}.amazonaws.com", global = FALSE), "cn-*" = list(endpoint = "sagemaker-geospatial.{region}.amazonaws.com.cn", global = FALSE), "eu-isoe-*" = list(endpoint = "sagemaker-geospatial.{region}.cloud.adc-e.uk", global = FALSE), "us-iso-*" = list(endpoint = "sagemaker-geospatial.{region}.c2s.ic.gov", global = FALSE), "us-isob-*" = list(endpoint = "sagemaker-geospatial.{region}.sc2s.sgov.gov", global = FALSE), "us-isof-*" = list(endpoint = "sagemaker-geospatial.{region}.csp.hci.ic.gov", global = FALSE)),
  service_id = "SageMaker Geospatial",
  api_version = "2020-05-27",
  signing_name = "sagemaker-geospatial",
  json_version = "1.1",
  target_prefix = ""
)

.sagemakergeospatialcapabilities$service <- function(config = list()) {
  handlers <- new_handlers("restjson", "v4")
  new_service(.sagemakergeospatialcapabilities$metadata, handlers, config)
}
