# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common new_handlers new_service set_config merge_config
NULL

#' Amazon Polly
#'
#' @description
#' Amazon Polly is a web service that makes it easy to synthesize speech
#' from text.
#' 
#' The Amazon Polly service provides API operations for synthesizing
#' high-quality speech from plain text and Speech Synthesis Markup Language
#' (SSML), along with managing pronunciations lexicons that enable you to
#' get the best results for your application domain.
#'
#' @param
#' config
#' Optional configuration of credentials, endpoint, and/or region.
#' \itemize{
#' \item{\strong{credentials}: \itemize{
#' \item{\strong{creds}: \itemize{
#' \item{\strong{access_key_id}: AWS access key ID}
#' \item{\strong{secret_access_key}: AWS secret access key}
#' \item{\strong{session_token}: AWS temporary session token}
#' }}
#' \item{\strong{profile}: The name of a profile to use. If not given, then the default profile is used.}
#' \item{\strong{anonymous}: Set anonymous credentials.}
#' }}
#' \item{\strong{endpoint}: The complete URL to use for the constructed client.}
#' \item{\strong{region}: The AWS Region used in instantiating the client.}
#' \item{\strong{close_connection}: Immediately close all HTTP connections.}
#' \item{\strong{timeout}: The time in seconds till a timeout exception is thrown when attempting to make a connection. The default is 60 seconds.}
#' \item{\strong{s3_force_path_style}: Set this to `true` to force the request to use path-style addressing, i.e. `http://s3.amazonaws.com/BUCKET/KEY`.}
#' \item{\strong{sts_regional_endpoint}: Set sts regional endpoint resolver to regional or legacy \url{https://docs.aws.amazon.com/sdkref/latest/guide/feature-sts-regionalized-endpoints.html}}
#' }
#' @param
#' credentials
#' Optional credentials shorthand for the config parameter
#' \itemize{
#' \item{\strong{creds}: \itemize{
#' \item{\strong{access_key_id}: AWS access key ID}
#' \item{\strong{secret_access_key}: AWS secret access key}
#' \item{\strong{session_token}: AWS temporary session token}
#' }}
#' \item{\strong{profile}: The name of a profile to use. If not given, then the default profile is used.}
#' \item{\strong{anonymous}: Set anonymous credentials.}
#' }
#' @param
#' endpoint
#' Optional shorthand for complete URL to use for the constructed client.
#' @param
#' region
#' Optional shorthand for AWS Region used in instantiating the client.
#'
#' @section Service syntax:
#' ```
#' svc <- polly(
#'   config = list(
#'     credentials = list(
#'       creds = list(
#'         access_key_id = "string",
#'         secret_access_key = "string",
#'         session_token = "string"
#'       ),
#'       profile = "string",
#'       anonymous = "logical"
#'     ),
#'     endpoint = "string",
#'     region = "string",
#'     close_connection = "logical",
#'     timeout = "numeric",
#'     s3_force_path_style = "logical",
#'     sts_regional_endpoint = "string"
#'   ),
#'   credentials = list(
#'     creds = list(
#'       access_key_id = "string",
#'       secret_access_key = "string",
#'       session_token = "string"
#'     ),
#'     profile = "string",
#'     anonymous = "logical"
#'   ),
#'   endpoint = "string",
#'   region = "string"
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' svc <- polly()
#' # Deletes a specified pronunciation lexicon stored in an AWS Region.
#' svc$delete_lexicon(
#'   Name = "example"
#' )
#' }
#'
#' @section Operations:
#' \tabular{ll}{
#'  \link[=polly_delete_lexicon]{delete_lexicon} \tab Deletes the specified pronunciation lexicon stored in an Amazon Web Services Region\cr
#'  \link[=polly_describe_voices]{describe_voices} \tab Returns the list of voices that are available for use when requesting speech synthesis\cr
#'  \link[=polly_get_lexicon]{get_lexicon} \tab Returns the content of the specified pronunciation lexicon stored in an Amazon Web Services Region\cr
#'  \link[=polly_get_speech_synthesis_task]{get_speech_synthesis_task} \tab Retrieves a specific SpeechSynthesisTask object based on its TaskID\cr
#'  \link[=polly_list_lexicons]{list_lexicons} \tab Returns a list of pronunciation lexicons stored in an Amazon Web Services Region\cr
#'  \link[=polly_list_speech_synthesis_tasks]{list_speech_synthesis_tasks} \tab Returns a list of SpeechSynthesisTask objects ordered by their creation date\cr
#'  \link[=polly_put_lexicon]{put_lexicon} \tab Stores a pronunciation lexicon in an Amazon Web Services Region\cr
#'  \link[=polly_start_speech_synthesis_task]{start_speech_synthesis_task} \tab Allows the creation of an asynchronous synthesis task, by starting a new SpeechSynthesisTask\cr
#'  \link[=polly_synthesize_speech]{synthesize_speech} \tab Synthesizes UTF-8 input, plain text or SSML, to a stream of bytes
#' }
#'
#' @return
#' A client for the service. You can call the service's operations using
#' syntax like `svc$operation(...)`, where `svc` is the name you've assigned
#' to the client. The available operations are listed in the
#' Operations section.
#'
#' @rdname polly
#' @export
polly <- function(config = list(), credentials = list(), endpoint = NULL, region = NULL) {
  config <- merge_config(
    config,
    list(
      credentials = credentials,
      endpoint = endpoint,
      region = region
    )
  )
  svc <- .polly$operations
  svc <- set_config(svc, config)
  return(svc)
}

# Private API objects: metadata, handlers, interfaces, etc.
.polly <- list()

.polly$operations <- list()

.polly$metadata <- list(
  service_name = "polly",
  endpoints = list("*" = list(endpoint = "polly.{region}.amazonaws.com", global = FALSE), "cn-*" = list(endpoint = "polly.{region}.amazonaws.com.cn", global = FALSE), "eu-isoe-*" = list(endpoint = "polly.{region}.cloud.adc-e.uk", global = FALSE), "us-iso-*" = list(endpoint = "polly.{region}.c2s.ic.gov", global = FALSE), "us-isob-*" = list(endpoint = "polly.{region}.sc2s.sgov.gov", global = FALSE), "us-isof-*" = list(endpoint = "polly.{region}.csp.hci.ic.gov", global = FALSE)),
  service_id = "Polly",
  api_version = "2016-06-10",
  signing_name = "polly",
  json_version = "",
  target_prefix = ""
)

.polly$service <- function(config = list()) {
  handlers <- new_handlers("restjson", "v4")
  new_service(.polly$metadata, handlers, config)
}
