# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common get_config new_operation new_request send_request
#' @include machinelearning_service.R
NULL

#' Adds one or more tags to an object, up to a limit of 10
#'
#' @description
#' Adds one or more tags to an object, up to a limit of 10. Each tag consists of a key and an optional value. If you add a tag using a key that is already associated with the ML object, [`add_tags`][machinelearning_add_tags] updates the tag's value.
#'
#' See [https://www.paws-r-sdk.com/docs/machinelearning_add_tags/](https://www.paws-r-sdk.com/docs/machinelearning_add_tags/) for full documentation.
#'
#' @param Tags &#91;required&#93; The key-value pairs to use to create tags. If you specify a key without
#' specifying a value, Amazon ML creates a tag with the specified key and a
#' value of null.
#' @param ResourceId &#91;required&#93; The ID of the ML object to tag. For example, `exampleModelId`.
#' @param ResourceType &#91;required&#93; The type of the ML object to tag.
#'
#' @keywords internal
#'
#' @rdname machinelearning_add_tags
machinelearning_add_tags <- function(Tags, ResourceId, ResourceType) {
  op <- new_operation(
    name = "AddTags",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .machinelearning$add_tags_input(Tags = Tags, ResourceId = ResourceId, ResourceType = ResourceType)
  output <- .machinelearning$add_tags_output()
  config <- get_config()
  svc <- .machinelearning$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.machinelearning$operations$add_tags <- machinelearning_add_tags

#' Generates predictions for a group of observations
#'
#' @description
#' Generates predictions for a group of observations. The observations to process exist in one or more data files referenced by a `DataSource`. This operation creates a new `BatchPrediction`, and uses an `MLModel` and the data files referenced by the `DataSource` as information sources.
#'
#' See [https://www.paws-r-sdk.com/docs/machinelearning_create_batch_prediction/](https://www.paws-r-sdk.com/docs/machinelearning_create_batch_prediction/) for full documentation.
#'
#' @param BatchPredictionId &#91;required&#93; A user-supplied ID that uniquely identifies the `BatchPrediction`.
#' @param BatchPredictionName A user-supplied name or description of the `BatchPrediction`.
#' `BatchPredictionName` can only use the UTF-8 character set.
#' @param MLModelId &#91;required&#93; The ID of the `MLModel` that will generate predictions for the group of
#' observations.
#' @param BatchPredictionDataSourceId &#91;required&#93; The ID of the `DataSource` that points to the group of observations to
#' predict.
#' @param OutputUri &#91;required&#93; The location of an Amazon Simple Storage Service (Amazon S3) bucket or
#' directory to store the batch prediction results. The following
#' substrings are not allowed in the `s3 key` portion of the `outputURI`
#' field: ':', '//', '/./', '/../'.
#' 
#' Amazon ML needs permissions to store and retrieve the logs on your
#' behalf. For information about how to set permissions, see the [Amazon
#' Machine Learning Developer
#' Guide](https://docs.aws.amazon.com/machine-learning/latest/dg/).
#'
#' @keywords internal
#'
#' @rdname machinelearning_create_batch_prediction
machinelearning_create_batch_prediction <- function(BatchPredictionId, BatchPredictionName = NULL, MLModelId, BatchPredictionDataSourceId, OutputUri) {
  op <- new_operation(
    name = "CreateBatchPrediction",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .machinelearning$create_batch_prediction_input(BatchPredictionId = BatchPredictionId, BatchPredictionName = BatchPredictionName, MLModelId = MLModelId, BatchPredictionDataSourceId = BatchPredictionDataSourceId, OutputUri = OutputUri)
  output <- .machinelearning$create_batch_prediction_output()
  config <- get_config()
  svc <- .machinelearning$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.machinelearning$operations$create_batch_prediction <- machinelearning_create_batch_prediction

#' Creates a DataSource object from an Amazon Relational Database Service
#' (Amazon RDS)
#'
#' @description
#' Creates a `DataSource` object from an [Amazon Relational Database Service](https://aws.amazon.com/rds/) (Amazon RDS). A `DataSource` references data that can be used to perform [`create_ml_model`][machinelearning_create_ml_model], [`create_evaluation`][machinelearning_create_evaluation], or [`create_batch_prediction`][machinelearning_create_batch_prediction] operations.
#'
#' See [https://www.paws-r-sdk.com/docs/machinelearning_create_data_source_from_rds/](https://www.paws-r-sdk.com/docs/machinelearning_create_data_source_from_rds/) for full documentation.
#'
#' @param DataSourceId &#91;required&#93; A user-supplied ID that uniquely identifies the `DataSource`. Typically,
#' an Amazon Resource Number (ARN) becomes the ID for a `DataSource`.
#' @param DataSourceName A user-supplied name or description of the `DataSource`.
#' @param RDSData &#91;required&#93; The data specification of an Amazon RDS `DataSource`:
#' 
#' -   DatabaseInformation -
#' 
#'     -   `DatabaseName` - The name of the Amazon RDS database.
#' 
#'     -   `InstanceIdentifier ` - A unique identifier for the Amazon RDS
#'         database instance.
#' 
#' -   DatabaseCredentials - AWS Identity and Access Management (IAM)
#'     credentials that are used to connect to the Amazon RDS database.
#' 
#' -   ResourceRole - A role (DataPipelineDefaultResourceRole) assumed by
#'     an EC2 instance to carry out the copy task from Amazon RDS to Amazon
#'     Simple Storage Service (Amazon S3). For more information, see [Role
#'     templates](https://docs.aws.amazon.com/datapipeline/latest/DeveloperGuide/dp-iam-roles.html)
#'     for data pipelines.
#' 
#' -   ServiceRole - A role (DataPipelineDefaultRole) assumed by the AWS
#'     Data Pipeline service to monitor the progress of the copy task from
#'     Amazon RDS to Amazon S3. For more information, see [Role
#'     templates](https://docs.aws.amazon.com/datapipeline/latest/DeveloperGuide/dp-iam-roles.html)
#'     for data pipelines.
#' 
#' -   SecurityInfo - The security information to use to access an RDS DB
#'     instance. You need to set up appropriate ingress rules for the
#'     security entity IDs provided to allow access to the Amazon RDS
#'     instance. Specify a \[`SubnetId`, `SecurityGroupIds`\] pair for a
#'     VPC-based RDS DB instance.
#' 
#' -   SelectSqlQuery - A query that is used to retrieve the observation
#'     data for the `Datasource`.
#' 
#' -   S3StagingLocation - The Amazon S3 location for staging Amazon RDS
#'     data. The data retrieved from Amazon RDS using `SelectSqlQuery` is
#'     stored in this location.
#' 
#' -   DataSchemaUri - The Amazon S3 location of the `DataSchema`.
#' 
#' -   DataSchema - A JSON string representing the schema. This is not
#'     required if `DataSchemaUri` is specified.
#' 
#' -   DataRearrangement - A JSON string that represents the splitting and
#'     rearrangement requirements for the `Datasource`.
#' 
#'     Sample -
#'     ` "{\"splitting\":{\"percentBegin\":10,\"percentEnd\":60}}"`
#' @param RoleARN &#91;required&#93; The role that Amazon ML assumes on behalf of the user to create and
#' activate a data pipeline in the user's account and copy data using the
#' `SelectSqlQuery` query from Amazon RDS to Amazon S3.
#' @param ComputeStatistics The compute statistics for a `DataSource`. The statistics are generated
#' from the observation data referenced by a `DataSource`. Amazon ML uses
#' the statistics internally during `MLModel` training. This parameter must
#' be set to `true` if the ``DataSource`` needs to be used for `MLModel`
#' training.
#'
#' @keywords internal
#'
#' @rdname machinelearning_create_data_source_from_rds
machinelearning_create_data_source_from_rds <- function(DataSourceId, DataSourceName = NULL, RDSData, RoleARN, ComputeStatistics = NULL) {
  op <- new_operation(
    name = "CreateDataSourceFromRDS",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .machinelearning$create_data_source_from_rds_input(DataSourceId = DataSourceId, DataSourceName = DataSourceName, RDSData = RDSData, RoleARN = RoleARN, ComputeStatistics = ComputeStatistics)
  output <- .machinelearning$create_data_source_from_rds_output()
  config <- get_config()
  svc <- .machinelearning$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.machinelearning$operations$create_data_source_from_rds <- machinelearning_create_data_source_from_rds

#' Creates a DataSource from a database hosted on an Amazon Redshift
#' cluster
#'
#' @description
#' Creates a `DataSource` from a database hosted on an Amazon Redshift cluster. A `DataSource` references data that can be used to perform either [`create_ml_model`][machinelearning_create_ml_model], [`create_evaluation`][machinelearning_create_evaluation], or [`create_batch_prediction`][machinelearning_create_batch_prediction] operations.
#'
#' See [https://www.paws-r-sdk.com/docs/machinelearning_create_data_source_from_redshift/](https://www.paws-r-sdk.com/docs/machinelearning_create_data_source_from_redshift/) for full documentation.
#'
#' @param DataSourceId &#91;required&#93; A user-supplied ID that uniquely identifies the `DataSource`.
#' @param DataSourceName A user-supplied name or description of the `DataSource`.
#' @param DataSpec &#91;required&#93; The data specification of an Amazon Redshift `DataSource`:
#' 
#' -   DatabaseInformation -
#' 
#'     -   `DatabaseName` - The name of the Amazon Redshift database.
#' 
#'     -   ` ClusterIdentifier` - The unique ID for the Amazon Redshift
#'         cluster.
#' 
#' -   DatabaseCredentials - The AWS Identity and Access Management (IAM)
#'     credentials that are used to connect to the Amazon Redshift
#'     database.
#' 
#' -   SelectSqlQuery - The query that is used to retrieve the observation
#'     data for the `Datasource`.
#' 
#' -   S3StagingLocation - The Amazon Simple Storage Service (Amazon S3)
#'     location for staging Amazon Redshift data. The data retrieved from
#'     Amazon Redshift using the `SelectSqlQuery` query is stored in this
#'     location.
#' 
#' -   DataSchemaUri - The Amazon S3 location of the `DataSchema`.
#' 
#' -   DataSchema - A JSON string representing the schema. This is not
#'     required if `DataSchemaUri` is specified.
#' 
#' -   DataRearrangement - A JSON string that represents the splitting and
#'     rearrangement requirements for the `DataSource`.
#' 
#'     Sample -
#'     ` "{\"splitting\":{\"percentBegin\":10,\"percentEnd\":60}}"`
#' @param RoleARN &#91;required&#93; A fully specified role Amazon Resource Name (ARN). Amazon ML assumes the
#' role on behalf of the user to create the following:
#' 
#' -   A security group to allow Amazon ML to execute the `SelectSqlQuery`
#'     query on an Amazon Redshift cluster
#' 
#' -   An Amazon S3 bucket policy to grant Amazon ML read/write permissions
#'     on the `S3StagingLocation`
#' @param ComputeStatistics The compute statistics for a `DataSource`. The statistics are generated
#' from the observation data referenced by a `DataSource`. Amazon ML uses
#' the statistics internally during `MLModel` training. This parameter must
#' be set to `true` if the `DataSource` needs to be used for `MLModel`
#' training.
#'
#' @keywords internal
#'
#' @rdname machinelearning_create_data_source_from_redshift
machinelearning_create_data_source_from_redshift <- function(DataSourceId, DataSourceName = NULL, DataSpec, RoleARN, ComputeStatistics = NULL) {
  op <- new_operation(
    name = "CreateDataSourceFromRedshift",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .machinelearning$create_data_source_from_redshift_input(DataSourceId = DataSourceId, DataSourceName = DataSourceName, DataSpec = DataSpec, RoleARN = RoleARN, ComputeStatistics = ComputeStatistics)
  output <- .machinelearning$create_data_source_from_redshift_output()
  config <- get_config()
  svc <- .machinelearning$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.machinelearning$operations$create_data_source_from_redshift <- machinelearning_create_data_source_from_redshift

#' Creates a DataSource object
#'
#' @description
#' Creates a `DataSource` object. A `DataSource` references data that can be used to perform [`create_ml_model`][machinelearning_create_ml_model], [`create_evaluation`][machinelearning_create_evaluation], or [`create_batch_prediction`][machinelearning_create_batch_prediction] operations.
#'
#' See [https://www.paws-r-sdk.com/docs/machinelearning_create_data_source_from_s3/](https://www.paws-r-sdk.com/docs/machinelearning_create_data_source_from_s3/) for full documentation.
#'
#' @param DataSourceId &#91;required&#93; A user-supplied identifier that uniquely identifies the `DataSource`.
#' @param DataSourceName A user-supplied name or description of the `DataSource`.
#' @param DataSpec &#91;required&#93; The data specification of a `DataSource`:
#' 
#' -   DataLocationS3 - The Amazon S3 location of the observation data.
#' 
#' -   DataSchemaLocationS3 - The Amazon S3 location of the `DataSchema`.
#' 
#' -   DataSchema - A JSON string representing the schema. This is not
#'     required if `DataSchemaUri` is specified.
#' 
#' -   DataRearrangement - A JSON string that represents the splitting and
#'     rearrangement requirements for the `Datasource`.
#' 
#'     Sample -
#'     ` "{\"splitting\":{\"percentBegin\":10,\"percentEnd\":60}}"`
#' @param ComputeStatistics The compute statistics for a `DataSource`. The statistics are generated
#' from the observation data referenced by a `DataSource`. Amazon ML uses
#' the statistics internally during `MLModel` training. This parameter must
#' be set to `true` if the ``DataSource`` needs to be used for `MLModel`
#' training.
#'
#' @keywords internal
#'
#' @rdname machinelearning_create_data_source_from_s3
machinelearning_create_data_source_from_s3 <- function(DataSourceId, DataSourceName = NULL, DataSpec, ComputeStatistics = NULL) {
  op <- new_operation(
    name = "CreateDataSourceFromS3",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .machinelearning$create_data_source_from_s3_input(DataSourceId = DataSourceId, DataSourceName = DataSourceName, DataSpec = DataSpec, ComputeStatistics = ComputeStatistics)
  output <- .machinelearning$create_data_source_from_s3_output()
  config <- get_config()
  svc <- .machinelearning$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.machinelearning$operations$create_data_source_from_s3 <- machinelearning_create_data_source_from_s3

#' Creates a new Evaluation of an MLModel
#'
#' @description
#' Creates a new `Evaluation` of an `MLModel`. An `MLModel` is evaluated on a set of observations associated to a `DataSource`. Like a `DataSource` for an `MLModel`, the `DataSource` for an `Evaluation` contains values for the `Target Variable`. The `Evaluation` compares the predicted result for each observation to the actual outcome and provides a summary so that you know how effective the `MLModel` functions on the test data. Evaluation generates a relevant performance metric, such as BinaryAUC, RegressionRMSE or MulticlassAvgFScore based on the corresponding `MLModelType`: `BINARY`, `REGRESSION` or `MULTICLASS`.
#'
#' See [https://www.paws-r-sdk.com/docs/machinelearning_create_evaluation/](https://www.paws-r-sdk.com/docs/machinelearning_create_evaluation/) for full documentation.
#'
#' @param EvaluationId &#91;required&#93; A user-supplied ID that uniquely identifies the `Evaluation`.
#' @param EvaluationName A user-supplied name or description of the `Evaluation`.
#' @param MLModelId &#91;required&#93; The ID of the `MLModel` to evaluate.
#' 
#' The schema used in creating the `MLModel` must match the schema of the
#' `DataSource` used in the `Evaluation`.
#' @param EvaluationDataSourceId &#91;required&#93; The ID of the `DataSource` for the evaluation. The schema of the
#' `DataSource` must match the schema used to create the `MLModel`.
#'
#' @keywords internal
#'
#' @rdname machinelearning_create_evaluation
machinelearning_create_evaluation <- function(EvaluationId, EvaluationName = NULL, MLModelId, EvaluationDataSourceId) {
  op <- new_operation(
    name = "CreateEvaluation",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .machinelearning$create_evaluation_input(EvaluationId = EvaluationId, EvaluationName = EvaluationName, MLModelId = MLModelId, EvaluationDataSourceId = EvaluationDataSourceId)
  output <- .machinelearning$create_evaluation_output()
  config <- get_config()
  svc <- .machinelearning$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.machinelearning$operations$create_evaluation <- machinelearning_create_evaluation

#' Creates a new MLModel using the DataSource and the recipe as information
#' sources
#'
#' @description
#' Creates a new `MLModel` using the `DataSource` and the recipe as information sources.
#'
#' See [https://www.paws-r-sdk.com/docs/machinelearning_create_ml_model/](https://www.paws-r-sdk.com/docs/machinelearning_create_ml_model/) for full documentation.
#'
#' @param MLModelId &#91;required&#93; A user-supplied ID that uniquely identifies the `MLModel`.
#' @param MLModelName A user-supplied name or description of the `MLModel`.
#' @param MLModelType &#91;required&#93; The category of supervised learning that this `MLModel` will address.
#' Choose from the following types:
#' 
#' -   Choose `REGRESSION` if the `MLModel` will be used to predict a
#'     numeric value.
#' 
#' -   Choose `BINARY` if the `MLModel` result has two possible values.
#' 
#' -   Choose `MULTICLASS` if the `MLModel` result has a limited number of
#'     values.
#' 
#' For more information, see the [Amazon Machine Learning Developer
#' Guide](https://docs.aws.amazon.com/machine-learning/latest/dg/).
#' @param Parameters A list of the training parameters in the `MLModel`. The list is
#' implemented as a map of key-value pairs.
#' 
#' The following is the current set of training parameters:
#' 
#' -   `sgd.maxMLModelSizeInBytes` - The maximum allowed size of the model.
#'     Depending on the input data, the size of the model might affect its
#'     performance.
#' 
#'     The value is an integer that ranges from `100000` to `2147483648`.
#'     The default value is `33554432`.
#' 
#' -   `sgd.maxPasses` - The number of times that the training process
#'     traverses the observations to build the `MLModel`. The value is an
#'     integer that ranges from `1` to `10000`. The default value is `10`.
#' 
#' -   `sgd.shuffleType` - Whether Amazon ML shuffles the training data.
#'     Shuffling the data improves a model's ability to find the optimal
#'     solution for a variety of data types. The valid values are `auto`
#'     and `none`. The default value is `none`. We strongly recommend that
#'     you shuffle your data.
#' 
#' -   `sgd.l1RegularizationAmount` - The coefficient regularization L1
#'     norm. It controls overfitting the data by penalizing large
#'     coefficients. This tends to drive coefficients to zero, resulting in
#'     a sparse feature set. If you use this parameter, start by specifying
#'     a small value, such as `1.0E-08`.
#' 
#'     The value is a double that ranges from `0` to `MAX_DOUBLE`. The
#'     default is to not use L1 normalization. This parameter can't be used
#'     when `L2` is specified. Use this parameter sparingly.
#' 
#' -   `sgd.l2RegularizationAmount` - The coefficient regularization L2
#'     norm. It controls overfitting the data by penalizing large
#'     coefficients. This tends to drive coefficients to small, nonzero
#'     values. If you use this parameter, start by specifying a small
#'     value, such as `1.0E-08`.
#' 
#'     The value is a double that ranges from `0` to `MAX_DOUBLE`. The
#'     default is to not use L2 normalization. This parameter can't be used
#'     when `L1` is specified. Use this parameter sparingly.
#' @param TrainingDataSourceId &#91;required&#93; The `DataSource` that points to the training data.
#' @param Recipe The data recipe for creating the `MLModel`. You must specify either the
#' recipe or its URI. If you don't specify a recipe or its URI, Amazon ML
#' creates a default.
#' @param RecipeUri The Amazon Simple Storage Service (Amazon S3) location and file name
#' that contains the `MLModel` recipe. You must specify either the recipe
#' or its URI. If you don't specify a recipe or its URI, Amazon ML creates
#' a default.
#'
#' @keywords internal
#'
#' @rdname machinelearning_create_ml_model
machinelearning_create_ml_model <- function(MLModelId, MLModelName = NULL, MLModelType, Parameters = NULL, TrainingDataSourceId, Recipe = NULL, RecipeUri = NULL) {
  op <- new_operation(
    name = "CreateMLModel",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .machinelearning$create_ml_model_input(MLModelId = MLModelId, MLModelName = MLModelName, MLModelType = MLModelType, Parameters = Parameters, TrainingDataSourceId = TrainingDataSourceId, Recipe = Recipe, RecipeUri = RecipeUri)
  output <- .machinelearning$create_ml_model_output()
  config <- get_config()
  svc <- .machinelearning$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.machinelearning$operations$create_ml_model <- machinelearning_create_ml_model

#' Creates a real-time endpoint for the MLModel
#'
#' @description
#' Creates a real-time endpoint for the `MLModel`. The endpoint contains the URI of the `MLModel`; that is, the location to send real-time prediction requests for the specified `MLModel`.
#'
#' See [https://www.paws-r-sdk.com/docs/machinelearning_create_realtime_endpoint/](https://www.paws-r-sdk.com/docs/machinelearning_create_realtime_endpoint/) for full documentation.
#'
#' @param MLModelId &#91;required&#93; The ID assigned to the `MLModel` during creation.
#'
#' @keywords internal
#'
#' @rdname machinelearning_create_realtime_endpoint
machinelearning_create_realtime_endpoint <- function(MLModelId) {
  op <- new_operation(
    name = "CreateRealtimeEndpoint",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .machinelearning$create_realtime_endpoint_input(MLModelId = MLModelId)
  output <- .machinelearning$create_realtime_endpoint_output()
  config <- get_config()
  svc <- .machinelearning$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.machinelearning$operations$create_realtime_endpoint <- machinelearning_create_realtime_endpoint

#' Assigns the DELETED status to a BatchPrediction, rendering it unusable
#'
#' @description
#' Assigns the DELETED status to a `BatchPrediction`, rendering it unusable.
#'
#' See [https://www.paws-r-sdk.com/docs/machinelearning_delete_batch_prediction/](https://www.paws-r-sdk.com/docs/machinelearning_delete_batch_prediction/) for full documentation.
#'
#' @param BatchPredictionId &#91;required&#93; A user-supplied ID that uniquely identifies the `BatchPrediction`.
#'
#' @keywords internal
#'
#' @rdname machinelearning_delete_batch_prediction
machinelearning_delete_batch_prediction <- function(BatchPredictionId) {
  op <- new_operation(
    name = "DeleteBatchPrediction",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .machinelearning$delete_batch_prediction_input(BatchPredictionId = BatchPredictionId)
  output <- .machinelearning$delete_batch_prediction_output()
  config <- get_config()
  svc <- .machinelearning$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.machinelearning$operations$delete_batch_prediction <- machinelearning_delete_batch_prediction

#' Assigns the DELETED status to a DataSource, rendering it unusable
#'
#' @description
#' Assigns the DELETED status to a `DataSource`, rendering it unusable.
#'
#' See [https://www.paws-r-sdk.com/docs/machinelearning_delete_data_source/](https://www.paws-r-sdk.com/docs/machinelearning_delete_data_source/) for full documentation.
#'
#' @param DataSourceId &#91;required&#93; A user-supplied ID that uniquely identifies the `DataSource`.
#'
#' @keywords internal
#'
#' @rdname machinelearning_delete_data_source
machinelearning_delete_data_source <- function(DataSourceId) {
  op <- new_operation(
    name = "DeleteDataSource",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .machinelearning$delete_data_source_input(DataSourceId = DataSourceId)
  output <- .machinelearning$delete_data_source_output()
  config <- get_config()
  svc <- .machinelearning$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.machinelearning$operations$delete_data_source <- machinelearning_delete_data_source

#' Assigns the DELETED status to an Evaluation, rendering it unusable
#'
#' @description
#' Assigns the `DELETED` status to an `Evaluation`, rendering it unusable.
#'
#' See [https://www.paws-r-sdk.com/docs/machinelearning_delete_evaluation/](https://www.paws-r-sdk.com/docs/machinelearning_delete_evaluation/) for full documentation.
#'
#' @param EvaluationId &#91;required&#93; A user-supplied ID that uniquely identifies the `Evaluation` to delete.
#'
#' @keywords internal
#'
#' @rdname machinelearning_delete_evaluation
machinelearning_delete_evaluation <- function(EvaluationId) {
  op <- new_operation(
    name = "DeleteEvaluation",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .machinelearning$delete_evaluation_input(EvaluationId = EvaluationId)
  output <- .machinelearning$delete_evaluation_output()
  config <- get_config()
  svc <- .machinelearning$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.machinelearning$operations$delete_evaluation <- machinelearning_delete_evaluation

#' Assigns the DELETED status to an MLModel, rendering it unusable
#'
#' @description
#' Assigns the `DELETED` status to an `MLModel`, rendering it unusable.
#'
#' See [https://www.paws-r-sdk.com/docs/machinelearning_delete_ml_model/](https://www.paws-r-sdk.com/docs/machinelearning_delete_ml_model/) for full documentation.
#'
#' @param MLModelId &#91;required&#93; A user-supplied ID that uniquely identifies the `MLModel`.
#'
#' @keywords internal
#'
#' @rdname machinelearning_delete_ml_model
machinelearning_delete_ml_model <- function(MLModelId) {
  op <- new_operation(
    name = "DeleteMLModel",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .machinelearning$delete_ml_model_input(MLModelId = MLModelId)
  output <- .machinelearning$delete_ml_model_output()
  config <- get_config()
  svc <- .machinelearning$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.machinelearning$operations$delete_ml_model <- machinelearning_delete_ml_model

#' Deletes a real time endpoint of an MLModel
#'
#' @description
#' Deletes a real time endpoint of an `MLModel`.
#'
#' See [https://www.paws-r-sdk.com/docs/machinelearning_delete_realtime_endpoint/](https://www.paws-r-sdk.com/docs/machinelearning_delete_realtime_endpoint/) for full documentation.
#'
#' @param MLModelId &#91;required&#93; The ID assigned to the `MLModel` during creation.
#'
#' @keywords internal
#'
#' @rdname machinelearning_delete_realtime_endpoint
machinelearning_delete_realtime_endpoint <- function(MLModelId) {
  op <- new_operation(
    name = "DeleteRealtimeEndpoint",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .machinelearning$delete_realtime_endpoint_input(MLModelId = MLModelId)
  output <- .machinelearning$delete_realtime_endpoint_output()
  config <- get_config()
  svc <- .machinelearning$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.machinelearning$operations$delete_realtime_endpoint <- machinelearning_delete_realtime_endpoint

#' Deletes the specified tags associated with an ML object
#'
#' @description
#' Deletes the specified tags associated with an ML object. After this operation is complete, you can't recover deleted tags.
#'
#' See [https://www.paws-r-sdk.com/docs/machinelearning_delete_tags/](https://www.paws-r-sdk.com/docs/machinelearning_delete_tags/) for full documentation.
#'
#' @param TagKeys &#91;required&#93; One or more tags to delete.
#' @param ResourceId &#91;required&#93; The ID of the tagged ML object. For example, `exampleModelId`.
#' @param ResourceType &#91;required&#93; The type of the tagged ML object.
#'
#' @keywords internal
#'
#' @rdname machinelearning_delete_tags
machinelearning_delete_tags <- function(TagKeys, ResourceId, ResourceType) {
  op <- new_operation(
    name = "DeleteTags",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .machinelearning$delete_tags_input(TagKeys = TagKeys, ResourceId = ResourceId, ResourceType = ResourceType)
  output <- .machinelearning$delete_tags_output()
  config <- get_config()
  svc <- .machinelearning$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.machinelearning$operations$delete_tags <- machinelearning_delete_tags

#' Returns a list of BatchPrediction operations that match the search
#' criteria in the request
#'
#' @description
#' Returns a list of `BatchPrediction` operations that match the search criteria in the request.
#'
#' See [https://www.paws-r-sdk.com/docs/machinelearning_describe_batch_predictions/](https://www.paws-r-sdk.com/docs/machinelearning_describe_batch_predictions/) for full documentation.
#'
#' @param FilterVariable Use one of the following variables to filter a list of
#' `BatchPrediction`:
#' 
#' -   `CreatedAt` - Sets the search criteria to the `BatchPrediction`
#'     creation date.
#' 
#' -   `Status` - Sets the search criteria to the `BatchPrediction` status.
#' 
#' -   `Name` - Sets the search criteria to the contents of the
#'     `BatchPrediction` `Name`.
#' 
#' -   `IAMUser` - Sets the search criteria to the user account that
#'     invoked the `BatchPrediction` creation.
#' 
#' -   `MLModelId` - Sets the search criteria to the `MLModel` used in the
#'     `BatchPrediction`.
#' 
#' -   `DataSourceId` - Sets the search criteria to the `DataSource` used
#'     in the `BatchPrediction`.
#' 
#' -   `DataURI` - Sets the search criteria to the data file(s) used in the
#'     `BatchPrediction`. The URL can identify either a file or an Amazon
#'     Simple Storage Solution (Amazon S3) bucket or directory.
#' @param EQ The equal to operator. The `BatchPrediction` results will have
#' `FilterVariable` values that exactly match the value specified with
#' `EQ`.
#' @param GT The greater than operator. The `BatchPrediction` results will have
#' `FilterVariable` values that are greater than the value specified with
#' `GT`.
#' @param LT The less than operator. The `BatchPrediction` results will have
#' `FilterVariable` values that are less than the value specified with
#' `LT`.
#' @param GE The greater than or equal to operator. The `BatchPrediction` results
#' will have `FilterVariable` values that are greater than or equal to the
#' value specified with `GE`.
#' @param LE The less than or equal to operator. The `BatchPrediction` results will
#' have `FilterVariable` values that are less than or equal to the value
#' specified with `LE`.
#' @param NE The not equal to operator. The `BatchPrediction` results will have
#' `FilterVariable` values not equal to the value specified with `NE`.
#' @param Prefix A string that is found at the beginning of a variable, such as `Name` or
#' `Id`.
#' 
#' For example, a `Batch Prediction` operation could have the `Name`
#' `2014-09-09-HolidayGiftMailer`. To search for this `BatchPrediction`,
#' select `Name` for the `FilterVariable` and any of the following strings
#' for the `Prefix`:
#' 
#' -   2014-09
#' 
#' -   2014-09-09
#' 
#' -   2014-09-09-Holiday
#' @param SortOrder A two-value parameter that determines the sequence of the resulting list
#' of `MLModel`s.
#' 
#' -   `asc` - Arranges the list in ascending order (A-Z, 0-9).
#' 
#' -   `dsc` - Arranges the list in descending order (Z-A, 9-0).
#' 
#' Results are sorted by `FilterVariable`.
#' @param NextToken An ID of the page in the paginated results.
#' @param Limit The number of pages of information to include in the result. The range
#' of acceptable values is `1` through `100`. The default value is `100`.
#'
#' @keywords internal
#'
#' @rdname machinelearning_describe_batch_predictions
machinelearning_describe_batch_predictions <- function(FilterVariable = NULL, EQ = NULL, GT = NULL, LT = NULL, GE = NULL, LE = NULL, NE = NULL, Prefix = NULL, SortOrder = NULL, NextToken = NULL, Limit = NULL) {
  op <- new_operation(
    name = "DescribeBatchPredictions",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .machinelearning$describe_batch_predictions_input(FilterVariable = FilterVariable, EQ = EQ, GT = GT, LT = LT, GE = GE, LE = LE, NE = NE, Prefix = Prefix, SortOrder = SortOrder, NextToken = NextToken, Limit = Limit)
  output <- .machinelearning$describe_batch_predictions_output()
  config <- get_config()
  svc <- .machinelearning$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.machinelearning$operations$describe_batch_predictions <- machinelearning_describe_batch_predictions

#' Returns a list of DataSource that match the search criteria in the
#' request
#'
#' @description
#' Returns a list of `DataSource` that match the search criteria in the request.
#'
#' See [https://www.paws-r-sdk.com/docs/machinelearning_describe_data_sources/](https://www.paws-r-sdk.com/docs/machinelearning_describe_data_sources/) for full documentation.
#'
#' @param FilterVariable Use one of the following variables to filter a list of `DataSource`:
#' 
#' -   `CreatedAt` - Sets the search criteria to `DataSource` creation
#'     dates.
#' 
#' -   `Status` - Sets the search criteria to `DataSource` statuses.
#' 
#' -   `Name` - Sets the search criteria to the contents of `DataSource`
#'     `Name`.
#' 
#' -   `DataUri` - Sets the search criteria to the URI of data files used
#'     to create the `DataSource`. The URI can identify either a file or an
#'     Amazon Simple Storage Service (Amazon S3) bucket or directory.
#' 
#' -   `IAMUser` - Sets the search criteria to the user account that
#'     invoked the `DataSource` creation.
#' @param EQ The equal to operator. The `DataSource` results will have
#' `FilterVariable` values that exactly match the value specified with
#' `EQ`.
#' @param GT The greater than operator. The `DataSource` results will have
#' `FilterVariable` values that are greater than the value specified with
#' `GT`.
#' @param LT The less than operator. The `DataSource` results will have
#' `FilterVariable` values that are less than the value specified with
#' `LT`.
#' @param GE The greater than or equal to operator. The `DataSource` results will
#' have `FilterVariable` values that are greater than or equal to the value
#' specified with `GE`.
#' @param LE The less than or equal to operator. The `DataSource` results will have
#' `FilterVariable` values that are less than or equal to the value
#' specified with `LE`.
#' @param NE The not equal to operator. The `DataSource` results will have
#' `FilterVariable` values not equal to the value specified with `NE`.
#' @param Prefix A string that is found at the beginning of a variable, such as `Name` or
#' `Id`.
#' 
#' For example, a `DataSource` could have the `Name`
#' `2014-09-09-HolidayGiftMailer`. To search for this `DataSource`, select
#' `Name` for the `FilterVariable` and any of the following strings for the
#' `Prefix`:
#' 
#' -   2014-09
#' 
#' -   2014-09-09
#' 
#' -   2014-09-09-Holiday
#' @param SortOrder A two-value parameter that determines the sequence of the resulting list
#' of `DataSource`.
#' 
#' -   `asc` - Arranges the list in ascending order (A-Z, 0-9).
#' 
#' -   `dsc` - Arranges the list in descending order (Z-A, 9-0).
#' 
#' Results are sorted by `FilterVariable`.
#' @param NextToken The ID of the page in the paginated results.
#' @param Limit The maximum number of `DataSource` to include in the result.
#'
#' @keywords internal
#'
#' @rdname machinelearning_describe_data_sources
machinelearning_describe_data_sources <- function(FilterVariable = NULL, EQ = NULL, GT = NULL, LT = NULL, GE = NULL, LE = NULL, NE = NULL, Prefix = NULL, SortOrder = NULL, NextToken = NULL, Limit = NULL) {
  op <- new_operation(
    name = "DescribeDataSources",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .machinelearning$describe_data_sources_input(FilterVariable = FilterVariable, EQ = EQ, GT = GT, LT = LT, GE = GE, LE = LE, NE = NE, Prefix = Prefix, SortOrder = SortOrder, NextToken = NextToken, Limit = Limit)
  output <- .machinelearning$describe_data_sources_output()
  config <- get_config()
  svc <- .machinelearning$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.machinelearning$operations$describe_data_sources <- machinelearning_describe_data_sources

#' Returns a list of DescribeEvaluations that match the search criteria in
#' the request
#'
#' @description
#' Returns a list of [`describe_evaluations`][machinelearning_describe_evaluations] that match the search criteria in the request.
#'
#' See [https://www.paws-r-sdk.com/docs/machinelearning_describe_evaluations/](https://www.paws-r-sdk.com/docs/machinelearning_describe_evaluations/) for full documentation.
#'
#' @param FilterVariable Use one of the following variable to filter a list of `Evaluation`
#' objects:
#' 
#' -   `CreatedAt` - Sets the search criteria to the `Evaluation` creation
#'     date.
#' 
#' -   `Status` - Sets the search criteria to the `Evaluation` status.
#' 
#' -   `Name` - Sets the search criteria to the contents of `Evaluation`
#'     `Name`.
#' 
#' -   `IAMUser` - Sets the search criteria to the user account that
#'     invoked an `Evaluation`.
#' 
#' -   `MLModelId` - Sets the search criteria to the `MLModel` that was
#'     evaluated.
#' 
#' -   `DataSourceId` - Sets the search criteria to the `DataSource` used
#'     in `Evaluation`.
#' 
#' -   `DataUri` - Sets the search criteria to the data file(s) used in
#'     `Evaluation`. The URL can identify either a file or an Amazon Simple
#'     Storage Solution (Amazon S3) bucket or directory.
#' @param EQ The equal to operator. The `Evaluation` results will have
#' `FilterVariable` values that exactly match the value specified with
#' `EQ`.
#' @param GT The greater than operator. The `Evaluation` results will have
#' `FilterVariable` values that are greater than the value specified with
#' `GT`.
#' @param LT The less than operator. The `Evaluation` results will have
#' `FilterVariable` values that are less than the value specified with
#' `LT`.
#' @param GE The greater than or equal to operator. The `Evaluation` results will
#' have `FilterVariable` values that are greater than or equal to the value
#' specified with `GE`.
#' @param LE The less than or equal to operator. The `Evaluation` results will have
#' `FilterVariable` values that are less than or equal to the value
#' specified with `LE`.
#' @param NE The not equal to operator. The `Evaluation` results will have
#' `FilterVariable` values not equal to the value specified with `NE`.
#' @param Prefix A string that is found at the beginning of a variable, such as `Name` or
#' `Id`.
#' 
#' For example, an `Evaluation` could have the `Name`
#' `2014-09-09-HolidayGiftMailer`. To search for this `Evaluation`, select
#' `Name` for the `FilterVariable` and any of the following strings for the
#' `Prefix`:
#' 
#' -   2014-09
#' 
#' -   2014-09-09
#' 
#' -   2014-09-09-Holiday
#' @param SortOrder A two-value parameter that determines the sequence of the resulting list
#' of `Evaluation`.
#' 
#' -   `asc` - Arranges the list in ascending order (A-Z, 0-9).
#' 
#' -   `dsc` - Arranges the list in descending order (Z-A, 9-0).
#' 
#' Results are sorted by `FilterVariable`.
#' @param NextToken The ID of the page in the paginated results.
#' @param Limit The maximum number of `Evaluation` to include in the result.
#'
#' @keywords internal
#'
#' @rdname machinelearning_describe_evaluations
machinelearning_describe_evaluations <- function(FilterVariable = NULL, EQ = NULL, GT = NULL, LT = NULL, GE = NULL, LE = NULL, NE = NULL, Prefix = NULL, SortOrder = NULL, NextToken = NULL, Limit = NULL) {
  op <- new_operation(
    name = "DescribeEvaluations",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .machinelearning$describe_evaluations_input(FilterVariable = FilterVariable, EQ = EQ, GT = GT, LT = LT, GE = GE, LE = LE, NE = NE, Prefix = Prefix, SortOrder = SortOrder, NextToken = NextToken, Limit = Limit)
  output <- .machinelearning$describe_evaluations_output()
  config <- get_config()
  svc <- .machinelearning$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.machinelearning$operations$describe_evaluations <- machinelearning_describe_evaluations

#' Returns a list of MLModel that match the search criteria in the request
#'
#' @description
#' Returns a list of `MLModel` that match the search criteria in the request.
#'
#' See [https://www.paws-r-sdk.com/docs/machinelearning_describe_ml_models/](https://www.paws-r-sdk.com/docs/machinelearning_describe_ml_models/) for full documentation.
#'
#' @param FilterVariable Use one of the following variables to filter a list of `MLModel`:
#' 
#' -   `CreatedAt` - Sets the search criteria to `MLModel` creation date.
#' 
#' -   `Status` - Sets the search criteria to `MLModel` status.
#' 
#' -   `Name` - Sets the search criteria to the contents of `MLModel`
#'     `Name`.
#' 
#' -   `IAMUser` - Sets the search criteria to the user account that
#'     invoked the `MLModel` creation.
#' 
#' -   `TrainingDataSourceId` - Sets the search criteria to the
#'     `DataSource` used to train one or more `MLModel`.
#' 
#' -   `RealtimeEndpointStatus` - Sets the search criteria to the `MLModel`
#'     real-time endpoint status.
#' 
#' -   `MLModelType` - Sets the search criteria to `MLModel` type: binary,
#'     regression, or multi-class.
#' 
#' -   `Algorithm` - Sets the search criteria to the algorithm that the
#'     `MLModel` uses.
#' 
#' -   `TrainingDataURI` - Sets the search criteria to the data file(s)
#'     used in training a `MLModel`. The URL can identify either a file or
#'     an Amazon Simple Storage Service (Amazon S3) bucket or directory.
#' @param EQ The equal to operator. The `MLModel` results will have `FilterVariable`
#' values that exactly match the value specified with `EQ`.
#' @param GT The greater than operator. The `MLModel` results will have
#' `FilterVariable` values that are greater than the value specified with
#' `GT`.
#' @param LT The less than operator. The `MLModel` results will have `FilterVariable`
#' values that are less than the value specified with `LT`.
#' @param GE The greater than or equal to operator. The `MLModel` results will have
#' `FilterVariable` values that are greater than or equal to the value
#' specified with `GE`.
#' @param LE The less than or equal to operator. The `MLModel` results will have
#' `FilterVariable` values that are less than or equal to the value
#' specified with `LE`.
#' @param NE The not equal to operator. The `MLModel` results will have
#' `FilterVariable` values not equal to the value specified with `NE`.
#' @param Prefix A string that is found at the beginning of a variable, such as `Name` or
#' `Id`.
#' 
#' For example, an `MLModel` could have the `Name`
#' `2014-09-09-HolidayGiftMailer`. To search for this `MLModel`, select
#' `Name` for the `FilterVariable` and any of the following strings for the
#' `Prefix`:
#' 
#' -   2014-09
#' 
#' -   2014-09-09
#' 
#' -   2014-09-09-Holiday
#' @param SortOrder A two-value parameter that determines the sequence of the resulting list
#' of `MLModel`.
#' 
#' -   `asc` - Arranges the list in ascending order (A-Z, 0-9).
#' 
#' -   `dsc` - Arranges the list in descending order (Z-A, 9-0).
#' 
#' Results are sorted by `FilterVariable`.
#' @param NextToken The ID of the page in the paginated results.
#' @param Limit The number of pages of information to include in the result. The range
#' of acceptable values is `1` through `100`. The default value is `100`.
#'
#' @keywords internal
#'
#' @rdname machinelearning_describe_ml_models
machinelearning_describe_ml_models <- function(FilterVariable = NULL, EQ = NULL, GT = NULL, LT = NULL, GE = NULL, LE = NULL, NE = NULL, Prefix = NULL, SortOrder = NULL, NextToken = NULL, Limit = NULL) {
  op <- new_operation(
    name = "DescribeMLModels",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .machinelearning$describe_ml_models_input(FilterVariable = FilterVariable, EQ = EQ, GT = GT, LT = LT, GE = GE, LE = LE, NE = NE, Prefix = Prefix, SortOrder = SortOrder, NextToken = NextToken, Limit = Limit)
  output <- .machinelearning$describe_ml_models_output()
  config <- get_config()
  svc <- .machinelearning$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.machinelearning$operations$describe_ml_models <- machinelearning_describe_ml_models

#' Describes one or more of the tags for your Amazon ML object
#'
#' @description
#' Describes one or more of the tags for your Amazon ML object.
#'
#' See [https://www.paws-r-sdk.com/docs/machinelearning_describe_tags/](https://www.paws-r-sdk.com/docs/machinelearning_describe_tags/) for full documentation.
#'
#' @param ResourceId &#91;required&#93; The ID of the ML object. For example, `exampleModelId`.
#' @param ResourceType &#91;required&#93; The type of the ML object.
#'
#' @keywords internal
#'
#' @rdname machinelearning_describe_tags
machinelearning_describe_tags <- function(ResourceId, ResourceType) {
  op <- new_operation(
    name = "DescribeTags",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .machinelearning$describe_tags_input(ResourceId = ResourceId, ResourceType = ResourceType)
  output <- .machinelearning$describe_tags_output()
  config <- get_config()
  svc <- .machinelearning$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.machinelearning$operations$describe_tags <- machinelearning_describe_tags

#' Returns a BatchPrediction that includes detailed metadata, status, and
#' data file information for a Batch Prediction request
#'
#' @description
#' Returns a `BatchPrediction` that includes detailed metadata, status, and data file information for a `Batch Prediction` request.
#'
#' See [https://www.paws-r-sdk.com/docs/machinelearning_get_batch_prediction/](https://www.paws-r-sdk.com/docs/machinelearning_get_batch_prediction/) for full documentation.
#'
#' @param BatchPredictionId &#91;required&#93; An ID assigned to the `BatchPrediction` at creation.
#'
#' @keywords internal
#'
#' @rdname machinelearning_get_batch_prediction
machinelearning_get_batch_prediction <- function(BatchPredictionId) {
  op <- new_operation(
    name = "GetBatchPrediction",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .machinelearning$get_batch_prediction_input(BatchPredictionId = BatchPredictionId)
  output <- .machinelearning$get_batch_prediction_output()
  config <- get_config()
  svc <- .machinelearning$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.machinelearning$operations$get_batch_prediction <- machinelearning_get_batch_prediction

#' Returns a DataSource that includes metadata and data file information,
#' as well as the current status of the DataSource
#'
#' @description
#' Returns a `DataSource` that includes metadata and data file information, as well as the current status of the `DataSource`.
#'
#' See [https://www.paws-r-sdk.com/docs/machinelearning_get_data_source/](https://www.paws-r-sdk.com/docs/machinelearning_get_data_source/) for full documentation.
#'
#' @param DataSourceId &#91;required&#93; The ID assigned to the `DataSource` at creation.
#' @param Verbose Specifies whether the
#' [`get_data_source`][machinelearning_get_data_source] operation should
#' return `DataSourceSchema`.
#' 
#' If true, `DataSourceSchema` is returned.
#' 
#' If false, `DataSourceSchema` is not returned.
#'
#' @keywords internal
#'
#' @rdname machinelearning_get_data_source
machinelearning_get_data_source <- function(DataSourceId, Verbose = NULL) {
  op <- new_operation(
    name = "GetDataSource",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .machinelearning$get_data_source_input(DataSourceId = DataSourceId, Verbose = Verbose)
  output <- .machinelearning$get_data_source_output()
  config <- get_config()
  svc <- .machinelearning$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.machinelearning$operations$get_data_source <- machinelearning_get_data_source

#' Returns an Evaluation that includes metadata as well as the current
#' status of the Evaluation
#'
#' @description
#' Returns an `Evaluation` that includes metadata as well as the current status of the `Evaluation`.
#'
#' See [https://www.paws-r-sdk.com/docs/machinelearning_get_evaluation/](https://www.paws-r-sdk.com/docs/machinelearning_get_evaluation/) for full documentation.
#'
#' @param EvaluationId &#91;required&#93; The ID of the `Evaluation` to retrieve. The evaluation of each `MLModel`
#' is recorded and cataloged. The ID provides the means to access the
#' information.
#'
#' @keywords internal
#'
#' @rdname machinelearning_get_evaluation
machinelearning_get_evaluation <- function(EvaluationId) {
  op <- new_operation(
    name = "GetEvaluation",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .machinelearning$get_evaluation_input(EvaluationId = EvaluationId)
  output <- .machinelearning$get_evaluation_output()
  config <- get_config()
  svc <- .machinelearning$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.machinelearning$operations$get_evaluation <- machinelearning_get_evaluation

#' Returns an MLModel that includes detailed metadata, data source
#' information, and the current status of the MLModel
#'
#' @description
#' Returns an `MLModel` that includes detailed metadata, data source information, and the current status of the `MLModel`.
#'
#' See [https://www.paws-r-sdk.com/docs/machinelearning_get_ml_model/](https://www.paws-r-sdk.com/docs/machinelearning_get_ml_model/) for full documentation.
#'
#' @param MLModelId &#91;required&#93; The ID assigned to the `MLModel` at creation.
#' @param Verbose Specifies whether the [`get_ml_model`][machinelearning_get_ml_model]
#' operation should return `Recipe`.
#' 
#' If true, `Recipe` is returned.
#' 
#' If false, `Recipe` is not returned.
#'
#' @keywords internal
#'
#' @rdname machinelearning_get_ml_model
machinelearning_get_ml_model <- function(MLModelId, Verbose = NULL) {
  op <- new_operation(
    name = "GetMLModel",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .machinelearning$get_ml_model_input(MLModelId = MLModelId, Verbose = Verbose)
  output <- .machinelearning$get_ml_model_output()
  config <- get_config()
  svc <- .machinelearning$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.machinelearning$operations$get_ml_model <- machinelearning_get_ml_model

#' Generates a prediction for the observation using the specified ML Model
#'
#' @description
#' Generates a prediction for the observation using the specified `ML Model`.
#'
#' See [https://www.paws-r-sdk.com/docs/machinelearning_predict/](https://www.paws-r-sdk.com/docs/machinelearning_predict/) for full documentation.
#'
#' @param MLModelId &#91;required&#93; A unique identifier of the `MLModel`.
#' @param Record &#91;required&#93; 
#' @param PredictEndpoint &#91;required&#93; 
#'
#' @keywords internal
#'
#' @rdname machinelearning_predict
machinelearning_predict <- function(MLModelId, Record, PredictEndpoint) {
  op <- new_operation(
    name = "Predict",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .machinelearning$predict_input(MLModelId = MLModelId, Record = Record, PredictEndpoint = PredictEndpoint)
  output <- .machinelearning$predict_output()
  config <- get_config()
  svc <- .machinelearning$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.machinelearning$operations$predict <- machinelearning_predict

#' Updates the BatchPredictionName of a BatchPrediction
#'
#' @description
#' Updates the `BatchPredictionName` of a `BatchPrediction`.
#'
#' See [https://www.paws-r-sdk.com/docs/machinelearning_update_batch_prediction/](https://www.paws-r-sdk.com/docs/machinelearning_update_batch_prediction/) for full documentation.
#'
#' @param BatchPredictionId &#91;required&#93; The ID assigned to the `BatchPrediction` during creation.
#' @param BatchPredictionName &#91;required&#93; A new user-supplied name or description of the `BatchPrediction`.
#'
#' @keywords internal
#'
#' @rdname machinelearning_update_batch_prediction
machinelearning_update_batch_prediction <- function(BatchPredictionId, BatchPredictionName) {
  op <- new_operation(
    name = "UpdateBatchPrediction",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .machinelearning$update_batch_prediction_input(BatchPredictionId = BatchPredictionId, BatchPredictionName = BatchPredictionName)
  output <- .machinelearning$update_batch_prediction_output()
  config <- get_config()
  svc <- .machinelearning$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.machinelearning$operations$update_batch_prediction <- machinelearning_update_batch_prediction

#' Updates the DataSourceName of a DataSource
#'
#' @description
#' Updates the `DataSourceName` of a `DataSource`.
#'
#' See [https://www.paws-r-sdk.com/docs/machinelearning_update_data_source/](https://www.paws-r-sdk.com/docs/machinelearning_update_data_source/) for full documentation.
#'
#' @param DataSourceId &#91;required&#93; The ID assigned to the `DataSource` during creation.
#' @param DataSourceName &#91;required&#93; A new user-supplied name or description of the `DataSource` that will
#' replace the current description.
#'
#' @keywords internal
#'
#' @rdname machinelearning_update_data_source
machinelearning_update_data_source <- function(DataSourceId, DataSourceName) {
  op <- new_operation(
    name = "UpdateDataSource",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .machinelearning$update_data_source_input(DataSourceId = DataSourceId, DataSourceName = DataSourceName)
  output <- .machinelearning$update_data_source_output()
  config <- get_config()
  svc <- .machinelearning$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.machinelearning$operations$update_data_source <- machinelearning_update_data_source

#' Updates the EvaluationName of an Evaluation
#'
#' @description
#' Updates the `EvaluationName` of an `Evaluation`.
#'
#' See [https://www.paws-r-sdk.com/docs/machinelearning_update_evaluation/](https://www.paws-r-sdk.com/docs/machinelearning_update_evaluation/) for full documentation.
#'
#' @param EvaluationId &#91;required&#93; The ID assigned to the `Evaluation` during creation.
#' @param EvaluationName &#91;required&#93; A new user-supplied name or description of the `Evaluation` that will
#' replace the current content.
#'
#' @keywords internal
#'
#' @rdname machinelearning_update_evaluation
machinelearning_update_evaluation <- function(EvaluationId, EvaluationName) {
  op <- new_operation(
    name = "UpdateEvaluation",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .machinelearning$update_evaluation_input(EvaluationId = EvaluationId, EvaluationName = EvaluationName)
  output <- .machinelearning$update_evaluation_output()
  config <- get_config()
  svc <- .machinelearning$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.machinelearning$operations$update_evaluation <- machinelearning_update_evaluation

#' Updates the MLModelName and the ScoreThreshold of an MLModel
#'
#' @description
#' Updates the `MLModelName` and the `ScoreThreshold` of an `MLModel`.
#'
#' See [https://www.paws-r-sdk.com/docs/machinelearning_update_ml_model/](https://www.paws-r-sdk.com/docs/machinelearning_update_ml_model/) for full documentation.
#'
#' @param MLModelId &#91;required&#93; The ID assigned to the `MLModel` during creation.
#' @param MLModelName A user-supplied name or description of the `MLModel`.
#' @param ScoreThreshold The `ScoreThreshold` used in binary classification `MLModel` that marks
#' the boundary between a positive prediction and a negative prediction.
#' 
#' Output values greater than or equal to the `ScoreThreshold` receive a
#' positive result from the `MLModel`, such as `true`. Output values less
#' than the `ScoreThreshold` receive a negative response from the
#' `MLModel`, such as `false`.
#'
#' @keywords internal
#'
#' @rdname machinelearning_update_ml_model
machinelearning_update_ml_model <- function(MLModelId, MLModelName = NULL, ScoreThreshold = NULL) {
  op <- new_operation(
    name = "UpdateMLModel",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .machinelearning$update_ml_model_input(MLModelId = MLModelId, MLModelName = MLModelName, ScoreThreshold = ScoreThreshold)
  output <- .machinelearning$update_ml_model_output()
  config <- get_config()
  svc <- .machinelearning$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.machinelearning$operations$update_ml_model <- machinelearning_update_ml_model
