# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common get_config new_operation new_request send_request
#' @include panorama_service.R
NULL

#' Creates an application instance and deploys it to a device
#'
#' @description
#' Creates an application instance and deploys it to a device.
#'
#' See [https://paws-r.github.io/docs/panorama/create_application_instance.html](https://paws-r.github.io/docs/panorama/create_application_instance.html) for full documentation.
#'
#' @param ApplicationInstanceIdToReplace The ID of an application instance to replace with the new instance.
#' @param DefaultRuntimeContextDevice &#91;required&#93; A device's ID.
#' @param Description A description for the application instance.
#' @param ManifestOverridesPayload Setting overrides for the application manifest.
#' @param ManifestPayload &#91;required&#93; The application's manifest document.
#' @param Name A name for the application instance.
#' @param RuntimeRoleArn The ARN of a runtime role for the application instance.
#' @param Tags Tags for the application instance.
#'
#' @keywords internal
#'
#' @rdname panorama_create_application_instance
panorama_create_application_instance <- function(ApplicationInstanceIdToReplace = NULL, DefaultRuntimeContextDevice, Description = NULL, ManifestOverridesPayload = NULL, ManifestPayload, Name = NULL, RuntimeRoleArn = NULL, Tags = NULL) {
  op <- new_operation(
    name = "CreateApplicationInstance",
    http_method = "POST",
    http_path = "/application-instances",
    paginator = list()
  )
  input <- .panorama$create_application_instance_input(ApplicationInstanceIdToReplace = ApplicationInstanceIdToReplace, DefaultRuntimeContextDevice = DefaultRuntimeContextDevice, Description = Description, ManifestOverridesPayload = ManifestOverridesPayload, ManifestPayload = ManifestPayload, Name = Name, RuntimeRoleArn = RuntimeRoleArn, Tags = Tags)
  output <- .panorama$create_application_instance_output()
  config <- get_config()
  svc <- .panorama$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.panorama$operations$create_application_instance <- panorama_create_application_instance

#' Creates a job to run on one or more devices
#'
#' @description
#' Creates a job to run on one or more devices.
#'
#' See [https://paws-r.github.io/docs/panorama/create_job_for_devices.html](https://paws-r.github.io/docs/panorama/create_job_for_devices.html) for full documentation.
#'
#' @param DeviceIds &#91;required&#93; IDs of target devices.
#' @param DeviceJobConfig &#91;required&#93; Configuration settings for the job.
#' @param JobType &#91;required&#93; The type of job to run.
#'
#' @keywords internal
#'
#' @rdname panorama_create_job_for_devices
panorama_create_job_for_devices <- function(DeviceIds, DeviceJobConfig, JobType) {
  op <- new_operation(
    name = "CreateJobForDevices",
    http_method = "POST",
    http_path = "/jobs",
    paginator = list()
  )
  input <- .panorama$create_job_for_devices_input(DeviceIds = DeviceIds, DeviceJobConfig = DeviceJobConfig, JobType = JobType)
  output <- .panorama$create_job_for_devices_output()
  config <- get_config()
  svc <- .panorama$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.panorama$operations$create_job_for_devices <- panorama_create_job_for_devices

#' Creates a camera stream node
#'
#' @description
#' Creates a camera stream node.
#'
#' See [https://paws-r.github.io/docs/panorama/create_node_from_template_job.html](https://paws-r.github.io/docs/panorama/create_node_from_template_job.html) for full documentation.
#'
#' @param JobTags Tags for the job.
#' @param NodeDescription A description for the node.
#' @param NodeName &#91;required&#93; A name for the node.
#' @param OutputPackageName &#91;required&#93; An output package name for the node.
#' @param OutputPackageVersion &#91;required&#93; An output package version for the node.
#' @param TemplateParameters &#91;required&#93; Template parameters for the node.
#' @param TemplateType &#91;required&#93; The type of node.
#'
#' @keywords internal
#'
#' @rdname panorama_create_node_from_template_job
panorama_create_node_from_template_job <- function(JobTags = NULL, NodeDescription = NULL, NodeName, OutputPackageName, OutputPackageVersion, TemplateParameters, TemplateType) {
  op <- new_operation(
    name = "CreateNodeFromTemplateJob",
    http_method = "POST",
    http_path = "/packages/template-job",
    paginator = list()
  )
  input <- .panorama$create_node_from_template_job_input(JobTags = JobTags, NodeDescription = NodeDescription, NodeName = NodeName, OutputPackageName = OutputPackageName, OutputPackageVersion = OutputPackageVersion, TemplateParameters = TemplateParameters, TemplateType = TemplateType)
  output <- .panorama$create_node_from_template_job_output()
  config <- get_config()
  svc <- .panorama$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.panorama$operations$create_node_from_template_job <- panorama_create_node_from_template_job

#' Creates a package and storage location in an Amazon S3 access point
#'
#' @description
#' Creates a package and storage location in an Amazon S3 access point.
#'
#' See [https://paws-r.github.io/docs/panorama/create_package.html](https://paws-r.github.io/docs/panorama/create_package.html) for full documentation.
#'
#' @param PackageName &#91;required&#93; A name for the package.
#' @param Tags Tags for the package.
#'
#' @keywords internal
#'
#' @rdname panorama_create_package
panorama_create_package <- function(PackageName, Tags = NULL) {
  op <- new_operation(
    name = "CreatePackage",
    http_method = "POST",
    http_path = "/packages",
    paginator = list()
  )
  input <- .panorama$create_package_input(PackageName = PackageName, Tags = Tags)
  output <- .panorama$create_package_output()
  config <- get_config()
  svc <- .panorama$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.panorama$operations$create_package <- panorama_create_package

#' Imports a node package
#'
#' @description
#' Imports a node package.
#'
#' See [https://paws-r.github.io/docs/panorama/create_package_import_job.html](https://paws-r.github.io/docs/panorama/create_package_import_job.html) for full documentation.
#'
#' @param ClientToken &#91;required&#93; A client token for the package import job.
#' @param InputConfig &#91;required&#93; An input config for the package import job.
#' @param JobTags Tags for the package import job.
#' @param JobType &#91;required&#93; A job type for the package import job.
#' @param OutputConfig &#91;required&#93; An output config for the package import job.
#'
#' @keywords internal
#'
#' @rdname panorama_create_package_import_job
panorama_create_package_import_job <- function(ClientToken, InputConfig, JobTags = NULL, JobType, OutputConfig) {
  op <- new_operation(
    name = "CreatePackageImportJob",
    http_method = "POST",
    http_path = "/packages/import-jobs",
    paginator = list()
  )
  input <- .panorama$create_package_import_job_input(ClientToken = ClientToken, InputConfig = InputConfig, JobTags = JobTags, JobType = JobType, OutputConfig = OutputConfig)
  output <- .panorama$create_package_import_job_output()
  config <- get_config()
  svc <- .panorama$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.panorama$operations$create_package_import_job <- panorama_create_package_import_job

#' Deletes a device
#'
#' @description
#' Deletes a device.
#'
#' See [https://paws-r.github.io/docs/panorama/delete_device.html](https://paws-r.github.io/docs/panorama/delete_device.html) for full documentation.
#'
#' @param DeviceId &#91;required&#93; The device's ID.
#'
#' @keywords internal
#'
#' @rdname panorama_delete_device
panorama_delete_device <- function(DeviceId) {
  op <- new_operation(
    name = "DeleteDevice",
    http_method = "DELETE",
    http_path = "/devices/{DeviceId}",
    paginator = list()
  )
  input <- .panorama$delete_device_input(DeviceId = DeviceId)
  output <- .panorama$delete_device_output()
  config <- get_config()
  svc <- .panorama$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.panorama$operations$delete_device <- panorama_delete_device

#' Deletes a package
#'
#' @description
#' Deletes a package.
#'
#' See [https://paws-r.github.io/docs/panorama/delete_package.html](https://paws-r.github.io/docs/panorama/delete_package.html) for full documentation.
#'
#' @param ForceDelete Delete the package even if it has artifacts stored in its access point.
#' Deletes the package's artifacts from Amazon S3.
#' @param PackageId &#91;required&#93; The package's ID.
#'
#' @keywords internal
#'
#' @rdname panorama_delete_package
panorama_delete_package <- function(ForceDelete = NULL, PackageId) {
  op <- new_operation(
    name = "DeletePackage",
    http_method = "DELETE",
    http_path = "/packages/{PackageId}",
    paginator = list()
  )
  input <- .panorama$delete_package_input(ForceDelete = ForceDelete, PackageId = PackageId)
  output <- .panorama$delete_package_output()
  config <- get_config()
  svc <- .panorama$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.panorama$operations$delete_package <- panorama_delete_package

#' Deregisters a package version
#'
#' @description
#' Deregisters a package version.
#'
#' See [https://paws-r.github.io/docs/panorama/deregister_package_version.html](https://paws-r.github.io/docs/panorama/deregister_package_version.html) for full documentation.
#'
#' @param OwnerAccount An owner account.
#' @param PackageId &#91;required&#93; A package ID.
#' @param PackageVersion &#91;required&#93; A package version.
#' @param PatchVersion &#91;required&#93; A patch version.
#' @param UpdatedLatestPatchVersion If the version was marked latest, the new version to maker as latest.
#'
#' @keywords internal
#'
#' @rdname panorama_deregister_package_version
panorama_deregister_package_version <- function(OwnerAccount = NULL, PackageId, PackageVersion, PatchVersion, UpdatedLatestPatchVersion = NULL) {
  op <- new_operation(
    name = "DeregisterPackageVersion",
    http_method = "DELETE",
    http_path = "/packages/{PackageId}/versions/{PackageVersion}/patch/{PatchVersion}",
    paginator = list()
  )
  input <- .panorama$deregister_package_version_input(OwnerAccount = OwnerAccount, PackageId = PackageId, PackageVersion = PackageVersion, PatchVersion = PatchVersion, UpdatedLatestPatchVersion = UpdatedLatestPatchVersion)
  output <- .panorama$deregister_package_version_output()
  config <- get_config()
  svc <- .panorama$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.panorama$operations$deregister_package_version <- panorama_deregister_package_version

#' Returns information about an application instance on a device
#'
#' @description
#' Returns information about an application instance on a device.
#'
#' See [https://paws-r.github.io/docs/panorama/describe_application_instance.html](https://paws-r.github.io/docs/panorama/describe_application_instance.html) for full documentation.
#'
#' @param ApplicationInstanceId &#91;required&#93; The application instance's ID.
#'
#' @keywords internal
#'
#' @rdname panorama_describe_application_instance
panorama_describe_application_instance <- function(ApplicationInstanceId) {
  op <- new_operation(
    name = "DescribeApplicationInstance",
    http_method = "GET",
    http_path = "/application-instances/{ApplicationInstanceId}",
    paginator = list()
  )
  input <- .panorama$describe_application_instance_input(ApplicationInstanceId = ApplicationInstanceId)
  output <- .panorama$describe_application_instance_output()
  config <- get_config()
  svc <- .panorama$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.panorama$operations$describe_application_instance <- panorama_describe_application_instance

#' Returns information about an application instance's configuration
#' manifest
#'
#' @description
#' Returns information about an application instance's configuration manifest.
#'
#' See [https://paws-r.github.io/docs/panorama/describe_application_instance_details.html](https://paws-r.github.io/docs/panorama/describe_application_instance_details.html) for full documentation.
#'
#' @param ApplicationInstanceId &#91;required&#93; The application instance's ID.
#'
#' @keywords internal
#'
#' @rdname panorama_describe_application_instance_details
panorama_describe_application_instance_details <- function(ApplicationInstanceId) {
  op <- new_operation(
    name = "DescribeApplicationInstanceDetails",
    http_method = "GET",
    http_path = "/application-instances/{ApplicationInstanceId}/details",
    paginator = list()
  )
  input <- .panorama$describe_application_instance_details_input(ApplicationInstanceId = ApplicationInstanceId)
  output <- .panorama$describe_application_instance_details_output()
  config <- get_config()
  svc <- .panorama$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.panorama$operations$describe_application_instance_details <- panorama_describe_application_instance_details

#' Returns information about a device
#'
#' @description
#' Returns information about a device.
#'
#' See [https://paws-r.github.io/docs/panorama/describe_device.html](https://paws-r.github.io/docs/panorama/describe_device.html) for full documentation.
#'
#' @param DeviceId &#91;required&#93; The device's ID.
#'
#' @keywords internal
#'
#' @rdname panorama_describe_device
panorama_describe_device <- function(DeviceId) {
  op <- new_operation(
    name = "DescribeDevice",
    http_method = "GET",
    http_path = "/devices/{DeviceId}",
    paginator = list()
  )
  input <- .panorama$describe_device_input(DeviceId = DeviceId)
  output <- .panorama$describe_device_output()
  config <- get_config()
  svc <- .panorama$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.panorama$operations$describe_device <- panorama_describe_device

#' Returns information about a device job
#'
#' @description
#' Returns information about a device job.
#'
#' See [https://paws-r.github.io/docs/panorama/describe_device_job.html](https://paws-r.github.io/docs/panorama/describe_device_job.html) for full documentation.
#'
#' @param JobId &#91;required&#93; The job's ID.
#'
#' @keywords internal
#'
#' @rdname panorama_describe_device_job
panorama_describe_device_job <- function(JobId) {
  op <- new_operation(
    name = "DescribeDeviceJob",
    http_method = "GET",
    http_path = "/jobs/{JobId}",
    paginator = list()
  )
  input <- .panorama$describe_device_job_input(JobId = JobId)
  output <- .panorama$describe_device_job_output()
  config <- get_config()
  svc <- .panorama$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.panorama$operations$describe_device_job <- panorama_describe_device_job

#' Returns information about a node
#'
#' @description
#' Returns information about a node.
#'
#' See [https://paws-r.github.io/docs/panorama/describe_node.html](https://paws-r.github.io/docs/panorama/describe_node.html) for full documentation.
#'
#' @param NodeId &#91;required&#93; The node's ID.
#' @param OwnerAccount The account ID of the node's owner.
#'
#' @keywords internal
#'
#' @rdname panorama_describe_node
panorama_describe_node <- function(NodeId, OwnerAccount = NULL) {
  op <- new_operation(
    name = "DescribeNode",
    http_method = "GET",
    http_path = "/nodes/{NodeId}",
    paginator = list()
  )
  input <- .panorama$describe_node_input(NodeId = NodeId, OwnerAccount = OwnerAccount)
  output <- .panorama$describe_node_output()
  config <- get_config()
  svc <- .panorama$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.panorama$operations$describe_node <- panorama_describe_node

#' Returns information about a job to create a camera stream node
#'
#' @description
#' Returns information about a job to create a camera stream node.
#'
#' See [https://paws-r.github.io/docs/panorama/describe_node_from_template_job.html](https://paws-r.github.io/docs/panorama/describe_node_from_template_job.html) for full documentation.
#'
#' @param JobId &#91;required&#93; The job's ID.
#'
#' @keywords internal
#'
#' @rdname panorama_describe_node_from_template_job
panorama_describe_node_from_template_job <- function(JobId) {
  op <- new_operation(
    name = "DescribeNodeFromTemplateJob",
    http_method = "GET",
    http_path = "/packages/template-job/{JobId}",
    paginator = list()
  )
  input <- .panorama$describe_node_from_template_job_input(JobId = JobId)
  output <- .panorama$describe_node_from_template_job_output()
  config <- get_config()
  svc <- .panorama$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.panorama$operations$describe_node_from_template_job <- panorama_describe_node_from_template_job

#' Returns information about a package
#'
#' @description
#' Returns information about a package.
#'
#' See [https://paws-r.github.io/docs/panorama/describe_package.html](https://paws-r.github.io/docs/panorama/describe_package.html) for full documentation.
#'
#' @param PackageId &#91;required&#93; The package's ID.
#'
#' @keywords internal
#'
#' @rdname panorama_describe_package
panorama_describe_package <- function(PackageId) {
  op <- new_operation(
    name = "DescribePackage",
    http_method = "GET",
    http_path = "/packages/metadata/{PackageId}",
    paginator = list()
  )
  input <- .panorama$describe_package_input(PackageId = PackageId)
  output <- .panorama$describe_package_output()
  config <- get_config()
  svc <- .panorama$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.panorama$operations$describe_package <- panorama_describe_package

#' Returns information about a package import job
#'
#' @description
#' Returns information about a package import job.
#'
#' See [https://paws-r.github.io/docs/panorama/describe_package_import_job.html](https://paws-r.github.io/docs/panorama/describe_package_import_job.html) for full documentation.
#'
#' @param JobId &#91;required&#93; The job's ID.
#'
#' @keywords internal
#'
#' @rdname panorama_describe_package_import_job
panorama_describe_package_import_job <- function(JobId) {
  op <- new_operation(
    name = "DescribePackageImportJob",
    http_method = "GET",
    http_path = "/packages/import-jobs/{JobId}",
    paginator = list()
  )
  input <- .panorama$describe_package_import_job_input(JobId = JobId)
  output <- .panorama$describe_package_import_job_output()
  config <- get_config()
  svc <- .panorama$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.panorama$operations$describe_package_import_job <- panorama_describe_package_import_job

#' Returns information about a package version
#'
#' @description
#' Returns information about a package version.
#'
#' See [https://paws-r.github.io/docs/panorama/describe_package_version.html](https://paws-r.github.io/docs/panorama/describe_package_version.html) for full documentation.
#'
#' @param OwnerAccount The version's owner account.
#' @param PackageId &#91;required&#93; The version's ID.
#' @param PackageVersion &#91;required&#93; The version's version.
#' @param PatchVersion The version's patch version.
#'
#' @keywords internal
#'
#' @rdname panorama_describe_package_version
panorama_describe_package_version <- function(OwnerAccount = NULL, PackageId, PackageVersion, PatchVersion = NULL) {
  op <- new_operation(
    name = "DescribePackageVersion",
    http_method = "GET",
    http_path = "/packages/metadata/{PackageId}/versions/{PackageVersion}",
    paginator = list()
  )
  input <- .panorama$describe_package_version_input(OwnerAccount = OwnerAccount, PackageId = PackageId, PackageVersion = PackageVersion, PatchVersion = PatchVersion)
  output <- .panorama$describe_package_version_output()
  config <- get_config()
  svc <- .panorama$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.panorama$operations$describe_package_version <- panorama_describe_package_version

#' Returns a list of application instance dependencies
#'
#' @description
#' Returns a list of application instance dependencies.
#'
#' See [https://paws-r.github.io/docs/panorama/list_application_instance_dependencies.html](https://paws-r.github.io/docs/panorama/list_application_instance_dependencies.html) for full documentation.
#'
#' @param ApplicationInstanceId &#91;required&#93; The application instance's ID.
#' @param MaxResults The maximum number of application instance dependencies to return in one
#' page of results.
#' @param NextToken Specify the pagination token from a previous request to retrieve the
#' next page of results.
#'
#' @keywords internal
#'
#' @rdname panorama_list_application_instance_dependencies
panorama_list_application_instance_dependencies <- function(ApplicationInstanceId, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "ListApplicationInstanceDependencies",
    http_method = "GET",
    http_path = "/application-instances/{ApplicationInstanceId}/package-dependencies",
    paginator = list()
  )
  input <- .panorama$list_application_instance_dependencies_input(ApplicationInstanceId = ApplicationInstanceId, MaxResults = MaxResults, NextToken = NextToken)
  output <- .panorama$list_application_instance_dependencies_output()
  config <- get_config()
  svc <- .panorama$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.panorama$operations$list_application_instance_dependencies <- panorama_list_application_instance_dependencies

#' Returns a list of application node instances
#'
#' @description
#' Returns a list of application node instances.
#'
#' See [https://paws-r.github.io/docs/panorama/list_application_instance_node_instances.html](https://paws-r.github.io/docs/panorama/list_application_instance_node_instances.html) for full documentation.
#'
#' @param ApplicationInstanceId &#91;required&#93; The node instances' application instance ID.
#' @param MaxResults The maximum number of node instances to return in one page of results.
#' @param NextToken Specify the pagination token from a previous request to retrieve the
#' next page of results.
#'
#' @keywords internal
#'
#' @rdname panorama_list_application_instance_node_instances
panorama_list_application_instance_node_instances <- function(ApplicationInstanceId, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "ListApplicationInstanceNodeInstances",
    http_method = "GET",
    http_path = "/application-instances/{ApplicationInstanceId}/node-instances",
    paginator = list()
  )
  input <- .panorama$list_application_instance_node_instances_input(ApplicationInstanceId = ApplicationInstanceId, MaxResults = MaxResults, NextToken = NextToken)
  output <- .panorama$list_application_instance_node_instances_output()
  config <- get_config()
  svc <- .panorama$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.panorama$operations$list_application_instance_node_instances <- panorama_list_application_instance_node_instances

#' Returns a list of application instances
#'
#' @description
#' Returns a list of application instances.
#'
#' See [https://paws-r.github.io/docs/panorama/list_application_instances.html](https://paws-r.github.io/docs/panorama/list_application_instances.html) for full documentation.
#'
#' @param DeviceId The application instances' device ID.
#' @param MaxResults The maximum number of application instances to return in one page of
#' results.
#' @param NextToken Specify the pagination token from a previous request to retrieve the
#' next page of results.
#' @param StatusFilter Only include instances with a specific status.
#'
#' @keywords internal
#'
#' @rdname panorama_list_application_instances
panorama_list_application_instances <- function(DeviceId = NULL, MaxResults = NULL, NextToken = NULL, StatusFilter = NULL) {
  op <- new_operation(
    name = "ListApplicationInstances",
    http_method = "GET",
    http_path = "/application-instances",
    paginator = list()
  )
  input <- .panorama$list_application_instances_input(DeviceId = DeviceId, MaxResults = MaxResults, NextToken = NextToken, StatusFilter = StatusFilter)
  output <- .panorama$list_application_instances_output()
  config <- get_config()
  svc <- .panorama$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.panorama$operations$list_application_instances <- panorama_list_application_instances

#' Returns a list of devices
#'
#' @description
#' Returns a list of devices.
#'
#' See [https://paws-r.github.io/docs/panorama/list_devices.html](https://paws-r.github.io/docs/panorama/list_devices.html) for full documentation.
#'
#' @param MaxResults The maximum number of devices to return in one page of results.
#' @param NextToken Specify the pagination token from a previous request to retrieve the
#' next page of results.
#'
#' @keywords internal
#'
#' @rdname panorama_list_devices
panorama_list_devices <- function(MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "ListDevices",
    http_method = "GET",
    http_path = "/devices",
    paginator = list()
  )
  input <- .panorama$list_devices_input(MaxResults = MaxResults, NextToken = NextToken)
  output <- .panorama$list_devices_output()
  config <- get_config()
  svc <- .panorama$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.panorama$operations$list_devices <- panorama_list_devices

#' Returns a list of jobs
#'
#' @description
#' Returns a list of jobs.
#'
#' See [https://paws-r.github.io/docs/panorama/list_devices_jobs.html](https://paws-r.github.io/docs/panorama/list_devices_jobs.html) for full documentation.
#'
#' @param DeviceId Filter results by the job's target device ID.
#' @param MaxResults The maximum number of device jobs to return in one page of results.
#' @param NextToken Specify the pagination token from a previous request to retrieve the
#' next page of results.
#'
#' @keywords internal
#'
#' @rdname panorama_list_devices_jobs
panorama_list_devices_jobs <- function(DeviceId = NULL, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "ListDevicesJobs",
    http_method = "GET",
    http_path = "/jobs",
    paginator = list()
  )
  input <- .panorama$list_devices_jobs_input(DeviceId = DeviceId, MaxResults = MaxResults, NextToken = NextToken)
  output <- .panorama$list_devices_jobs_output()
  config <- get_config()
  svc <- .panorama$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.panorama$operations$list_devices_jobs <- panorama_list_devices_jobs

#' Returns a list of camera stream node jobs
#'
#' @description
#' Returns a list of camera stream node jobs.
#'
#' See [https://paws-r.github.io/docs/panorama/list_node_from_template_jobs.html](https://paws-r.github.io/docs/panorama/list_node_from_template_jobs.html) for full documentation.
#'
#' @param MaxResults The maximum number of node from template jobs to return in one page of
#' results.
#' @param NextToken Specify the pagination token from a previous request to retrieve the
#' next page of results.
#'
#' @keywords internal
#'
#' @rdname panorama_list_node_from_template_jobs
panorama_list_node_from_template_jobs <- function(MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "ListNodeFromTemplateJobs",
    http_method = "GET",
    http_path = "/packages/template-job",
    paginator = list()
  )
  input <- .panorama$list_node_from_template_jobs_input(MaxResults = MaxResults, NextToken = NextToken)
  output <- .panorama$list_node_from_template_jobs_output()
  config <- get_config()
  svc <- .panorama$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.panorama$operations$list_node_from_template_jobs <- panorama_list_node_from_template_jobs

#' Returns a list of nodes
#'
#' @description
#' Returns a list of nodes.
#'
#' See [https://paws-r.github.io/docs/panorama/list_nodes.html](https://paws-r.github.io/docs/panorama/list_nodes.html) for full documentation.
#'
#' @param Category Search for nodes by category.
#' @param MaxResults The maximum number of nodes to return in one page of results.
#' @param NextToken Specify the pagination token from a previous request to retrieve the
#' next page of results.
#' @param OwnerAccount Search for nodes by the account ID of the nodes' owner.
#' @param PackageName Search for nodes by name.
#' @param PackageVersion Search for nodes by version.
#' @param PatchVersion Search for nodes by patch version.
#'
#' @keywords internal
#'
#' @rdname panorama_list_nodes
panorama_list_nodes <- function(Category = NULL, MaxResults = NULL, NextToken = NULL, OwnerAccount = NULL, PackageName = NULL, PackageVersion = NULL, PatchVersion = NULL) {
  op <- new_operation(
    name = "ListNodes",
    http_method = "GET",
    http_path = "/nodes",
    paginator = list()
  )
  input <- .panorama$list_nodes_input(Category = Category, MaxResults = MaxResults, NextToken = NextToken, OwnerAccount = OwnerAccount, PackageName = PackageName, PackageVersion = PackageVersion, PatchVersion = PatchVersion)
  output <- .panorama$list_nodes_output()
  config <- get_config()
  svc <- .panorama$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.panorama$operations$list_nodes <- panorama_list_nodes

#' Returns a list of package import jobs
#'
#' @description
#' Returns a list of package import jobs.
#'
#' See [https://paws-r.github.io/docs/panorama/list_package_import_jobs.html](https://paws-r.github.io/docs/panorama/list_package_import_jobs.html) for full documentation.
#'
#' @param MaxResults The maximum number of package import jobs to return in one page of
#' results.
#' @param NextToken Specify the pagination token from a previous request to retrieve the
#' next page of results.
#'
#' @keywords internal
#'
#' @rdname panorama_list_package_import_jobs
panorama_list_package_import_jobs <- function(MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "ListPackageImportJobs",
    http_method = "GET",
    http_path = "/packages/import-jobs",
    paginator = list()
  )
  input <- .panorama$list_package_import_jobs_input(MaxResults = MaxResults, NextToken = NextToken)
  output <- .panorama$list_package_import_jobs_output()
  config <- get_config()
  svc <- .panorama$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.panorama$operations$list_package_import_jobs <- panorama_list_package_import_jobs

#' Returns a list of packages
#'
#' @description
#' Returns a list of packages.
#'
#' See [https://paws-r.github.io/docs/panorama/list_packages.html](https://paws-r.github.io/docs/panorama/list_packages.html) for full documentation.
#'
#' @param MaxResults The maximum number of packages to return in one page of results.
#' @param NextToken Specify the pagination token from a previous request to retrieve the
#' next page of results.
#'
#' @keywords internal
#'
#' @rdname panorama_list_packages
panorama_list_packages <- function(MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "ListPackages",
    http_method = "GET",
    http_path = "/packages",
    paginator = list()
  )
  input <- .panorama$list_packages_input(MaxResults = MaxResults, NextToken = NextToken)
  output <- .panorama$list_packages_output()
  config <- get_config()
  svc <- .panorama$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.panorama$operations$list_packages <- panorama_list_packages

#' Returns a list of tags for a resource
#'
#' @description
#' Returns a list of tags for a resource.
#'
#' See [https://paws-r.github.io/docs/panorama/list_tags_for_resource.html](https://paws-r.github.io/docs/panorama/list_tags_for_resource.html) for full documentation.
#'
#' @param ResourceArn &#91;required&#93; The resource's ARN.
#'
#' @keywords internal
#'
#' @rdname panorama_list_tags_for_resource
panorama_list_tags_for_resource <- function(ResourceArn) {
  op <- new_operation(
    name = "ListTagsForResource",
    http_method = "GET",
    http_path = "/tags/{ResourceArn}",
    paginator = list()
  )
  input <- .panorama$list_tags_for_resource_input(ResourceArn = ResourceArn)
  output <- .panorama$list_tags_for_resource_output()
  config <- get_config()
  svc <- .panorama$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.panorama$operations$list_tags_for_resource <- panorama_list_tags_for_resource

#' Creates a device and returns a configuration archive
#'
#' @description
#' Creates a device and returns a configuration archive. The configuration archive is a ZIP file that contains a provisioning certificate that is valid for 5 minutes. Name the configuration archive `certificates-omni_device-name.zip` and transfer it to the device within 5 minutes. Use the included USB storage device and connect it to the USB 3.0 port next to the HDMI output.
#'
#' See [https://paws-r.github.io/docs/panorama/provision_device.html](https://paws-r.github.io/docs/panorama/provision_device.html) for full documentation.
#'
#' @param Description A description for the device.
#' @param Name &#91;required&#93; A name for the device.
#' @param NetworkingConfiguration A networking configuration for the device.
#' @param Tags Tags for the device.
#'
#' @keywords internal
#'
#' @rdname panorama_provision_device
panorama_provision_device <- function(Description = NULL, Name, NetworkingConfiguration = NULL, Tags = NULL) {
  op <- new_operation(
    name = "ProvisionDevice",
    http_method = "POST",
    http_path = "/devices",
    paginator = list()
  )
  input <- .panorama$provision_device_input(Description = Description, Name = Name, NetworkingConfiguration = NetworkingConfiguration, Tags = Tags)
  output <- .panorama$provision_device_output()
  config <- get_config()
  svc <- .panorama$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.panorama$operations$provision_device <- panorama_provision_device

#' Registers a package version
#'
#' @description
#' Registers a package version.
#'
#' See [https://paws-r.github.io/docs/panorama/register_package_version.html](https://paws-r.github.io/docs/panorama/register_package_version.html) for full documentation.
#'
#' @param MarkLatest Whether to mark the new version as the latest version.
#' @param OwnerAccount An owner account.
#' @param PackageId &#91;required&#93; A package ID.
#' @param PackageVersion &#91;required&#93; A package version.
#' @param PatchVersion &#91;required&#93; A patch version.
#'
#' @keywords internal
#'
#' @rdname panorama_register_package_version
panorama_register_package_version <- function(MarkLatest = NULL, OwnerAccount = NULL, PackageId, PackageVersion, PatchVersion) {
  op <- new_operation(
    name = "RegisterPackageVersion",
    http_method = "PUT",
    http_path = "/packages/{PackageId}/versions/{PackageVersion}/patch/{PatchVersion}",
    paginator = list()
  )
  input <- .panorama$register_package_version_input(MarkLatest = MarkLatest, OwnerAccount = OwnerAccount, PackageId = PackageId, PackageVersion = PackageVersion, PatchVersion = PatchVersion)
  output <- .panorama$register_package_version_output()
  config <- get_config()
  svc <- .panorama$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.panorama$operations$register_package_version <- panorama_register_package_version

#' Removes an application instance
#'
#' @description
#' Removes an application instance.
#'
#' See [https://paws-r.github.io/docs/panorama/remove_application_instance.html](https://paws-r.github.io/docs/panorama/remove_application_instance.html) for full documentation.
#'
#' @param ApplicationInstanceId &#91;required&#93; An application instance ID.
#'
#' @keywords internal
#'
#' @rdname panorama_remove_application_instance
panorama_remove_application_instance <- function(ApplicationInstanceId) {
  op <- new_operation(
    name = "RemoveApplicationInstance",
    http_method = "DELETE",
    http_path = "/application-instances/{ApplicationInstanceId}",
    paginator = list()
  )
  input <- .panorama$remove_application_instance_input(ApplicationInstanceId = ApplicationInstanceId)
  output <- .panorama$remove_application_instance_output()
  config <- get_config()
  svc <- .panorama$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.panorama$operations$remove_application_instance <- panorama_remove_application_instance

#' Tags a resource
#'
#' @description
#' Tags a resource.
#'
#' See [https://paws-r.github.io/docs/panorama/tag_resource.html](https://paws-r.github.io/docs/panorama/tag_resource.html) for full documentation.
#'
#' @param ResourceArn &#91;required&#93; The resource's ARN.
#' @param Tags &#91;required&#93; Tags for the resource.
#'
#' @keywords internal
#'
#' @rdname panorama_tag_resource
panorama_tag_resource <- function(ResourceArn, Tags) {
  op <- new_operation(
    name = "TagResource",
    http_method = "POST",
    http_path = "/tags/{ResourceArn}",
    paginator = list()
  )
  input <- .panorama$tag_resource_input(ResourceArn = ResourceArn, Tags = Tags)
  output <- .panorama$tag_resource_output()
  config <- get_config()
  svc <- .panorama$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.panorama$operations$tag_resource <- panorama_tag_resource

#' Removes tags from a resource
#'
#' @description
#' Removes tags from a resource.
#'
#' See [https://paws-r.github.io/docs/panorama/untag_resource.html](https://paws-r.github.io/docs/panorama/untag_resource.html) for full documentation.
#'
#' @param ResourceArn &#91;required&#93; The resource's ARN.
#' @param TagKeys &#91;required&#93; Tag keys to remove.
#'
#' @keywords internal
#'
#' @rdname panorama_untag_resource
panorama_untag_resource <- function(ResourceArn, TagKeys) {
  op <- new_operation(
    name = "UntagResource",
    http_method = "DELETE",
    http_path = "/tags/{ResourceArn}",
    paginator = list()
  )
  input <- .panorama$untag_resource_input(ResourceArn = ResourceArn, TagKeys = TagKeys)
  output <- .panorama$untag_resource_output()
  config <- get_config()
  svc <- .panorama$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.panorama$operations$untag_resource <- panorama_untag_resource

#' Updates a device's metadata
#'
#' @description
#' Updates a device's metadata.
#'
#' See [https://paws-r.github.io/docs/panorama/update_device_metadata.html](https://paws-r.github.io/docs/panorama/update_device_metadata.html) for full documentation.
#'
#' @param Description A description for the device.
#' @param DeviceId &#91;required&#93; The device's ID.
#'
#' @keywords internal
#'
#' @rdname panorama_update_device_metadata
panorama_update_device_metadata <- function(Description = NULL, DeviceId) {
  op <- new_operation(
    name = "UpdateDeviceMetadata",
    http_method = "PUT",
    http_path = "/devices/{DeviceId}",
    paginator = list()
  )
  input <- .panorama$update_device_metadata_input(Description = Description, DeviceId = DeviceId)
  output <- .panorama$update_device_metadata_output()
  config <- get_config()
  svc <- .panorama$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.panorama$operations$update_device_metadata <- panorama_update_device_metadata
