% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sagemaker_operations.R
\name{sagemaker_list_device_fleets}
\alias{sagemaker_list_device_fleets}
\title{Returns a list of devices in the fleet}
\usage{
sagemaker_list_device_fleets(NextToken, MaxResults, CreationTimeAfter,
  CreationTimeBefore, LastModifiedTimeAfter, LastModifiedTimeBefore,
  NameContains, SortBy, SortOrder)
}
\arguments{
\item{NextToken}{The response from the last list when returning a list large enough to
need tokening.}

\item{MaxResults}{The maximum number of results to select.}

\item{CreationTimeAfter}{Filter fleets where packaging job was created after specified time.}

\item{CreationTimeBefore}{Filter fleets where the edge packaging job was created before specified
time.}

\item{LastModifiedTimeAfter}{Select fleets where the job was updated after X}

\item{LastModifiedTimeBefore}{Select fleets where the job was updated before X}

\item{NameContains}{Filter for fleets containing this name in their fleet device name.}

\item{SortBy}{The column to sort by.}

\item{SortOrder}{What direction to sort in.}
}
\value{
A list with the following syntax:\preformatted{list(
  DeviceFleetSummaries = list(
    list(
      DeviceFleetArn = "string",
      DeviceFleetName = "string",
      CreationTime = as.POSIXct(
        "2015-01-01"
      ),
      LastModifiedTime = as.POSIXct(
        "2015-01-01"
      )
    )
  ),
  NextToken = "string"
)
}
}
\description{
Returns a list of devices in the fleet.
}
\section{Request syntax}{
\preformatted{svc$list_device_fleets(
  NextToken = "string",
  MaxResults = 123,
  CreationTimeAfter = as.POSIXct(
    "2015-01-01"
  ),
  CreationTimeBefore = as.POSIXct(
    "2015-01-01"
  ),
  LastModifiedTimeAfter = as.POSIXct(
    "2015-01-01"
  ),
  LastModifiedTimeBefore = as.POSIXct(
    "2015-01-01"
  ),
  NameContains = "string",
  SortBy = "NAME"|"CREATION_TIME"|"LAST_MODIFIED_TIME",
  SortOrder = "Ascending"|"Descending"
)
}
}

\keyword{internal}
