% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/personalize_operations.R
\name{personalize_describe_solution}
\alias{personalize_describe_solution}
\title{Describes a solution}
\usage{
personalize_describe_solution(solutionArn)
}
\arguments{
\item{solutionArn}{[required] The Amazon Resource Name (ARN) of the solution to describe.}
}
\value{
A list with the following syntax:\preformatted{list(
  solution = list(
    name = "string",
    solutionArn = "string",
    performHPO = TRUE|FALSE,
    performAutoML = TRUE|FALSE,
    recipeArn = "string",
    datasetGroupArn = "string",
    eventType = "string",
    solutionConfig = list(
      eventValueThreshold = "string",
      hpoConfig = list(
        hpoObjective = list(
          type = "string",
          metricName = "string",
          metricRegex = "string"
        ),
        hpoResourceConfig = list(
          maxNumberOfTrainingJobs = "string",
          maxParallelTrainingJobs = "string"
        ),
        algorithmHyperParameterRanges = list(
          integerHyperParameterRanges = list(
            list(
              name = "string",
              minValue = 123,
              maxValue = 123
            )
          ),
          continuousHyperParameterRanges = list(
            list(
              name = "string",
              minValue = 123.0,
              maxValue = 123.0
            )
          ),
          categoricalHyperParameterRanges = list(
            list(
              name = "string",
              values = list(
                "string"
              )
            )
          )
        )
      ),
      algorithmHyperParameters = list(
        "string"
      ),
      featureTransformationParameters = list(
        "string"
      ),
      autoMLConfig = list(
        metricName = "string",
        recipeList = list(
          "string"
        )
      )
    ),
    autoMLResult = list(
      bestRecipeArn = "string"
    ),
    status = "string",
    creationDateTime = as.POSIXct(
      "2015-01-01"
    ),
    lastUpdatedDateTime = as.POSIXct(
      "2015-01-01"
    ),
    latestSolutionVersion = list(
      solutionVersionArn = "string",
      status = "string",
      creationDateTime = as.POSIXct(
        "2015-01-01"
      ),
      lastUpdatedDateTime = as.POSIXct(
        "2015-01-01"
      ),
      failureReason = "string"
    )
  )
)
}
}
\description{
Describes a solution. For more information on solutions, see
\code{\link[=personalize_create_solution]{create_solution}}.
}
\section{Request syntax}{
\preformatted{svc$describe_solution(
  solutionArn = "string"
)
}
}

\keyword{internal}
