% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transcribeservice_operations.R
\name{transcribeservice_create_language_model}
\alias{transcribeservice_create_language_model}
\title{Creates a new custom language model}
\usage{
transcribeservice_create_language_model(LanguageCode, BaseModelName,
  ModelName, InputDataConfig)
}
\arguments{
\item{LanguageCode}{[required] The language of the input text you're using to train your custom
language model.}

\item{BaseModelName}{[required] The Amazon Transcribe standard language model, or base model used to
create your custom language model.

If you want to use your custom language model to transcribe audio with a
sample rate of 16 kHz or greater, choose \code{Wideband}.

If you want to use your custom language model to transcribe audio with a
sample rate that is less than 16 kHz, choose \code{Narrowband}.}

\item{ModelName}{[required] The name you choose for your custom language model when you create it.}

\item{InputDataConfig}{[required] Contains the data access role and the Amazon S3 prefixes to read the
required input files to create a custom language model.}
}
\value{
A list with the following syntax:\preformatted{list(
  LanguageCode = "en-US",
  BaseModelName = "NarrowBand"|"WideBand",
  ModelName = "string",
  InputDataConfig = list(
    S3Uri = "string",
    TuningDataS3Uri = "string",
    DataAccessRoleArn = "string"
  ),
  ModelStatus = "IN_PROGRESS"|"FAILED"|"COMPLETED"
)
}
}
\description{
Creates a new custom language model. Use Amazon S3 prefixes to provide
the location of your input files. The time it takes to create your model
depends on the size of your training data.
}
\section{Request syntax}{
\preformatted{svc$create_language_model(
  LanguageCode = "en-US",
  BaseModelName = "NarrowBand"|"WideBand",
  ModelName = "string",
  InputDataConfig = list(
    S3Uri = "string",
    TuningDataS3Uri = "string",
    DataAccessRoleArn = "string"
  )
)
}
}

\keyword{internal}
