% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sagemaker_operations.R
\name{sagemaker_create_app_image_config}
\alias{sagemaker_create_app_image_config}
\title{Creates a configuration for running a SageMaker image as a KernelGateway
app}
\usage{
sagemaker_create_app_image_config(AppImageConfigName, Tags,
  KernelGatewayImageConfig)
}
\arguments{
\item{AppImageConfigName}{[required] The name of the AppImageConfig. Must be unique to your account.}

\item{Tags}{A list of tags to apply to the AppImageConfig.}

\item{KernelGatewayImageConfig}{The KernelGatewayImageConfig.}
}
\description{
Creates a configuration for running a SageMaker image as a KernelGateway
app. The configuration specifies the Amazon Elastic File System (EFS)
storage volume on the image, and a list of the kernels in the image.
}
\section{Request syntax}{
\preformatted{svc$create_app_image_config(
  AppImageConfigName = "string",
  Tags = list(
    list(
      Key = "string",
      Value = "string"
    )
  ),
  KernelGatewayImageConfig = list(
    KernelSpecs = list(
      list(
        Name = "string",
        DisplayName = "string"
      )
    ),
    FileSystemConfig = list(
      MountPath = "string",
      DefaultUid = 123,
      DefaultGid = 123
    )
  )
)
}
}

\keyword{internal}
