% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/workspaces_operations.R
\name{workspaces_describe_workspace_image_permissions}
\alias{workspaces_describe_workspace_image_permissions}
\title{Describes the permissions that the owner of an image has granted to
other AWS accounts for an image}
\usage{
workspaces_describe_workspace_image_permissions(ImageId, NextToken,
  MaxResults)
}
\arguments{
\item{ImageId}{[required] The identifier of the image.}

\item{NextToken}{If you received a \code{NextToken} from a previous call that was paginated,
provide this token to receive the next set of results.}

\item{MaxResults}{The maximum number of items to return.}
}
\value{
A list with the following syntax:\preformatted{list(
  ImageId = "string",
  ImagePermissions = list(
    list(
      SharedAccountId = "string"
    )
  ),
  NextToken = "string"
)
}
}
\description{
Describes the permissions that the owner of an image has granted to
other AWS accounts for an image.
}
\section{Request syntax}{
\preformatted{svc$describe_workspace_image_permissions(
  ImageId = "string",
  NextToken = "string",
  MaxResults = 123
)
}
}

\keyword{internal}
