% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/workspaces_operations.R
\name{workspaces_create_ip_group}
\alias{workspaces_create_ip_group}
\title{Creates an IP access control group}
\usage{
workspaces_create_ip_group(GroupName, GroupDesc, UserRules, Tags)
}
\arguments{
\item{GroupName}{[required] The name of the group.}

\item{GroupDesc}{The description of the group.}

\item{UserRules}{The rules to add to the group.}

\item{Tags}{The tags. Each WorkSpaces resource can have a maximum of 50 tags.}
}
\value{
A list with the following syntax:\preformatted{list(
  GroupId = "string"
)
}
}
\description{
Creates an IP access control group.

An IP access control group provides you with the ability to control the
IP addresses from which users are allowed to access their WorkSpaces. To
specify the CIDR address ranges, add rules to your IP access control
group and then associate the group with your directory. You can add
rules when you create the group or at any time using
\code{\link[=workspaces_authorize_ip_rules]{authorize_ip_rules}}.

There is a default IP access control group associated with your
directory. If you don't associate an IP access control group with your
directory, the default group is used. The default group includes a
default rule that allows users to access their WorkSpaces from anywhere.
You cannot modify the default IP access control group for your
directory.
}
\section{Request syntax}{
\preformatted{svc$create_ip_group(
  GroupName = "string",
  GroupDesc = "string",
  UserRules = list(
    list(
      ipRule = "string",
      ruleDesc = "string"
    )
  ),
  Tags = list(
    list(
      Key = "string",
      Value = "string"
    )
  )
)
}
}

\keyword{internal}
