% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/appstream_operations.R
\name{appstream_update_fleet}
\alias{appstream_update_fleet}
\title{Updates the specified fleet}
\usage{
appstream_update_fleet(ImageName, ImageArn, Name, InstanceType,
  ComputeCapacity, VpcConfig, MaxUserDurationInSeconds,
  DisconnectTimeoutInSeconds, DeleteVpcConfig, Description, DisplayName,
  EnableDefaultInternetAccess, DomainJoinInfo,
  IdleDisconnectTimeoutInSeconds, AttributesToDelete, IamRoleArn,
  StreamView)
}
\arguments{
\item{ImageName}{The name of the image used to create the fleet.}

\item{ImageArn}{The ARN of the public, private, or shared image to use.}

\item{Name}{A unique name for the fleet.}

\item{InstanceType}{The instance type to use when launching fleet instances. The following
instance types are available:
\itemize{
\item stream.standard.medium
\item stream.standard.large
\item stream.compute.large
\item stream.compute.xlarge
\item stream.compute.2xlarge
\item stream.compute.4xlarge
\item stream.compute.8xlarge
\item stream.memory.large
\item stream.memory.xlarge
\item stream.memory.2xlarge
\item stream.memory.4xlarge
\item stream.memory.8xlarge
\item stream.memory.z1d.large
\item stream.memory.z1d.xlarge
\item stream.memory.z1d.2xlarge
\item stream.memory.z1d.3xlarge
\item stream.memory.z1d.6xlarge
\item stream.memory.z1d.12xlarge
\item stream.graphics-design.large
\item stream.graphics-design.xlarge
\item stream.graphics-design.2xlarge
\item stream.graphics-design.4xlarge
\item stream.graphics-desktop.2xlarge
\item stream.graphics.g4dn.xlarge
\item stream.graphics.g4dn.2xlarge
\item stream.graphics.g4dn.4xlarge
\item stream.graphics.g4dn.8xlarge
\item stream.graphics.g4dn.12xlarge
\item stream.graphics.g4dn.16xlarge
\item stream.graphics-pro.4xlarge
\item stream.graphics-pro.8xlarge
\item stream.graphics-pro.16xlarge
}}

\item{ComputeCapacity}{The desired capacity for the fleet.}

\item{VpcConfig}{The VPC configuration for the fleet.}

\item{MaxUserDurationInSeconds}{The maximum amount of time that a streaming session can remain active,
in seconds. If users are still connected to a streaming instance five
minutes before this limit is reached, they are prompted to save any open
documents before being disconnected. After this time elapses, the
instance is terminated and replaced by a new instance.

Specify a value between 600 and 360000.}

\item{DisconnectTimeoutInSeconds}{The amount of time that a streaming session remains active after users
disconnect. If users try to reconnect to the streaming session after a
disconnection or network interruption within this time interval, they
are connected to their previous session. Otherwise, they are connected
to a new session with a new streaming instance.

Specify a value between 60 and 360000.}

\item{DeleteVpcConfig}{Deletes the VPC association for the specified fleet.}

\item{Description}{The description to display.}

\item{DisplayName}{The fleet name to display.}

\item{EnableDefaultInternetAccess}{Enables or disables default internet access for the fleet.}

\item{DomainJoinInfo}{The name of the directory and organizational unit (OU) to use to join
the fleet to a Microsoft Active Directory domain.}

\item{IdleDisconnectTimeoutInSeconds}{The amount of time that users can be idle (inactive) before they are
disconnected from their streaming session and the
\code{DisconnectTimeoutInSeconds} time interval begins. Users are notified
before they are disconnected due to inactivity. If users try to
reconnect to the streaming session before the time interval specified in
\code{DisconnectTimeoutInSeconds} elapses, they are connected to their
previous session. Users are considered idle when they stop providing
keyboard or mouse input during their streaming session. File uploads and
downloads, audio in, audio out, and pixels changing do not qualify as
user activity. If users continue to be idle after the time interval in
\code{IdleDisconnectTimeoutInSeconds} elapses, they are disconnected.

To prevent users from being disconnected due to inactivity, specify a
value of 0. Otherwise, specify a value between 60 and 3600. The default
value is 0.

If you enable this feature, we recommend that you specify a value that
corresponds exactly to a whole number of minutes (for example, 60, 120,
and 180). If you don't do this, the value is rounded to the nearest
minute. For example, if you specify a value of 70, users are
disconnected after 1 minute of inactivity. If you specify a value that
is at the midpoint between two different minutes, the value is rounded
up. For example, if you specify a value of 90, users are disconnected
after 2 minutes of inactivity.}

\item{AttributesToDelete}{The fleet attributes to delete.}

\item{IamRoleArn}{The Amazon Resource Name (ARN) of the IAM role to apply to the fleet. To
assume a role, a fleet instance calls the AWS Security Token Service
(STS) \code{AssumeRole} API operation and passes the ARN of the role to use.
The operation creates a new session with temporary credentials.
AppStream 2.0 retrieves the temporary credentials and creates the
\strong{appstream_machine_role} credential profile on the instance.

For more information, see \href{https://docs.aws.amazon.com/appstream2/latest/developerguide/using-iam-roles-to-grant-permissions-to-applications-scripts-streaming-instances.html}{Using an IAM Role to Grant Permissions to Applications and Scripts Running on AppStream 2.0 Streaming Instances}
in the \emph{Amazon AppStream 2.0 Administration Guide}.}

\item{StreamView}{The AppStream 2.0 view that is displayed to your users when they stream
from the fleet. When \code{APP} is specified, only the windows of
applications opened by users display. When \code{DESKTOP} is specified, the
standard desktop that is provided by the operating system displays.

The default value is \code{APP}.}
}
\value{
A list with the following syntax:\preformatted{list(
  Fleet = list(
    Arn = "string",
    Name = "string",
    DisplayName = "string",
    Description = "string",
    ImageName = "string",
    ImageArn = "string",
    InstanceType = "string",
    FleetType = "ALWAYS_ON"|"ON_DEMAND",
    ComputeCapacityStatus = list(
      Desired = 123,
      Running = 123,
      InUse = 123,
      Available = 123
    ),
    MaxUserDurationInSeconds = 123,
    DisconnectTimeoutInSeconds = 123,
    State = "STARTING"|"RUNNING"|"STOPPING"|"STOPPED",
    VpcConfig = list(
      SubnetIds = list(
        "string"
      ),
      SecurityGroupIds = list(
        "string"
      )
    ),
    CreatedTime = as.POSIXct(
      "2015-01-01"
    ),
    FleetErrors = list(
      list(
        ErrorCode = "IAM_SERVICE_ROLE_MISSING_ENI_DESCRIBE_ACTION"|"IAM_SERVICE_ROLE_MISSING_ENI_CREATE_ACTION"|"IAM_SERVICE_ROLE_MISSING_ENI_DELETE_ACTION"|"NETWORK_INTERFACE_LIMIT_EXCEEDED"|"INTERNAL_SERVICE_ERROR"|"IAM_SERVICE_ROLE_IS_MISSING"|"MACHINE_ROLE_IS_MISSING"|"STS_DISABLED_IN_REGION"|"SUBNET_HAS_INSUFFICIENT_IP_ADDRESSES"|"IAM_SERVICE_ROLE_MISSING_DESCRIBE_SUBNET_ACTION"|"SUBNET_NOT_FOUND"|"IMAGE_NOT_FOUND"|"INVALID_SUBNET_CONFIGURATION"|"SECURITY_GROUPS_NOT_FOUND"|"IGW_NOT_ATTACHED"|"IAM_SERVICE_ROLE_MISSING_DESCRIBE_SECURITY_GROUPS_ACTION"|"DOMAIN_JOIN_ERROR_FILE_NOT_FOUND"|"DOMAIN_JOIN_ERROR_ACCESS_DENIED"|"DOMAIN_JOIN_ERROR_LOGON_FAILURE"|"DOMAIN_JOIN_ERROR_INVALID_PARAMETER"|"DOMAIN_JOIN_ERROR_MORE_DATA"|"DOMAIN_JOIN_ERROR_NO_SUCH_DOMAIN"|"DOMAIN_JOIN_ERROR_NOT_SUPPORTED"|"DOMAIN_JOIN_NERR_INVALID_WORKGROUP_NAME"|"DOMAIN_JOIN_NERR_WORKSTATION_NOT_STARTED"|"DOMAIN_JOIN_ERROR_DS_MACHINE_ACCOUNT_QUOTA_EXCEEDED"|"DOMAIN_JOIN_NERR_PASSWORD_EXPIRED"|"DOMAIN_JOIN_INTERNAL_SERVICE_ERROR",
        ErrorMessage = "string"
      )
    ),
    EnableDefaultInternetAccess = TRUE|FALSE,
    DomainJoinInfo = list(
      DirectoryName = "string",
      OrganizationalUnitDistinguishedName = "string"
    ),
    IdleDisconnectTimeoutInSeconds = 123,
    IamRoleArn = "string",
    StreamView = "APP"|"DESKTOP"
  )
)
}
}
\description{
Updates the specified fleet.

If the fleet is in the \code{STOPPED} state, you can update any attribute
except the fleet name. If the fleet is in the \code{RUNNING} state, you can
update the \code{DisplayName}, \code{ComputeCapacity}, \code{ImageARN}, \code{ImageName},
\code{IdleDisconnectTimeoutInSeconds}, and \code{DisconnectTimeoutInSeconds}
attributes. If the fleet is in the \code{STARTING} or \code{STOPPING} state, you
can't update it.
}
\section{Request syntax}{
\preformatted{svc$update_fleet(
  ImageName = "string",
  ImageArn = "string",
  Name = "string",
  InstanceType = "string",
  ComputeCapacity = list(
    DesiredInstances = 123
  ),
  VpcConfig = list(
    SubnetIds = list(
      "string"
    ),
    SecurityGroupIds = list(
      "string"
    )
  ),
  MaxUserDurationInSeconds = 123,
  DisconnectTimeoutInSeconds = 123,
  DeleteVpcConfig = TRUE|FALSE,
  Description = "string",
  DisplayName = "string",
  EnableDefaultInternetAccess = TRUE|FALSE,
  DomainJoinInfo = list(
    DirectoryName = "string",
    OrganizationalUnitDistinguishedName = "string"
  ),
  IdleDisconnectTimeoutInSeconds = 123,
  AttributesToDelete = list(
    "VPC_CONFIGURATION"|"VPC_CONFIGURATION_SECURITY_GROUP_IDS"|"DOMAIN_JOIN_INFO"|"IAM_ROLE_ARN"
  ),
  IamRoleArn = "string",
  StreamView = "APP"|"DESKTOP"
)
}
}

\keyword{internal}
