% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/codebuild_operations.R
\name{codebuild_describe_code_coverages}
\alias{codebuild_describe_code_coverages}
\title{Retrieves one or more code coverage reports}
\usage{
codebuild_describe_code_coverages(
  reportArn,
  nextToken = NULL,
  maxResults = NULL,
  sortOrder = NULL,
  sortBy = NULL,
  minLineCoveragePercentage = NULL,
  maxLineCoveragePercentage = NULL
)
}
\arguments{
\item{reportArn}{[required] The ARN of the report for which test cases are returned.}

\item{nextToken}{The \code{nextToken} value returned from a previous call to
\code{\link[=codebuild_describe_code_coverages]{describe_code_coverages}}. This
specifies the next item to return. To return the beginning of the list,
exclude this parameter.}

\item{maxResults}{The maximum number of results to return.}

\item{sortOrder}{Specifies if the results are sorted in ascending or descending order.}

\item{sortBy}{Specifies how the results are sorted. Possible values are:

\strong{FILE_PATH}

The results are sorted by file path.

\strong{LINE_COVERAGE_PERCENTAGE}

The results are sorted by the percentage of lines that are covered.}

\item{minLineCoveragePercentage}{The minimum line coverage percentage to report.}

\item{maxLineCoveragePercentage}{The maximum line coverage percentage to report.}
}
\description{
Retrieves one or more code coverage reports.

See \url{https://www.paws-r-sdk.com/docs/codebuild_describe_code_coverages/} for full documentation.
}
\keyword{internal}
