% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/codeartifact_operations.R
\name{codeartifact_update_package_versions_status}
\alias{codeartifact_update_package_versions_status}
\title{Updates the status of one or more versions of a package}
\usage{
codeartifact_update_package_versions_status(
  domain,
  domainOwner = NULL,
  repository,
  format,
  namespace = NULL,
  package,
  versions,
  versionRevisions = NULL,
  expectedStatus = NULL,
  targetStatus
)
}
\arguments{
\item{domain}{[required] The name of the domain that contains the repository that contains the
package versions with a status to be updated.}

\item{domainOwner}{The 12-digit account number of the Amazon Web Services account that owns
the domain. It does not include dashes or spaces.}

\item{repository}{[required] The repository that contains the package versions with the status you
want to update.}

\item{format}{[required] A format that specifies the type of the package with the statuses to
update.}

\item{namespace}{The namespace of the package version to be updated. The package version
component that specifies its namespace depends on its type. For example:
\itemize{
\item The namespace of a Maven package version is its \code{groupId}.
\item The namespace of an npm package version is its \code{scope}.
\item Python and NuGet package versions do not contain a corresponding
component, package versions of those formats do not have a
namespace.
\item The namespace of a generic package is its \code{namespace}.
}}

\item{package}{[required] The name of the package with the version statuses to update.}

\item{versions}{[required] An array of strings that specify the versions of the package with the
statuses to update.}

\item{versionRevisions}{A map of package versions and package version revisions. The map \code{key}
is the package version (for example, \verb{3.5.2}), and the map \code{value} is
the package version revision.}

\item{expectedStatus}{The package version’s expected status before it is updated. If
\code{expectedStatus} is provided, the package version's status is updated
only if its status at the time
\code{\link[=codeartifact_update_package_versions_status]{update_package_versions_status}}
is called matches \code{expectedStatus}.}

\item{targetStatus}{[required] The status you want to change the package version status to.}
}
\description{
Updates the status of one or more versions of a package. Using \code{\link[=codeartifact_update_package_versions_status]{update_package_versions_status}}, you can update the status of package versions to \code{Archived}, \code{Published}, or \code{Unlisted}. To set the status of a package version to \code{Disposed}, use \code{\link[=codeartifact_dispose_package_versions]{dispose_package_versions}}.

See \url{https://www.paws-r-sdk.com/docs/codeartifact_update_package_versions_status/} for full documentation.
}
\keyword{internal}
