% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/codeartifact_operations.R
\name{codeartifact_list_package_versions}
\alias{codeartifact_list_package_versions}
\title{Returns a list of PackageVersionSummary objects for package versions in
a repository that match the request parameters}
\usage{
codeartifact_list_package_versions(
  domain,
  domainOwner = NULL,
  repository,
  format,
  namespace = NULL,
  package,
  status = NULL,
  sortBy = NULL,
  maxResults = NULL,
  nextToken = NULL,
  originType = NULL
)
}
\arguments{
\item{domain}{[required] The name of the domain that contains the repository that contains the
requested package versions.}

\item{domainOwner}{The 12-digit account number of the Amazon Web Services account that owns
the domain. It does not include dashes or spaces.}

\item{repository}{[required] The name of the repository that contains the requested package versions.}

\item{format}{[required] The format of the returned package versions.}

\item{namespace}{The namespace of the package that contains the requested package
versions. The package component that specifies its namespace depends on
its type. For example:
\itemize{
\item The namespace of a Maven package is its \code{groupId}.
\item The namespace of an npm package is its \code{scope}.
\item Python and NuGet packages do not contain a corresponding component,
packages of those formats do not have a namespace.
}}

\item{package}{[required] The name of the package for which you want to request package versions.}

\item{status}{A string that filters the requested package versions by status.}

\item{sortBy}{How to sort the requested list of package versions.}

\item{maxResults}{The maximum number of results to return per page.}

\item{nextToken}{The token for the next set of results. Use the value returned in the
previous response in the next request to retrieve the next set of
results.}

\item{originType}{The \code{originType} used to filter package versions. Only package versions
with the provided \code{originType} will be returned.}
}
\description{
Returns a list of \href{https://docs.aws.amazon.com/codeartifact/latest/APIReference/API_PackageVersionSummary.html}{PackageVersionSummary} objects for package versions in a repository that match the request parameters.

See \url{https://paws-r.github.io/docs/codeartifact/list_package_versions.html} for full documentation.
}
\keyword{internal}
