# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common get_config new_operation new_request send_request
#' @include fis_service.R
NULL

#' Creates an experiment template
#'
#' @description
#' Creates an experiment template.
#'
#' See [https://paws-r.github.io/docs/fis/create_experiment_template.html](https://paws-r.github.io/docs/fis/create_experiment_template.html) for full documentation.
#'
#' @param clientToken &#91;required&#93; Unique, case-sensitive identifier that you provide to ensure the
#' idempotency of the request.
#' @param description &#91;required&#93; A description for the experiment template.
#' @param stopConditions &#91;required&#93; The stop conditions.
#' @param targets The targets for the experiment.
#' @param actions &#91;required&#93; The actions for the experiment.
#' @param roleArn &#91;required&#93; The Amazon Resource Name (ARN) of an IAM role that grants the FIS
#' service permission to perform service actions on your behalf.
#' @param tags The tags to apply to the experiment template.
#' @param logConfiguration The configuration for experiment logging.
#'
#' @keywords internal
#'
#' @rdname fis_create_experiment_template
fis_create_experiment_template <- function(clientToken, description, stopConditions, targets = NULL, actions, roleArn, tags = NULL, logConfiguration = NULL) {
  op <- new_operation(
    name = "CreateExperimentTemplate",
    http_method = "POST",
    http_path = "/experimentTemplates",
    paginator = list()
  )
  input <- .fis$create_experiment_template_input(clientToken = clientToken, description = description, stopConditions = stopConditions, targets = targets, actions = actions, roleArn = roleArn, tags = tags, logConfiguration = logConfiguration)
  output <- .fis$create_experiment_template_output()
  config <- get_config()
  svc <- .fis$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.fis$operations$create_experiment_template <- fis_create_experiment_template

#' Deletes the specified experiment template
#'
#' @description
#' Deletes the specified experiment template.
#'
#' See [https://paws-r.github.io/docs/fis/delete_experiment_template.html](https://paws-r.github.io/docs/fis/delete_experiment_template.html) for full documentation.
#'
#' @param id &#91;required&#93; The ID of the experiment template.
#'
#' @keywords internal
#'
#' @rdname fis_delete_experiment_template
fis_delete_experiment_template <- function(id) {
  op <- new_operation(
    name = "DeleteExperimentTemplate",
    http_method = "DELETE",
    http_path = "/experimentTemplates/{id}",
    paginator = list()
  )
  input <- .fis$delete_experiment_template_input(id = id)
  output <- .fis$delete_experiment_template_output()
  config <- get_config()
  svc <- .fis$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.fis$operations$delete_experiment_template <- fis_delete_experiment_template

#' Gets information about the specified FIS action
#'
#' @description
#' Gets information about the specified FIS action.
#'
#' See [https://paws-r.github.io/docs/fis/get_action.html](https://paws-r.github.io/docs/fis/get_action.html) for full documentation.
#'
#' @param id &#91;required&#93; The ID of the action.
#'
#' @keywords internal
#'
#' @rdname fis_get_action
fis_get_action <- function(id) {
  op <- new_operation(
    name = "GetAction",
    http_method = "GET",
    http_path = "/actions/{id}",
    paginator = list()
  )
  input <- .fis$get_action_input(id = id)
  output <- .fis$get_action_output()
  config <- get_config()
  svc <- .fis$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.fis$operations$get_action <- fis_get_action

#' Gets information about the specified experiment
#'
#' @description
#' Gets information about the specified experiment.
#'
#' See [https://paws-r.github.io/docs/fis/get_experiment.html](https://paws-r.github.io/docs/fis/get_experiment.html) for full documentation.
#'
#' @param id &#91;required&#93; The ID of the experiment.
#'
#' @keywords internal
#'
#' @rdname fis_get_experiment
fis_get_experiment <- function(id) {
  op <- new_operation(
    name = "GetExperiment",
    http_method = "GET",
    http_path = "/experiments/{id}",
    paginator = list()
  )
  input <- .fis$get_experiment_input(id = id)
  output <- .fis$get_experiment_output()
  config <- get_config()
  svc <- .fis$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.fis$operations$get_experiment <- fis_get_experiment

#' Gets information about the specified experiment template
#'
#' @description
#' Gets information about the specified experiment template.
#'
#' See [https://paws-r.github.io/docs/fis/get_experiment_template.html](https://paws-r.github.io/docs/fis/get_experiment_template.html) for full documentation.
#'
#' @param id &#91;required&#93; The ID of the experiment template.
#'
#' @keywords internal
#'
#' @rdname fis_get_experiment_template
fis_get_experiment_template <- function(id) {
  op <- new_operation(
    name = "GetExperimentTemplate",
    http_method = "GET",
    http_path = "/experimentTemplates/{id}",
    paginator = list()
  )
  input <- .fis$get_experiment_template_input(id = id)
  output <- .fis$get_experiment_template_output()
  config <- get_config()
  svc <- .fis$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.fis$operations$get_experiment_template <- fis_get_experiment_template

#' Gets information about the specified resource type
#'
#' @description
#' Gets information about the specified resource type.
#'
#' See [https://paws-r.github.io/docs/fis/get_target_resource_type.html](https://paws-r.github.io/docs/fis/get_target_resource_type.html) for full documentation.
#'
#' @param resourceType &#91;required&#93; The resource type.
#'
#' @keywords internal
#'
#' @rdname fis_get_target_resource_type
fis_get_target_resource_type <- function(resourceType) {
  op <- new_operation(
    name = "GetTargetResourceType",
    http_method = "GET",
    http_path = "/targetResourceTypes/{resourceType}",
    paginator = list()
  )
  input <- .fis$get_target_resource_type_input(resourceType = resourceType)
  output <- .fis$get_target_resource_type_output()
  config <- get_config()
  svc <- .fis$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.fis$operations$get_target_resource_type <- fis_get_target_resource_type

#' Lists the available FIS actions
#'
#' @description
#' Lists the available FIS actions.
#'
#' See [https://paws-r.github.io/docs/fis/list_actions.html](https://paws-r.github.io/docs/fis/list_actions.html) for full documentation.
#'
#' @param maxResults The maximum number of results to return with a single call. To retrieve
#' the remaining results, make another call with the returned `nextToken`
#' value.
#' @param nextToken The token for the next page of results.
#'
#' @keywords internal
#'
#' @rdname fis_list_actions
fis_list_actions <- function(maxResults = NULL, nextToken = NULL) {
  op <- new_operation(
    name = "ListActions",
    http_method = "GET",
    http_path = "/actions",
    paginator = list()
  )
  input <- .fis$list_actions_input(maxResults = maxResults, nextToken = nextToken)
  output <- .fis$list_actions_output()
  config <- get_config()
  svc <- .fis$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.fis$operations$list_actions <- fis_list_actions

#' Lists your experiment templates
#'
#' @description
#' Lists your experiment templates.
#'
#' See [https://paws-r.github.io/docs/fis/list_experiment_templates.html](https://paws-r.github.io/docs/fis/list_experiment_templates.html) for full documentation.
#'
#' @param maxResults The maximum number of results to return with a single call. To retrieve
#' the remaining results, make another call with the returned `nextToken`
#' value.
#' @param nextToken The token for the next page of results.
#'
#' @keywords internal
#'
#' @rdname fis_list_experiment_templates
fis_list_experiment_templates <- function(maxResults = NULL, nextToken = NULL) {
  op <- new_operation(
    name = "ListExperimentTemplates",
    http_method = "GET",
    http_path = "/experimentTemplates",
    paginator = list()
  )
  input <- .fis$list_experiment_templates_input(maxResults = maxResults, nextToken = nextToken)
  output <- .fis$list_experiment_templates_output()
  config <- get_config()
  svc <- .fis$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.fis$operations$list_experiment_templates <- fis_list_experiment_templates

#' Lists your experiments
#'
#' @description
#' Lists your experiments.
#'
#' See [https://paws-r.github.io/docs/fis/list_experiments.html](https://paws-r.github.io/docs/fis/list_experiments.html) for full documentation.
#'
#' @param maxResults The maximum number of results to return with a single call. To retrieve
#' the remaining results, make another call with the returned `nextToken`
#' value.
#' @param nextToken The token for the next page of results.
#'
#' @keywords internal
#'
#' @rdname fis_list_experiments
fis_list_experiments <- function(maxResults = NULL, nextToken = NULL) {
  op <- new_operation(
    name = "ListExperiments",
    http_method = "GET",
    http_path = "/experiments",
    paginator = list()
  )
  input <- .fis$list_experiments_input(maxResults = maxResults, nextToken = nextToken)
  output <- .fis$list_experiments_output()
  config <- get_config()
  svc <- .fis$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.fis$operations$list_experiments <- fis_list_experiments

#' Lists the tags for the specified resource
#'
#' @description
#' Lists the tags for the specified resource.
#'
#' See [https://paws-r.github.io/docs/fis/list_tags_for_resource.html](https://paws-r.github.io/docs/fis/list_tags_for_resource.html) for full documentation.
#'
#' @param resourceArn &#91;required&#93; The Amazon Resource Name (ARN) of the resource.
#'
#' @keywords internal
#'
#' @rdname fis_list_tags_for_resource
fis_list_tags_for_resource <- function(resourceArn) {
  op <- new_operation(
    name = "ListTagsForResource",
    http_method = "GET",
    http_path = "/tags/{resourceArn}",
    paginator = list()
  )
  input <- .fis$list_tags_for_resource_input(resourceArn = resourceArn)
  output <- .fis$list_tags_for_resource_output()
  config <- get_config()
  svc <- .fis$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.fis$operations$list_tags_for_resource <- fis_list_tags_for_resource

#' Lists the target resource types
#'
#' @description
#' Lists the target resource types.
#'
#' See [https://paws-r.github.io/docs/fis/list_target_resource_types.html](https://paws-r.github.io/docs/fis/list_target_resource_types.html) for full documentation.
#'
#' @param maxResults The maximum number of results to return with a single call. To retrieve
#' the remaining results, make another call with the returned `nextToken`
#' value.
#' @param nextToken The token for the next page of results.
#'
#' @keywords internal
#'
#' @rdname fis_list_target_resource_types
fis_list_target_resource_types <- function(maxResults = NULL, nextToken = NULL) {
  op <- new_operation(
    name = "ListTargetResourceTypes",
    http_method = "GET",
    http_path = "/targetResourceTypes",
    paginator = list()
  )
  input <- .fis$list_target_resource_types_input(maxResults = maxResults, nextToken = nextToken)
  output <- .fis$list_target_resource_types_output()
  config <- get_config()
  svc <- .fis$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.fis$operations$list_target_resource_types <- fis_list_target_resource_types

#' Starts running an experiment from the specified experiment template
#'
#' @description
#' Starts running an experiment from the specified experiment template.
#'
#' See [https://paws-r.github.io/docs/fis/start_experiment.html](https://paws-r.github.io/docs/fis/start_experiment.html) for full documentation.
#'
#' @param clientToken &#91;required&#93; Unique, case-sensitive identifier that you provide to ensure the
#' idempotency of the request.
#' @param experimentTemplateId &#91;required&#93; The ID of the experiment template.
#' @param tags The tags to apply to the experiment.
#'
#' @keywords internal
#'
#' @rdname fis_start_experiment
fis_start_experiment <- function(clientToken, experimentTemplateId, tags = NULL) {
  op <- new_operation(
    name = "StartExperiment",
    http_method = "POST",
    http_path = "/experiments",
    paginator = list()
  )
  input <- .fis$start_experiment_input(clientToken = clientToken, experimentTemplateId = experimentTemplateId, tags = tags)
  output <- .fis$start_experiment_output()
  config <- get_config()
  svc <- .fis$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.fis$operations$start_experiment <- fis_start_experiment

#' Stops the specified experiment
#'
#' @description
#' Stops the specified experiment.
#'
#' See [https://paws-r.github.io/docs/fis/stop_experiment.html](https://paws-r.github.io/docs/fis/stop_experiment.html) for full documentation.
#'
#' @param id &#91;required&#93; The ID of the experiment.
#'
#' @keywords internal
#'
#' @rdname fis_stop_experiment
fis_stop_experiment <- function(id) {
  op <- new_operation(
    name = "StopExperiment",
    http_method = "DELETE",
    http_path = "/experiments/{id}",
    paginator = list()
  )
  input <- .fis$stop_experiment_input(id = id)
  output <- .fis$stop_experiment_output()
  config <- get_config()
  svc <- .fis$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.fis$operations$stop_experiment <- fis_stop_experiment

#' Applies the specified tags to the specified resource
#'
#' @description
#' Applies the specified tags to the specified resource.
#'
#' See [https://paws-r.github.io/docs/fis/tag_resource.html](https://paws-r.github.io/docs/fis/tag_resource.html) for full documentation.
#'
#' @param resourceArn &#91;required&#93; The Amazon Resource Name (ARN) of the resource.
#' @param tags &#91;required&#93; The tags for the resource.
#'
#' @keywords internal
#'
#' @rdname fis_tag_resource
fis_tag_resource <- function(resourceArn, tags) {
  op <- new_operation(
    name = "TagResource",
    http_method = "POST",
    http_path = "/tags/{resourceArn}",
    paginator = list()
  )
  input <- .fis$tag_resource_input(resourceArn = resourceArn, tags = tags)
  output <- .fis$tag_resource_output()
  config <- get_config()
  svc <- .fis$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.fis$operations$tag_resource <- fis_tag_resource

#' Removes the specified tags from the specified resource
#'
#' @description
#' Removes the specified tags from the specified resource.
#'
#' See [https://paws-r.github.io/docs/fis/untag_resource.html](https://paws-r.github.io/docs/fis/untag_resource.html) for full documentation.
#'
#' @param resourceArn &#91;required&#93; The Amazon Resource Name (ARN) of the resource.
#' @param tagKeys The tag keys to remove.
#'
#' @keywords internal
#'
#' @rdname fis_untag_resource
fis_untag_resource <- function(resourceArn, tagKeys = NULL) {
  op <- new_operation(
    name = "UntagResource",
    http_method = "DELETE",
    http_path = "/tags/{resourceArn}",
    paginator = list()
  )
  input <- .fis$untag_resource_input(resourceArn = resourceArn, tagKeys = tagKeys)
  output <- .fis$untag_resource_output()
  config <- get_config()
  svc <- .fis$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.fis$operations$untag_resource <- fis_untag_resource

#' Updates the specified experiment template
#'
#' @description
#' Updates the specified experiment template.
#'
#' See [https://paws-r.github.io/docs/fis/update_experiment_template.html](https://paws-r.github.io/docs/fis/update_experiment_template.html) for full documentation.
#'
#' @param id &#91;required&#93; The ID of the experiment template.
#' @param description A description for the template.
#' @param stopConditions The stop conditions for the experiment.
#' @param targets The targets for the experiment.
#' @param actions The actions for the experiment.
#' @param roleArn The Amazon Resource Name (ARN) of an IAM role that grants the FIS
#' service permission to perform service actions on your behalf.
#' @param logConfiguration The configuration for experiment logging.
#'
#' @keywords internal
#'
#' @rdname fis_update_experiment_template
fis_update_experiment_template <- function(id, description = NULL, stopConditions = NULL, targets = NULL, actions = NULL, roleArn = NULL, logConfiguration = NULL) {
  op <- new_operation(
    name = "UpdateExperimentTemplate",
    http_method = "PATCH",
    http_path = "/experimentTemplates/{id}",
    paginator = list()
  )
  input <- .fis$update_experiment_template_input(id = id, description = description, stopConditions = stopConditions, targets = targets, actions = actions, roleArn = roleArn, logConfiguration = logConfiguration)
  output <- .fis$update_experiment_template_output()
  config <- get_config()
  svc <- .fis$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.fis$operations$update_experiment_template <- fis_update_experiment_template
