% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/codepipeline_operations.R
\name{codepipeline_poll_for_jobs}
\alias{codepipeline_poll_for_jobs}
\title{Returns information about any jobs for AWS CodePipeline to act on}
\usage{
codepipeline_poll_for_jobs(actionTypeId, maxBatchSize, queryParam)
}
\arguments{
\item{actionTypeId}{[required] Represents information about an action type.}

\item{maxBatchSize}{The maximum number of jobs to return in a poll for jobs call.}

\item{queryParam}{A map of property names and values. For an action type with no queryable
properties, this value must be null or an empty map. For an action type
with a queryable property, you must supply that property as a key in the
map. Only jobs whose action configuration matches the mapped value are
returned.}
}
\value{
A list with the following syntax:\preformatted{list(
  jobs = list(
    list(
      id = "string",
      data = list(
        actionTypeId = list(
          category = "Source"|"Build"|"Deploy"|"Test"|"Invoke"|"Approval",
          owner = "AWS"|"ThirdParty"|"Custom",
          provider = "string",
          version = "string"
        ),
        actionConfiguration = list(
          configuration = list(
            "string"
          )
        ),
        pipelineContext = list(
          pipelineName = "string",
          stage = list(
            name = "string"
          ),
          action = list(
            name = "string",
            actionExecutionId = "string"
          ),
          pipelineArn = "string",
          pipelineExecutionId = "string"
        ),
        inputArtifacts = list(
          list(
            name = "string",
            revision = "string",
            location = list(
              type = "S3",
              s3Location = list(
                bucketName = "string",
                objectKey = "string"
              )
            )
          )
        ),
        outputArtifacts = list(
          list(
            name = "string",
            revision = "string",
            location = list(
              type = "S3",
              s3Location = list(
                bucketName = "string",
                objectKey = "string"
              )
            )
          )
        ),
        artifactCredentials = list(
          accessKeyId = "string",
          secretAccessKey = "string",
          sessionToken = "string"
        ),
        continuationToken = "string",
        encryptionKey = list(
          id = "string",
          type = "KMS"
        )
      ),
      nonce = "string",
      accountId = "string"
    )
  )
)
}
}
\description{
Returns information about any jobs for AWS CodePipeline to act on.
\code{\link[=codepipeline_poll_for_jobs]{poll_for_jobs}} is valid only for action
types with "Custom" in the owner field. If the action type contains
"AWS" or "ThirdParty" in the owner field, the
\code{\link[=codepipeline_poll_for_jobs]{poll_for_jobs}} action returns an error.

When this API is called, AWS CodePipeline returns temporary credentials
for the S3 bucket used to store artifacts for the pipeline, if the
action requires access to that S3 bucket for input or output artifacts.
This API also returns any secret values defined for the action.
}
\section{Request syntax}{
\preformatted{svc$poll_for_jobs(
  actionTypeId = list(
    category = "Source"|"Build"|"Deploy"|"Test"|"Invoke"|"Approval",
    owner = "AWS"|"ThirdParty"|"Custom",
    provider = "string",
    version = "string"
  ),
  maxBatchSize = 123,
  queryParam = list(
    "string"
  )
)
}
}

\keyword{internal}
