% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rds_operations.R
\name{rds_start_activity_stream}
\alias{rds_start_activity_stream}
\title{Starts a database activity stream to monitor activity on the database}
\usage{
rds_start_activity_stream(
  ResourceArn,
  Mode,
  KmsKeyId,
  ApplyImmediately = NULL,
  EngineNativeAuditFieldsIncluded = NULL
)
}
\arguments{
\item{ResourceArn}{[required] The Amazon Resource Name (ARN) of the DB cluster, for example,
\code{arn:aws:rds:us-east-1:12345667890:cluster:das-cluster}.}

\item{Mode}{[required] Specifies the mode of the database activity stream. Database events such
as a change or access generate an activity stream event. The database
session can handle these events either synchronously or asynchronously.}

\item{KmsKeyId}{[required] The Amazon Web Services KMS key identifier for encrypting messages in
the database activity stream. The Amazon Web Services KMS key identifier
is the key ARN, key ID, alias ARN, or alias name for the KMS key.}

\item{ApplyImmediately}{Specifies whether or not the database activity stream is to start as
soon as possible, regardless of the maintenance window for the database.}

\item{EngineNativeAuditFieldsIncluded}{Specifies whether the database activity stream includes engine-native
audit fields. This option applies to an Oracle or Microsoft SQL Server
DB instance. By default, no engine-native audit fields are included.}
}
\description{
Starts a database activity stream to monitor activity on the database. For more information, see \href{https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/DBActivityStreams.html}{Monitoring Amazon Aurora with Database Activity Streams} in the \emph{Amazon Aurora User Guide} or \href{https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/DBActivityStreams.html}{Monitoring Amazon RDS with Database Activity Streams} in the \emph{Amazon RDS User Guide}.

See \url{https://www.paws-r-sdk.com/docs/rds_start_activity_stream/} for full documentation.
}
\keyword{internal}
