% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/elasticache_operations.R
\name{elasticache_describe_cache_subnet_groups}
\alias{elasticache_describe_cache_subnet_groups}
\title{Returns a list of cache subnet group descriptions}
\usage{
elasticache_describe_cache_subnet_groups(
  CacheSubnetGroupName = NULL,
  MaxRecords = NULL,
  Marker = NULL
)
}
\arguments{
\item{CacheSubnetGroupName}{The name of the cache subnet group to return details for.}

\item{MaxRecords}{The maximum number of records to include in the response. If more
records exist than the specified \code{MaxRecords} value, a marker is
included in the response so that the remaining results can be retrieved.

Default: 100

Constraints: minimum 20; maximum 100.}

\item{Marker}{An optional marker returned from a prior request. Use this marker for
pagination of results from this operation. If this parameter is
specified, the response includes only records beyond the marker, up to
the value specified by \code{MaxRecords}.}
}
\description{
Returns a list of cache subnet group descriptions. If a subnet group name is specified, the list contains only the description of that group. This is applicable only when you have ElastiCache in VPC setup. All ElastiCache clusters now launch in VPC by default.

See \url{https://www.paws-r-sdk.com/docs/elasticache_describe_cache_subnet_groups/} for full documentation.
}
\keyword{internal}
