% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rds_operations.R
\name{rds_create_db_proxy}
\alias{rds_create_db_proxy}
\title{Creates a new DB proxy}
\usage{
rds_create_db_proxy(
  DBProxyName,
  EngineFamily,
  Auth,
  RoleArn,
  VpcSubnetIds,
  VpcSecurityGroupIds = NULL,
  RequireTLS = NULL,
  IdleClientTimeout = NULL,
  DebugLogging = NULL,
  Tags = NULL
)
}
\arguments{
\item{DBProxyName}{[required] The identifier for the proxy. This name must be unique for all proxies
owned by your Amazon Web Services account in the specified Amazon Web
Services Region. An identifier must begin with a letter and must contain
only ASCII letters, digits, and hyphens; it can't end with a hyphen or
contain two consecutive hyphens.}

\item{EngineFamily}{[required] The kinds of databases that the proxy can connect to. This value
determines which database network protocol the proxy recognizes when it
interprets network traffic to and from the database. For Aurora MySQL,
RDS for MariaDB, and RDS for MySQL databases, specify \code{MYSQL}. For
Aurora PostgreSQL and RDS for PostgreSQL databases, specify
\code{POSTGRESQL}.}

\item{Auth}{[required] The authorization mechanism that the proxy uses.}

\item{RoleArn}{[required] The Amazon Resource Name (ARN) of the IAM role that the proxy uses to
access secrets in Amazon Web Services Secrets Manager.}

\item{VpcSubnetIds}{[required] One or more VPC subnet IDs to associate with the new proxy.}

\item{VpcSecurityGroupIds}{One or more VPC security group IDs to associate with the new proxy.}

\item{RequireTLS}{A Boolean parameter that specifies whether Transport Layer Security
(TLS) encryption is required for connections to the proxy. By enabling
this setting, you can enforce encrypted TLS connections to the proxy.}

\item{IdleClientTimeout}{The number of seconds that a connection to the proxy can be inactive
before the proxy disconnects it. You can set this value higher or lower
than the connection timeout limit for the associated database.}

\item{DebugLogging}{Whether the proxy includes detailed information about SQL statements in
its logs. This information helps you to debug issues involving SQL
behavior or the performance and scalability of the proxy connections.
The debug information includes the text of SQL statements that you
submit through the proxy. Thus, only enable this setting when needed for
debugging, and only when you have security measures in place to
safeguard any sensitive information that appears in the logs.}

\item{Tags}{An optional set of key-value pairs to associate arbitrary data of your
choosing with the proxy.}
}
\description{
Creates a new DB proxy.

See \url{https://paws-r.github.io/docs/rds/create_db_proxy.html} for full documentation.
}
\keyword{internal}
