% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/docdb_operations.R
\name{docdb_create_db_cluster_parameter_group}
\alias{docdb_create_db_cluster_parameter_group}
\title{Creates a new DB cluster parameter group}
\usage{
docdb_create_db_cluster_parameter_group(DBClusterParameterGroupName,
  DBParameterGroupFamily, Description, Tags)
}
\arguments{
\item{DBClusterParameterGroupName}{[required] The name of the DB cluster parameter group.

Constraints:
\itemize{
\item Must match the name of an existing \code{DBClusterParameterGroup}.
}

This value is stored as a lowercase string.}

\item{DBParameterGroupFamily}{[required] The DB cluster parameter group family name.}

\item{Description}{[required] The description for the DB cluster parameter group.}

\item{Tags}{The tags to be assigned to the DB cluster parameter group.}
}
\description{
Creates a new DB cluster parameter group.
}
\details{
Parameters in a DB cluster parameter group apply to all of the instances
in a DB cluster.

A DB cluster parameter group is initially created with the default
parameters for the database engine used by instances in the DB cluster.
To provide custom values for any of the parameters, you must modify the
group after you create it. After you create a DB cluster parameter
group, you must associate it with your DB cluster. For the new DB
cluster parameter group and associated settings to take effect, you must
then reboot the DB instances in the DB cluster without failover.

After you create a DB cluster parameter group, you should wait at least
5 minutes before creating your first DB cluster that uses that DB
cluster parameter group as the default parameter group. This allows
Amazon DocumentDB to fully complete the create action before the DB
cluster parameter group is used as the default for a new DB cluster.
This step is especially important for parameters that are critical when
creating the default database for a DB cluster, such as the character
set for the default database defined by the \code{character_set_database}
parameter.
}
\section{Request syntax}{
\preformatted{svc$create_db_cluster_parameter_group(
  DBClusterParameterGroupName = "string",
  DBParameterGroupFamily = "string",
  Description = "string",
  Tags = list(
    list(
      Key = "string",
      Value = "string"
    )
  )
)
}
}

\keyword{internal}
