% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/elasticache_operations.R
\name{elasticache_describe_replication_groups}
\alias{elasticache_describe_replication_groups}
\title{Returns information about a particular replication group}
\usage{
elasticache_describe_replication_groups(ReplicationGroupId, MaxRecords,
  Marker)
}
\arguments{
\item{ReplicationGroupId}{The identifier for the replication group to be described. This parameter
is not case sensitive.

If you do not specify this parameter, information about all replication
groups is returned.}

\item{MaxRecords}{The maximum number of records to include in the response. If more
records exist than the specified \code{MaxRecords} value, a marker is
included in the response so that the remaining results can be retrieved.

Default: 100

Constraints: minimum 20; maximum 100.}

\item{Marker}{An optional marker returned from a prior request. Use this marker for
pagination of results from this operation. If this parameter is
specified, the response includes only records beyond the marker, up to
the value specified by \code{MaxRecords}.}
}
\value{
A list with the following syntax:\preformatted{list(
  Marker = "string",
  ReplicationGroups = list(
    list(
      ReplicationGroupId = "string",
      Description = "string",
      GlobalReplicationGroupInfo = list(
        GlobalReplicationGroupId = "string",
        GlobalReplicationGroupMemberRole = "string"
      ),
      Status = "string",
      PendingModifiedValues = list(
        PrimaryClusterId = "string",
        AutomaticFailoverStatus = "enabled"|"disabled",
        Resharding = list(
          SlotMigration = list(
            ProgressPercentage = 123.0
          )
        ),
        AuthTokenStatus = "SETTING"|"ROTATING",
        UserGroups = list(
          UserGroupIdsToAdd = list(
            "string"
          ),
          UserGroupIdsToRemove = list(
            "string"
          )
        )
      ),
      MemberClusters = list(
        "string"
      ),
      NodeGroups = list(
        list(
          NodeGroupId = "string",
          Status = "string",
          PrimaryEndpoint = list(
            Address = "string",
            Port = 123
          ),
          ReaderEndpoint = list(
            Address = "string",
            Port = 123
          ),
          Slots = "string",
          NodeGroupMembers = list(
            list(
              CacheClusterId = "string",
              CacheNodeId = "string",
              ReadEndpoint = list(
                Address = "string",
                Port = 123
              ),
              PreferredAvailabilityZone = "string",
              PreferredOutpostArn = "string",
              CurrentRole = "string"
            )
          )
        )
      ),
      SnapshottingClusterId = "string",
      AutomaticFailover = "enabled"|"disabled"|"enabling"|"disabling",
      MultiAZ = "enabled"|"disabled",
      ConfigurationEndpoint = list(
        Address = "string",
        Port = 123
      ),
      SnapshotRetentionLimit = 123,
      SnapshotWindow = "string",
      ClusterEnabled = TRUE|FALSE,
      CacheNodeType = "string",
      AuthTokenEnabled = TRUE|FALSE,
      AuthTokenLastModifiedDate = as.POSIXct(
        "2015-01-01"
      ),
      TransitEncryptionEnabled = TRUE|FALSE,
      AtRestEncryptionEnabled = TRUE|FALSE,
      MemberClustersOutpostArns = list(
        "string"
      ),
      KmsKeyId = "string",
      ARN = "string",
      UserGroupIds = list(
        "string"
      )
    )
  )
)
}
}
\description{
Returns information about a particular replication group. If no
identifier is specified,
\code{\link[=elasticache_describe_replication_groups]{describe_replication_groups}}
returns information about all replication groups.

This operation is valid for Redis only.
}
\section{Request syntax}{
\preformatted{svc$describe_replication_groups(
  ReplicationGroupId = "string",
  MaxRecords = 123,
  Marker = "string"
)
}
}

\keyword{internal}
