% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dynamodbstreams_operations.R
\name{dynamodbstreams_describe_stream}
\alias{dynamodbstreams_describe_stream}
\title{Returns information about a stream, including the current status of the
stream, its Amazon Resource Name (ARN), the composition of its shards,
and its corresponding DynamoDB table}
\usage{
dynamodbstreams_describe_stream(StreamArn, Limit, ExclusiveStartShardId)
}
\arguments{
\item{StreamArn}{[required] The Amazon Resource Name (ARN) for the stream.}

\item{Limit}{The maximum number of shard objects to return. The upper limit is 100.}

\item{ExclusiveStartShardId}{The shard ID of the first item that this operation will evaluate. Use
the value that was returned for \code{LastEvaluatedShardId} in the previous
operation.}
}
\value{
A list with the following syntax:\preformatted{list(
  StreamDescription = list(
    StreamArn = "string",
    StreamLabel = "string",
    StreamStatus = "ENABLING"|"ENABLED"|"DISABLING"|"DISABLED",
    StreamViewType = "NEW_IMAGE"|"OLD_IMAGE"|"NEW_AND_OLD_IMAGES"|"KEYS_ONLY",
    CreationRequestDateTime = as.POSIXct(
      "2015-01-01"
    ),
    TableName = "string",
    KeySchema = list(
      list(
        AttributeName = "string",
        KeyType = "HASH"|"RANGE"
      )
    ),
    Shards = list(
      list(
        ShardId = "string",
        SequenceNumberRange = list(
          StartingSequenceNumber = "string",
          EndingSequenceNumber = "string"
        ),
        ParentShardId = "string"
      )
    ),
    LastEvaluatedShardId = "string"
  )
)
}
}
\description{
Returns information about a stream, including the current status of the
stream, its Amazon Resource Name (ARN), the composition of its shards,
and its corresponding DynamoDB table.

You can call \code{\link[=dynamodbstreams_describe_stream]{describe_stream}} at a
maximum rate of 10 times per second.

Each shard in the stream has a \code{SequenceNumberRange} associated with it.
If the \code{SequenceNumberRange} has a \code{StartingSequenceNumber} but no
\code{EndingSequenceNumber}, then the shard is still open (able to receive
more stream records). If both \code{StartingSequenceNumber} and
\code{EndingSequenceNumber} are present, then that shard is closed and can no
longer receive more data.
}
\section{Request syntax}{
\preformatted{svc$describe_stream(
  StreamArn = "string",
  Limit = 123,
  ExclusiveStartShardId = "string"
)
}
}

\examples{
\dontrun{
# The following example describes a stream with a given stream ARN.
svc$describe_stream(
  StreamArn = "arn:aws:dynamodb:us-west-2:111122223333:table/Forum/stream/2..."
)
}

}
\keyword{internal}
