% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rds_operations.R
\name{rds_describe_db_cluster_backtracks}
\alias{rds_describe_db_cluster_backtracks}
\title{Returns information about backtracks for a DB cluster}
\usage{
rds_describe_db_cluster_backtracks(DBClusterIdentifier,
  BacktrackIdentifier, Filters, MaxRecords, Marker)
}
\arguments{
\item{DBClusterIdentifier}{[required] The DB cluster identifier of the DB cluster to be described. This
parameter is stored as a lowercase string.

Constraints:
\itemize{
\item Must contain from 1 to 63 alphanumeric characters or hyphens.
\item First character must be a letter.
\item Can't end with a hyphen or contain two consecutive hyphens.
}

Example: \code{my-cluster1}}

\item{BacktrackIdentifier}{If specified, this value is the backtrack identifier of the backtrack to
be described.

Constraints:
\itemize{
\item Must contain a valid universally unique identifier (UUID). For more
information about UUIDs, see \href{http://www.ietf.org/rfc/rfc4122.txt}{A Universally Unique Identifier (UUID) URN Namespace}.
}

Example: \code{123e4567-e89b-12d3-a456-426655440000}}

\item{Filters}{A filter that specifies one or more DB clusters to describe. Supported
filters include the following:
\itemize{
\item \code{db-cluster-backtrack-id} - Accepts backtrack identifiers. The
results list includes information about only the backtracks
identified by these identifiers.
\item \code{db-cluster-backtrack-status} - Accepts any of the following
backtrack status values:
\itemize{
\item \code{applying}
\item \code{completed}
\item \code{failed}
\item \code{pending}
}

The results list includes information about only the backtracks
identified by these values. For more information about backtrack
status values, see DBClusterBacktrack.
}}

\item{MaxRecords}{The maximum number of records to include in the response. If more
records exist than the specified \code{MaxRecords} value, a pagination token
called a marker is included in the response so that the remaining
results can be retrieved.

Default: 100

Constraints: Minimum 20, maximum 100.}

\item{Marker}{An optional pagination token provided by a previous
DescribeDBClusterBacktracks request. If this parameter is specified, the
response includes only records beyond the marker, up to the value
specified by \code{MaxRecords}.}
}
\description{
Returns information about backtracks for a DB cluster.
}
\details{
For more information on Amazon Aurora, see \href{https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/CHAP_AuroraOverview.html}{What Is Amazon Aurora?}
in the \emph{Amazon Aurora User Guide.}

This action only applies to Aurora DB clusters.
}
\section{Request syntax}{
\preformatted{svc$describe_db_cluster_backtracks(
  DBClusterIdentifier = "string",
  BacktrackIdentifier = "string",
  Filters = list(
    list(
      Name = "string",
      Values = list(
        "string"
      )
    )
  ),
  MaxRecords = 123,
  Marker = "string"
)
}
}

\keyword{internal}
