% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/elasticache_operations.R
\name{elasticache_remove_tags_from_resource}
\alias{elasticache_remove_tags_from_resource}
\title{Removes the tags identified by the TagKeys list from the named resource}
\usage{
elasticache_remove_tags_from_resource(ResourceName, TagKeys)
}
\arguments{
\item{ResourceName}{[required] The Amazon Resource Name (ARN) of the resource from which you want the
tags removed, for example
\code{arn:aws:elasticache:us-west-2:0123456789:cluster:myCluster} or
\code{arn:aws:elasticache:us-west-2:0123456789:snapshot:mySnapshot}.

For more information about ARNs, see \href{http://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html}{Amazon Resource Names (ARNs) and AWS Service Namespaces}.}

\item{TagKeys}{[required] A list of \code{TagKeys} identifying the tags you want removed from the named
resource.}
}
\description{
Removes the tags identified by the \code{TagKeys} list from the named
resource.
}
\section{Request syntax}{
\preformatted{svc$remove_tags_from_resource(
  ResourceName = "string",
  TagKeys = list(
    "string"
  )
)
}
}

\keyword{internal}
