% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/connect_operations.R
\name{connect_start_task_contact}
\alias{connect_start_task_contact}
\title{Initiates a flow to start a new task contact}
\usage{
connect_start_task_contact(
  InstanceId,
  PreviousContactId = NULL,
  ContactFlowId = NULL,
  Attributes = NULL,
  Name,
  References = NULL,
  Description = NULL,
  ClientToken = NULL,
  ScheduledTime = NULL,
  TaskTemplateId = NULL,
  QuickConnectId = NULL,
  RelatedContactId = NULL,
  SegmentAttributes = NULL
)
}
\arguments{
\item{InstanceId}{[required] The identifier of the Amazon Connect instance. You can \href{https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html}{find the instance ID}
in the Amazon Resource Name (ARN) of the instance.}

\item{PreviousContactId}{The identifier of the previous chat, voice, or task contact. Any updates
to user-defined attributes to task contacts linked using the same
\code{PreviousContactID} will affect every contact in the chain. There can be
a maximum of 12 linked task contacts in a chain.}

\item{ContactFlowId}{The identifier of the flow for initiating the tasks. To see the
ContactFlowId in the Amazon Connect admin website, on the navigation
menu go to \strong{Routing}, \strong{Flows}. Choose the flow. On the flow page,
under the name of the flow, choose \strong{Show additional flow information}.
The ContactFlowId is the last part of the ARN, shown here in bold:

arn:aws:connect:us-west-2:xxxxxxxxxxxx:instance/xxxxxxxx-xxxx-xxxx-xxxx-xxxxxxxxxxxx/contact-flow/\strong{846ec553-a005-41c0-8341-xxxxxxxxxxxx}}

\item{Attributes}{A custom key-value pair using an attribute map. The attributes are
standard Amazon Connect attributes, and can be accessed in flows just
like any other contact attributes.

There can be up to 32,768 UTF-8 bytes across all key-value pairs per
contact. Attribute keys can include only alphanumeric, dash, and
underscore characters.}

\item{Name}{[required] The name of a task that is shown to an agent in the Contact Control
Panel (CCP).}

\item{References}{A formatted URL that is shown to an agent in the Contact Control Panel
(CCP). Tasks can have the following reference types at the time of
creation: \code{URL} | \code{NUMBER} | \code{STRING} | \code{DATE} | \code{EMAIL}. \code{ATTACHMENT}
is not a supported reference type during task creation.}

\item{Description}{A description of the task that is shown to an agent in the Contact
Control Panel (CCP).}

\item{ClientToken}{A unique, case-sensitive identifier that you provide to ensure the
idempotency of the request. If not provided, the Amazon Web Services SDK
populates this field. For more information about idempotency, see
\href{https://aws.amazon.com/builders-library/making-retries-safe-with-idempotent-APIs/}{Making retries safe with idempotent APIs}.}

\item{ScheduledTime}{The timestamp, in Unix Epoch seconds format, at which to start running
the inbound flow. The scheduled time cannot be in the past. It must be
within up to 6 days in future.}

\item{TaskTemplateId}{A unique identifier for the task template. For more information about
task templates, see \href{https://docs.aws.amazon.com/connect/latest/adminguide/task-templates.html}{Create task templates}
in the \emph{Amazon Connect Administrator Guide}.}

\item{QuickConnectId}{The identifier for the quick connect. Tasks that are created by using
\code{QuickConnectId} will use the flow that is defined on agent or queue
quick connect. For more information about quick connects, see \href{https://docs.aws.amazon.com/connect/latest/adminguide/quick-connects.html}{Create quick connects}.}

\item{RelatedContactId}{The contactId that is
\href{https://docs.aws.amazon.com/connect/latest/adminguide/tasks.html#linked-tasks}{related}
to this contact. Linking tasks together by using \code{RelatedContactID}
copies over contact attributes from the related task contact to the new
task contact. All updates to user-defined attributes in the new task
contact are limited to the individual contact ID, unlike what happens
when tasks are linked by using \code{PreviousContactID}. There are no limits
to the number of contacts that can be linked by using
\code{RelatedContactId}.}

\item{SegmentAttributes}{A set of system defined key-value pairs stored on individual contact
segments (unique contact ID) using an attribute map. The attributes are
standard Amazon Connect attributes. They can be accessed in flows.

Attribute keys can include only alphanumeric, -, and _.

This field can be used to set Contact Expiry as a duration in minutes
and set a UserId for the User who created a task.

To set contact expiry, a ValueMap must be specified containing the
integer number of minutes the contact will be active for before
expiring, with \code{SegmentAttributes} like \{
\verb{ "connect:ContactExpiry": \\\{"ValueMap" : \\\{ "ExpiryDuration": \\\{ "ValueInteger": 135\\\}\\\}\\\}\\\}}.

To set the created by user, a valid AgentResourceId must be supplied,
with \code{SegmentAttributes} like \{
\verb{"connect:CreatedByUser" \\\{ "ValueString": "arn:aws:connect:us-west-2:xxxxxxxxxxxx:instance/xxxxxxxx-xxxx-xxxx-xxxx-xxxxxxxxxxxx/agent/xxxxxxxx-xxxx-xxxx-xxxx-xxxxxxxxxxxx"\\\}\\\}\\\}}.}
}
\description{
Initiates a flow to start a new task contact. For more information about task contacts, see \href{https://docs.aws.amazon.com/connect/latest/adminguide/tasks.html}{Concepts: Tasks in Amazon Connect} in the \emph{Amazon Connect Administrator Guide}.

See \url{https://www.paws-r-sdk.com/docs/connect_start_task_contact/} for full documentation.
}
\keyword{internal}
