% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pinpointsmsvoicev2_operations.R
\name{pinpointsmsvoicev2_disassociate_origination_identity}
\alias{pinpointsmsvoicev2_disassociate_origination_identity}
\title{Removes the specified origination identity from an existing pool}
\usage{
pinpointsmsvoicev2_disassociate_origination_identity(
  PoolId,
  OriginationIdentity,
  IsoCountryCode,
  ClientToken = NULL
)
}
\arguments{
\item{PoolId}{[required] The unique identifier for the pool to disassociate with the origination
identity. This value can be either the PoolId or PoolArn.}

\item{OriginationIdentity}{[required] The origination identity to use such as a PhoneNumberId, PhoneNumberArn,
SenderId or SenderIdArn. You can use
\code{\link[=pinpointsmsvoicev2_describe_phone_numbers]{describe_phone_numbers}}
find the values for PhoneNumberId and PhoneNumberArn, or use
\code{\link[=pinpointsmsvoicev2_describe_sender_ids]{describe_sender_ids}} to get
the values for SenderId and SenderIdArn.}

\item{IsoCountryCode}{[required] The two-character code, in ISO 3166-1 alpha-2 format, for the country or
region.}

\item{ClientToken}{Unique, case-sensitive identifier you provide to ensure the idempotency
of the request. If you don't specify a client token, a randomly
generated token is used for the request to ensure idempotency.}
}
\description{
Removes the specified origination identity from an existing pool.

See \url{https://www.paws-r-sdk.com/docs/pinpointsmsvoicev2_disassociate_origination_identity/} for full documentation.
}
\keyword{internal}
