# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common new_handlers new_service set_config merge_config
NULL

#' Amazon Connect Participant Service
#'
#' @description
#' Amazon Connect is an easy-to-use omnichannel cloud contact center
#' service that enables companies of any size to deliver superior customer
#' service at a lower cost. Amazon Connect communications capabilities make
#' it easy for companies to deliver personalized interactions across
#' communication channels, including chat.
#' 
#' Use the Amazon Connect Participant Service to manage participants (for
#' example, agents, customers, and managers listening in), and to send
#' messages and events within a chat contact. The APIs in the service
#' enable the following: sending chat messages, attachment sharing,
#' managing a participant's connection state and message events, and
#' retrieving chat transcripts.
#'
#' @param
#' config
#' Optional configuration of credentials, endpoint, and/or region.
#' \itemize{
#' \item{\strong{credentials}: \itemize{
#' \item{\strong{creds}: \itemize{
#' \item{\strong{access_key_id}: AWS access key ID}
#' \item{\strong{secret_access_key}: AWS secret access key}
#' \item{\strong{session_token}: AWS temporary session token}
#' }}
#' \item{\strong{profile}: The name of a profile to use. If not given, then the default profile is used.}
#' \item{\strong{anonymous}: Set anonymous credentials.}
#' }}
#' \item{\strong{endpoint}: The complete URL to use for the constructed client.}
#' \item{\strong{region}: The AWS Region used in instantiating the client.}
#' \item{\strong{close_connection}: Immediately close all HTTP connections.}
#' \item{\strong{timeout}: The time in seconds till a timeout exception is thrown when attempting to make a connection. The default is 60 seconds.}
#' \item{\strong{s3_force_path_style}: Set this to `true` to force the request to use path-style addressing, i.e. `http://s3.amazonaws.com/BUCKET/KEY`.}
#' \item{\strong{sts_regional_endpoint}: Set sts regional endpoint resolver to regional or legacy \url{https://docs.aws.amazon.com/sdkref/latest/guide/feature-sts-regionalized-endpoints.html}}
#' }
#' @param
#' credentials
#' Optional credentials shorthand for the config parameter
#' \itemize{
#' \item{\strong{creds}: \itemize{
#' \item{\strong{access_key_id}: AWS access key ID}
#' \item{\strong{secret_access_key}: AWS secret access key}
#' \item{\strong{session_token}: AWS temporary session token}
#' }}
#' \item{\strong{profile}: The name of a profile to use. If not given, then the default profile is used.}
#' \item{\strong{anonymous}: Set anonymous credentials.}
#' }
#' @param
#' endpoint
#' Optional shorthand for complete URL to use for the constructed client.
#' @param
#' region
#' Optional shorthand for AWS Region used in instantiating the client.
#'
#' @section Service syntax:
#' ```
#' svc <- connectparticipant(
#'   config = list(
#'     credentials = list(
#'       creds = list(
#'         access_key_id = "string",
#'         secret_access_key = "string",
#'         session_token = "string"
#'       ),
#'       profile = "string",
#'       anonymous = "logical"
#'     ),
#'     endpoint = "string",
#'     region = "string",
#'     close_connection = "logical",
#'     timeout = "numeric",
#'     s3_force_path_style = "logical",
#'     sts_regional_endpoint = "string"
#'   ),
#'   credentials = list(
#'     creds = list(
#'       access_key_id = "string",
#'       secret_access_key = "string",
#'       session_token = "string"
#'     ),
#'     profile = "string",
#'     anonymous = "logical"
#'   ),
#'   endpoint = "string",
#'   region = "string"
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' svc <- connectparticipant()
#' svc$complete_attachment_upload(
#'   Foo = 123
#' )
#' }
#'
#' @section Operations:
#' \tabular{ll}{
#'  \link[=connectparticipant_complete_attachment_upload]{complete_attachment_upload} \tab Allows you to confirm that the attachment has been uploaded using the pre-signed URL provided in StartAttachmentUpload API\cr
#'  \link[=connectparticipant_create_participant_connection]{create_participant_connection} \tab Creates the participant's connection\cr
#'  \link[=connectparticipant_describe_view]{describe_view} \tab Retrieves the view for the specified view token\cr
#'  \link[=connectparticipant_disconnect_participant]{disconnect_participant} \tab Disconnects a participant\cr
#'  \link[=connectparticipant_get_attachment]{get_attachment} \tab Provides a pre-signed URL for download of a completed attachment\cr
#'  \link[=connectparticipant_get_transcript]{get_transcript} \tab Retrieves a transcript of the session, including details about any attachments\cr
#'  \link[=connectparticipant_send_event]{send_event} \tab Sends an event\cr
#'  \link[=connectparticipant_send_message]{send_message} \tab Sends a message\cr
#'  \link[=connectparticipant_start_attachment_upload]{start_attachment_upload} \tab Provides a pre-signed Amazon S3 URL in response for uploading the file directly to S3
#' }
#'
#' @return
#' A client for the service. You can call the service's operations using
#' syntax like `svc$operation(...)`, where `svc` is the name you've assigned
#' to the client. The available operations are listed in the
#' Operations section.
#'
#' @rdname connectparticipant
#' @export
connectparticipant <- function(config = list(), credentials = list(), endpoint = NULL, region = NULL) {
  config <- merge_config(
    config,
    list(
      credentials = credentials,
      endpoint = endpoint,
      region = region
    )
  )
  svc <- .connectparticipant$operations
  svc <- set_config(svc, config)
  return(svc)
}

# Private API objects: metadata, handlers, interfaces, etc.
.connectparticipant <- list()

.connectparticipant$operations <- list()

.connectparticipant$metadata <- list(
  service_name = "connectparticipant",
  endpoints = list("*" = list(endpoint = "participant.connect.{region}.amazonaws.com", global = FALSE), "cn-*" = list(endpoint = "participant.connect.{region}.amazonaws.com.cn", global = FALSE), "us-iso-*" = list(endpoint = "participant.connect.{region}.c2s.ic.gov", global = FALSE), "us-isob-*" = list(endpoint = "participant.connect.{region}.sc2s.sgov.gov", global = FALSE)),
  service_id = "ConnectParticipant",
  api_version = "2018-09-07",
  signing_name = "execute-api",
  json_version = "1.1",
  target_prefix = ""
)

.connectparticipant$service <- function(config = list()) {
  handlers <- new_handlers("restjson", "v4")
  new_service(.connectparticipant$metadata, handlers, config)
}
