% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sesv2_operations.R
\name{sesv2_put_configuration_set_delivery_options}
\alias{sesv2_put_configuration_set_delivery_options}
\title{Associate a configuration set with a dedicated IP pool}
\usage{
sesv2_put_configuration_set_delivery_options(
  ConfigurationSetName,
  TlsPolicy = NULL,
  SendingPoolName = NULL
)
}
\arguments{
\item{ConfigurationSetName}{[required] The name of the configuration set to associate with a dedicated IP pool.}

\item{TlsPolicy}{Specifies whether messages that use the configuration set are required
to use Transport Layer Security (TLS). If the value is \code{Require},
messages are only delivered if a TLS connection can be established. If
the value is \code{Optional}, messages can be delivered in plain text if a
TLS connection can't be established.}

\item{SendingPoolName}{The name of the dedicated IP pool to associate with the configuration
set.}
}
\description{
Associate a configuration set with a dedicated IP pool. You can use dedicated IP pools to create groups of dedicated IP addresses for sending specific types of email.

See \url{https://paws-r.github.io/docs/sesv2/put_configuration_set_delivery_options.html} for full documentation.
}
\keyword{internal}
