% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ses_operations.R
\name{ses_set_identity_notification_topic}
\alias{ses_set_identity_notification_topic}
\title{Sets an Amazon Simple Notification Service (Amazon SNS) topic to use
when delivering notifications}
\usage{
ses_set_identity_notification_topic(
  Identity,
  NotificationType,
  SnsTopic = NULL
)
}
\arguments{
\item{Identity}{[required] The identity (email address or domain) that you want to set the Amazon
SNS topic for.

You can only specify a verified identity for this parameter.

You can specify an identity by using its name or by using its Amazon
Resource Name (ARN). The following examples are all valid identities:
\code{sender@example.com}, \code{example.com},
\code{arn:aws:ses:us-east-1:123456789012:identity/example.com}.}

\item{NotificationType}{[required] The type of notifications that will be published to the specified Amazon
SNS topic.}

\item{SnsTopic}{The Amazon Resource Name (ARN) of the Amazon SNS topic. If the parameter
is omitted from the request or a null value is passed, \code{SnsTopic} is
cleared and publishing is disabled.}
}
\description{
Sets an Amazon Simple Notification Service (Amazon SNS) topic to use when delivering notifications. When you use this operation, you specify a verified identity, such as an email address or domain. When you send an email that uses the chosen identity in the Source field, Amazon SES sends notifications to the topic you specified. You can send bounce, complaint, or delivery notifications (or any combination of the three) to the Amazon SNS topic that you specify.

See \url{https://paws-r.github.io/docs/ses/set_identity_notification_topic.html} for full documentation.
}
\keyword{internal}
