% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/connect_operations.R
\name{connect_get_current_user_data}
\alias{connect_get_current_user_data}
\title{Gets the real-time active user data from the specified Amazon Connect
instance}
\usage{
connect_get_current_user_data(
  InstanceId,
  Filters,
  NextToken = NULL,
  MaxResults = NULL
)
}
\arguments{
\item{InstanceId}{[required] The identifier of the Amazon Connect instance. You can find the
instanceId in the ARN of the instance.}

\item{Filters}{[required] Filters up to 100 \code{Queues}, or up to 9 \code{ContactStates}. The user data is
retrieved only for those users who are associated with the queues and
have contacts that are in the specified \code{ContactState}.}

\item{NextToken}{The token for the next set of results. Use the value returned in the
previous response in the next request to retrieve the next set of
results.}

\item{MaxResults}{The maximum number of results to return per page.}
}
\description{
Gets the real-time active user data from the specified Amazon Connect instance.

See \url{https://paws-r.github.io/docs/connect/get_current_user_data.html} for full documentation.
}
\keyword{internal}
