% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pinpointemail_operations.R
\name{pinpointemail_put_email_identity_dkim_attributes}
\alias{pinpointemail_put_email_identity_dkim_attributes}
\title{Used to enable or disable DKIM authentication for an email identity}
\usage{
pinpointemail_put_email_identity_dkim_attributes(EmailIdentity,
  SigningEnabled)
}
\arguments{
\item{EmailIdentity}{[required] The email identity that you want to change the DKIM settings for.}

\item{SigningEnabled}{Sets the DKIM signing configuration for the identity.

When you set this value \code{true}, then the messages that Amazon Pinpoint
sends from the identity are DKIM-signed. When you set this value to
\code{false}, then the messages that Amazon Pinpoint sends from the identity
aren\'t DKIM-signed.}
}
\description{
Used to enable or disable DKIM authentication for an email identity.
}
\section{Request syntax}{
\preformatted{svc$put_email_identity_dkim_attributes(
  EmailIdentity = "string",
  SigningEnabled = TRUE|FALSE
)
}
}

\keyword{internal}
