# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common get_config new_operation new_request send_request
#' @include costexplorer_service.R
NULL

#' Creates a new cost anomaly detection monitor with the requested type and
#' monitor specification
#'
#' @description
#' Creates a new cost anomaly detection monitor with the requested type and monitor specification.
#'
#' See [https://www.paws-r-sdk.com/docs/costexplorer_create_anomaly_monitor/](https://www.paws-r-sdk.com/docs/costexplorer_create_anomaly_monitor/) for full documentation.
#'
#' @param AnomalyMonitor &#91;required&#93; The cost anomaly detection monitor object that you want to create.
#' @param ResourceTags An optional list of tags to associate with the specified
#' [`AnomalyMonitor`](https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_AnomalyMonitor.html)
#' . You can use resource tags to control access to your `monitor` using
#' IAM policies.
#' 
#' Each tag consists of a key and a value, and each key must be unique for
#' the resource. The following restrictions apply to resource tags:
#' 
#' -   Although the maximum number of array members is 200, you can assign
#'     a maximum of 50 user-tags to one resource. The remaining are
#'     reserved for Amazon Web Services use
#' 
#' -   The maximum length of a key is 128 characters
#' 
#' -   The maximum length of a value is 256 characters
#' 
#' -   Keys and values can only contain alphanumeric characters, spaces,
#'     and any of the following: `_.:/=+@@-`
#' 
#' -   Keys and values are case sensitive
#' 
#' -   Keys and values are trimmed for any leading or trailing whitespaces
#' 
#' -   Don’t use `aws:` as a prefix for your keys. This prefix is reserved
#'     for Amazon Web Services use
#'
#' @keywords internal
#'
#' @rdname costexplorer_create_anomaly_monitor
costexplorer_create_anomaly_monitor <- function(AnomalyMonitor, ResourceTags = NULL) {
  op <- new_operation(
    name = "CreateAnomalyMonitor",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .costexplorer$create_anomaly_monitor_input(AnomalyMonitor = AnomalyMonitor, ResourceTags = ResourceTags)
  output <- .costexplorer$create_anomaly_monitor_output()
  config <- get_config()
  svc <- .costexplorer$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.costexplorer$operations$create_anomaly_monitor <- costexplorer_create_anomaly_monitor

#' Adds an alert subscription to a cost anomaly detection monitor
#'
#' @description
#' Adds an alert subscription to a cost anomaly detection monitor. You can use each subscription to define subscribers with email or SNS notifications. Email subscribers can set an absolute or percentage threshold and a time frequency for receiving notifications.
#'
#' See [https://www.paws-r-sdk.com/docs/costexplorer_create_anomaly_subscription/](https://www.paws-r-sdk.com/docs/costexplorer_create_anomaly_subscription/) for full documentation.
#'
#' @param AnomalySubscription &#91;required&#93; The cost anomaly subscription object that you want to create.
#' @param ResourceTags An optional list of tags to associate with the specified
#' [`AnomalySubscription`](https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_AnomalySubscription.html)
#' . You can use resource tags to control access to your `subscription`
#' using IAM policies.
#' 
#' Each tag consists of a key and a value, and each key must be unique for
#' the resource. The following restrictions apply to resource tags:
#' 
#' -   Although the maximum number of array members is 200, you can assign
#'     a maximum of 50 user-tags to one resource. The remaining are
#'     reserved for Amazon Web Services use
#' 
#' -   The maximum length of a key is 128 characters
#' 
#' -   The maximum length of a value is 256 characters
#' 
#' -   Keys and values can only contain alphanumeric characters, spaces,
#'     and any of the following: `_.:/=+@@-`
#' 
#' -   Keys and values are case sensitive
#' 
#' -   Keys and values are trimmed for any leading or trailing whitespaces
#' 
#' -   Don’t use `aws:` as a prefix for your keys. This prefix is reserved
#'     for Amazon Web Services use
#'
#' @keywords internal
#'
#' @rdname costexplorer_create_anomaly_subscription
costexplorer_create_anomaly_subscription <- function(AnomalySubscription, ResourceTags = NULL) {
  op <- new_operation(
    name = "CreateAnomalySubscription",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .costexplorer$create_anomaly_subscription_input(AnomalySubscription = AnomalySubscription, ResourceTags = ResourceTags)
  output <- .costexplorer$create_anomaly_subscription_output()
  config <- get_config()
  svc <- .costexplorer$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.costexplorer$operations$create_anomaly_subscription <- costexplorer_create_anomaly_subscription

#' Creates a new Cost Category with the requested name and rules
#'
#' @description
#' Creates a new Cost Category with the requested name and rules.
#'
#' See [https://www.paws-r-sdk.com/docs/costexplorer_create_cost_category_definition/](https://www.paws-r-sdk.com/docs/costexplorer_create_cost_category_definition/) for full documentation.
#'
#' @param Name &#91;required&#93; 
#' @param EffectiveStart The Cost Category's effective start date. It can only be a billing start
#' date (first day of the month). If the date isn't provided, it's the
#' first day of the current month. Dates can't be before the previous
#' twelve months, or in the future.
#' @param RuleVersion &#91;required&#93; 
#' @param Rules &#91;required&#93; The Cost Category rules used to categorize costs. For more information,
#' see
#' [CostCategoryRule](https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_CostCategoryRule.html).
#' @param DefaultValue 
#' @param SplitChargeRules The split charge rules used to allocate your charges between your Cost
#' Category values.
#' @param ResourceTags An optional list of tags to associate with the specified
#' [`CostCategory`](https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_CostCategory.html)
#' . You can use resource tags to control access to your `cost category`
#' using IAM policies.
#' 
#' Each tag consists of a key and a value, and each key must be unique for
#' the resource. The following restrictions apply to resource tags:
#' 
#' -   Although the maximum number of array members is 200, you can assign
#'     a maximum of 50 user-tags to one resource. The remaining are
#'     reserved for Amazon Web Services use
#' 
#' -   The maximum length of a key is 128 characters
#' 
#' -   The maximum length of a value is 256 characters
#' 
#' -   Keys and values can only contain alphanumeric characters, spaces,
#'     and any of the following: `_.:/=+@@-`
#' 
#' -   Keys and values are case sensitive
#' 
#' -   Keys and values are trimmed for any leading or trailing whitespaces
#' 
#' -   Don’t use `aws:` as a prefix for your keys. This prefix is reserved
#'     for Amazon Web Services use
#'
#' @keywords internal
#'
#' @rdname costexplorer_create_cost_category_definition
costexplorer_create_cost_category_definition <- function(Name, EffectiveStart = NULL, RuleVersion, Rules, DefaultValue = NULL, SplitChargeRules = NULL, ResourceTags = NULL) {
  op <- new_operation(
    name = "CreateCostCategoryDefinition",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .costexplorer$create_cost_category_definition_input(Name = Name, EffectiveStart = EffectiveStart, RuleVersion = RuleVersion, Rules = Rules, DefaultValue = DefaultValue, SplitChargeRules = SplitChargeRules, ResourceTags = ResourceTags)
  output <- .costexplorer$create_cost_category_definition_output()
  config <- get_config()
  svc <- .costexplorer$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.costexplorer$operations$create_cost_category_definition <- costexplorer_create_cost_category_definition

#' Deletes a cost anomaly monitor
#'
#' @description
#' Deletes a cost anomaly monitor.
#'
#' See [https://www.paws-r-sdk.com/docs/costexplorer_delete_anomaly_monitor/](https://www.paws-r-sdk.com/docs/costexplorer_delete_anomaly_monitor/) for full documentation.
#'
#' @param MonitorArn &#91;required&#93; The unique identifier of the cost anomaly monitor that you want to
#' delete.
#'
#' @keywords internal
#'
#' @rdname costexplorer_delete_anomaly_monitor
costexplorer_delete_anomaly_monitor <- function(MonitorArn) {
  op <- new_operation(
    name = "DeleteAnomalyMonitor",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .costexplorer$delete_anomaly_monitor_input(MonitorArn = MonitorArn)
  output <- .costexplorer$delete_anomaly_monitor_output()
  config <- get_config()
  svc <- .costexplorer$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.costexplorer$operations$delete_anomaly_monitor <- costexplorer_delete_anomaly_monitor

#' Deletes a cost anomaly subscription
#'
#' @description
#' Deletes a cost anomaly subscription.
#'
#' See [https://www.paws-r-sdk.com/docs/costexplorer_delete_anomaly_subscription/](https://www.paws-r-sdk.com/docs/costexplorer_delete_anomaly_subscription/) for full documentation.
#'
#' @param SubscriptionArn &#91;required&#93; The unique identifier of the cost anomaly subscription that you want to
#' delete.
#'
#' @keywords internal
#'
#' @rdname costexplorer_delete_anomaly_subscription
costexplorer_delete_anomaly_subscription <- function(SubscriptionArn) {
  op <- new_operation(
    name = "DeleteAnomalySubscription",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .costexplorer$delete_anomaly_subscription_input(SubscriptionArn = SubscriptionArn)
  output <- .costexplorer$delete_anomaly_subscription_output()
  config <- get_config()
  svc <- .costexplorer$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.costexplorer$operations$delete_anomaly_subscription <- costexplorer_delete_anomaly_subscription

#' Deletes a Cost Category
#'
#' @description
#' Deletes a Cost Category. Expenses from this month going forward will no longer be categorized with this Cost Category.
#'
#' See [https://www.paws-r-sdk.com/docs/costexplorer_delete_cost_category_definition/](https://www.paws-r-sdk.com/docs/costexplorer_delete_cost_category_definition/) for full documentation.
#'
#' @param CostCategoryArn &#91;required&#93; The unique identifier for your Cost Category.
#'
#' @keywords internal
#'
#' @rdname costexplorer_delete_cost_category_definition
costexplorer_delete_cost_category_definition <- function(CostCategoryArn) {
  op <- new_operation(
    name = "DeleteCostCategoryDefinition",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .costexplorer$delete_cost_category_definition_input(CostCategoryArn = CostCategoryArn)
  output <- .costexplorer$delete_cost_category_definition_output()
  config <- get_config()
  svc <- .costexplorer$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.costexplorer$operations$delete_cost_category_definition <- costexplorer_delete_cost_category_definition

#' Returns the name, Amazon Resource Name (ARN), rules, definition, and
#' effective dates of a Cost Category that's defined in the account
#'
#' @description
#' Returns the name, Amazon Resource Name (ARN), rules, definition, and effective dates of a Cost Category that's defined in the account.
#'
#' See [https://www.paws-r-sdk.com/docs/costexplorer_describe_cost_category_definition/](https://www.paws-r-sdk.com/docs/costexplorer_describe_cost_category_definition/) for full documentation.
#'
#' @param CostCategoryArn &#91;required&#93; The unique identifier for your Cost Category.
#' @param EffectiveOn The date when the Cost Category was effective.
#'
#' @keywords internal
#'
#' @rdname costexplorer_describe_cost_category_definition
costexplorer_describe_cost_category_definition <- function(CostCategoryArn, EffectiveOn = NULL) {
  op <- new_operation(
    name = "DescribeCostCategoryDefinition",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .costexplorer$describe_cost_category_definition_input(CostCategoryArn = CostCategoryArn, EffectiveOn = EffectiveOn)
  output <- .costexplorer$describe_cost_category_definition_output()
  config <- get_config()
  svc <- .costexplorer$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.costexplorer$operations$describe_cost_category_definition <- costexplorer_describe_cost_category_definition

#' Retrieves all of the cost anomalies detected on your account during the
#' time period that's specified by the DateInterval object
#'
#' @description
#' Retrieves all of the cost anomalies detected on your account during the time period that's specified by the `DateInterval` object. Anomalies are available for up to 90 days.
#'
#' See [https://www.paws-r-sdk.com/docs/costexplorer_get_anomalies/](https://www.paws-r-sdk.com/docs/costexplorer_get_anomalies/) for full documentation.
#'
#' @param MonitorArn Retrieves all of the cost anomalies detected for a specific cost anomaly
#' monitor Amazon Resource Name (ARN).
#' @param DateInterval &#91;required&#93; Assigns the start and end dates for retrieving cost anomalies. The
#' returned anomaly object will have an `AnomalyEndDate` in the specified
#' time range.
#' @param Feedback Filters anomaly results by the feedback field on the anomaly object.
#' @param TotalImpact Filters anomaly results by the total impact field on the anomaly object.
#' For example, you can filter anomalies `GREATER_THAN 200.00` to retrieve
#' anomalies, with an estimated dollar impact greater than 200.
#' @param NextPageToken The token to retrieve the next set of results. Amazon Web Services
#' provides the token when the response from a previous call has more
#' results than the maximum page size.
#' @param MaxResults The number of entries a paginated response contains.
#'
#' @keywords internal
#'
#' @rdname costexplorer_get_anomalies
costexplorer_get_anomalies <- function(MonitorArn = NULL, DateInterval, Feedback = NULL, TotalImpact = NULL, NextPageToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "GetAnomalies",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .costexplorer$get_anomalies_input(MonitorArn = MonitorArn, DateInterval = DateInterval, Feedback = Feedback, TotalImpact = TotalImpact, NextPageToken = NextPageToken, MaxResults = MaxResults)
  output <- .costexplorer$get_anomalies_output()
  config <- get_config()
  svc <- .costexplorer$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.costexplorer$operations$get_anomalies <- costexplorer_get_anomalies

#' Retrieves the cost anomaly monitor definitions for your account
#'
#' @description
#' Retrieves the cost anomaly monitor definitions for your account. You can filter using a list of cost anomaly monitor Amazon Resource Names (ARNs).
#'
#' See [https://www.paws-r-sdk.com/docs/costexplorer_get_anomaly_monitors/](https://www.paws-r-sdk.com/docs/costexplorer_get_anomaly_monitors/) for full documentation.
#'
#' @param MonitorArnList A list of cost anomaly monitor ARNs.
#' @param NextPageToken The token to retrieve the next set of results. Amazon Web Services
#' provides the token when the response from a previous call has more
#' results than the maximum page size.
#' @param MaxResults The number of entries that a paginated response contains.
#'
#' @keywords internal
#'
#' @rdname costexplorer_get_anomaly_monitors
costexplorer_get_anomaly_monitors <- function(MonitorArnList = NULL, NextPageToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "GetAnomalyMonitors",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .costexplorer$get_anomaly_monitors_input(MonitorArnList = MonitorArnList, NextPageToken = NextPageToken, MaxResults = MaxResults)
  output <- .costexplorer$get_anomaly_monitors_output()
  config <- get_config()
  svc <- .costexplorer$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.costexplorer$operations$get_anomaly_monitors <- costexplorer_get_anomaly_monitors

#' Retrieves the cost anomaly subscription objects for your account
#'
#' @description
#' Retrieves the cost anomaly subscription objects for your account. You can filter using a list of cost anomaly monitor Amazon Resource Names (ARNs).
#'
#' See [https://www.paws-r-sdk.com/docs/costexplorer_get_anomaly_subscriptions/](https://www.paws-r-sdk.com/docs/costexplorer_get_anomaly_subscriptions/) for full documentation.
#'
#' @param SubscriptionArnList A list of cost anomaly subscription ARNs.
#' @param MonitorArn Cost anomaly monitor ARNs.
#' @param NextPageToken The token to retrieve the next set of results. Amazon Web Services
#' provides the token when the response from a previous call has more
#' results than the maximum page size.
#' @param MaxResults The number of entries a paginated response contains.
#'
#' @keywords internal
#'
#' @rdname costexplorer_get_anomaly_subscriptions
costexplorer_get_anomaly_subscriptions <- function(SubscriptionArnList = NULL, MonitorArn = NULL, NextPageToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "GetAnomalySubscriptions",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .costexplorer$get_anomaly_subscriptions_input(SubscriptionArnList = SubscriptionArnList, MonitorArn = MonitorArn, NextPageToken = NextPageToken, MaxResults = MaxResults)
  output <- .costexplorer$get_anomaly_subscriptions_output()
  config <- get_config()
  svc <- .costexplorer$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.costexplorer$operations$get_anomaly_subscriptions <- costexplorer_get_anomaly_subscriptions

#' Retrieves cost and usage metrics for your account
#'
#' @description
#' Retrieves cost and usage metrics for your account. You can specify which cost and usage-related metric that you want the request to return. For example, you can specify `BlendedCosts` or `UsageQuantity`. You can also filter and group your data by various dimensions, such as `SERVICE` or `AZ`, in a specific time range. For a complete list of valid dimensions, see the [`get_dimension_values`][costexplorer_get_dimension_values] operation. Management account in an organization in Organizations have access to all member accounts.
#'
#' See [https://www.paws-r-sdk.com/docs/costexplorer_get_cost_and_usage/](https://www.paws-r-sdk.com/docs/costexplorer_get_cost_and_usage/) for full documentation.
#'
#' @param TimePeriod &#91;required&#93; Sets the start date and end date for retrieving Amazon Web Services
#' costs. The start date is inclusive, but the end date is exclusive. For
#' example, if `start` is `2017-01-01` and `end` is `2017-05-01`, then the
#' cost and usage data is retrieved from `2017-01-01` up to and including
#' `2017-04-30` but not including `2017-05-01`.
#' @param Granularity &#91;required&#93; Sets the Amazon Web Services cost granularity to `MONTHLY` or `DAILY`,
#' or `HOURLY`. If `Granularity` isn't set, the response object doesn't
#' include the `Granularity`, either `MONTHLY` or `DAILY`, or `HOURLY`.
#' @param Filter Filters Amazon Web Services costs by different dimensions. For example,
#' you can specify `SERVICE` and `LINKED_ACCOUNT` and get the costs that
#' are associated with that account's usage of that service. You can nest
#' `Expression` objects to define any combination of dimension filters. For
#' more information, see
#' [Expression](https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_Expression.html).
#' 
#' Valid values for `MatchOptions` for `Dimensions` are `EQUALS` and
#' `CASE_SENSITIVE`.
#' 
#' Valid values for `MatchOptions` for `CostCategories` and `Tags` are
#' `EQUALS`, `ABSENT`, and `CASE_SENSITIVE`. Default values are `EQUALS`
#' and `CASE_SENSITIVE`.
#' @param Metrics &#91;required&#93; Which metrics are returned in the query. For more information about
#' blended and unblended rates, see Why does the "blended" annotation
#' appear on some line items in my bill?.
#' 
#' Valid values are `AmortizedCost`, `BlendedCost`, `NetAmortizedCost`,
#' `NetUnblendedCost`, `NormalizedUsageAmount`, `UnblendedCost`, and
#' `UsageQuantity`.
#' 
#' If you return the `UsageQuantity` metric, the service aggregates all
#' usage numbers without taking into account the units. For example, if you
#' aggregate `usageQuantity` across all of Amazon EC2, the results aren't
#' meaningful because Amazon EC2 compute hours and data transfer are
#' measured in different units (for example, hours and GB). To get more
#' meaningful `UsageQuantity` metrics, filter by `UsageType` or
#' `UsageTypeGroups`.
#' 
#' `Metrics` is required for
#' [`get_cost_and_usage`][costexplorer_get_cost_and_usage] requests.
#' @param GroupBy You can group Amazon Web Services costs using up to two different
#' groups, either dimensions, tag keys, cost categories, or any two group
#' by types.
#' 
#' Valid values for the `DIMENSION` type are `AZ`, `INSTANCE_TYPE`,
#' `LEGAL_ENTITY_NAME`, `INVOICING_ENTITY`, `LINKED_ACCOUNT`, `OPERATION`,
#' `PLATFORM`, `PURCHASE_TYPE`, `SERVICE`, `TENANCY`, `RECORD_TYPE`, and
#' `USAGE_TYPE`.
#' 
#' When you group by the `TAG` type and include a valid tag key, you get
#' all tag values, including empty strings.
#' @param NextPageToken The token to retrieve the next set of results. Amazon Web Services
#' provides the token when the response from a previous call has more
#' results than the maximum page size.
#'
#' @keywords internal
#'
#' @rdname costexplorer_get_cost_and_usage
costexplorer_get_cost_and_usage <- function(TimePeriod, Granularity, Filter = NULL, Metrics, GroupBy = NULL, NextPageToken = NULL) {
  op <- new_operation(
    name = "GetCostAndUsage",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .costexplorer$get_cost_and_usage_input(TimePeriod = TimePeriod, Granularity = Granularity, Filter = Filter, Metrics = Metrics, GroupBy = GroupBy, NextPageToken = NextPageToken)
  output <- .costexplorer$get_cost_and_usage_output()
  config <- get_config()
  svc <- .costexplorer$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.costexplorer$operations$get_cost_and_usage <- costexplorer_get_cost_and_usage

#' Retrieves cost and usage metrics with resources for your account
#'
#' @description
#' Retrieves cost and usage metrics with resources for your account. You can specify which cost and usage-related metric, such as `BlendedCosts` or `UsageQuantity`, that you want the request to return. You can also filter and group your data by various dimensions, such as `SERVICE` or `AZ`, in a specific time range. For a complete list of valid dimensions, see the [`get_dimension_values`][costexplorer_get_dimension_values] operation. Management account in an organization in Organizations have access to all member accounts. This API is currently available for the Amazon Elastic Compute Cloud – Compute service only.
#'
#' See [https://www.paws-r-sdk.com/docs/costexplorer_get_cost_and_usage_with_resources/](https://www.paws-r-sdk.com/docs/costexplorer_get_cost_and_usage_with_resources/) for full documentation.
#'
#' @param TimePeriod &#91;required&#93; Sets the start and end dates for retrieving Amazon Web Services costs.
#' The range must be within the last 14 days (the start date cannot be
#' earlier than 14 days ago). The start date is inclusive, but the end date
#' is exclusive. For example, if `start` is `2017-01-01` and `end` is
#' `2017-05-01`, then the cost and usage data is retrieved from
#' `2017-01-01` up to and including `2017-04-30` but not including
#' `2017-05-01`.
#' @param Granularity &#91;required&#93; Sets the Amazon Web Services cost granularity to `MONTHLY`, `DAILY`, or
#' `HOURLY`. If `Granularity` isn't set, the response object doesn't
#' include the `Granularity`, `MONTHLY`, `DAILY`, or `HOURLY`.
#' @param Filter &#91;required&#93; Filters Amazon Web Services costs by different dimensions. For example,
#' you can specify `SERVICE` and `LINKED_ACCOUNT` and get the costs that
#' are associated with that account's usage of that service. You can nest
#' `Expression` objects to define any combination of dimension filters. For
#' more information, see
#' [Expression](https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_Expression.html).
#' 
#' The
#' [`get_cost_and_usage_with_resources`][costexplorer_get_cost_and_usage_with_resources]
#' operation requires that you either group by or filter by a `ResourceId`.
#' It requires the
#' [Expression](https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_Expression.html)
#' `"SERVICE = Amazon Elastic Compute Cloud - Compute"` in the filter.
#' 
#' Valid values for `MatchOptions` for `Dimensions` are `EQUALS` and
#' `CASE_SENSITIVE`.
#' 
#' Valid values for `MatchOptions` for `CostCategories` and `Tags` are
#' `EQUALS`, `ABSENT`, and `CASE_SENSITIVE`. Default values are `EQUALS`
#' and `CASE_SENSITIVE`.
#' @param Metrics Which metrics are returned in the query. For more information about
#' blended and unblended rates, see Why does the "blended" annotation
#' appear on some line items in my bill?.
#' 
#' Valid values are `AmortizedCost`, `BlendedCost`, `NetAmortizedCost`,
#' `NetUnblendedCost`, `NormalizedUsageAmount`, `UnblendedCost`, and
#' `UsageQuantity`.
#' 
#' If you return the `UsageQuantity` metric, the service aggregates all
#' usage numbers without taking the units into account. For example, if you
#' aggregate `usageQuantity` across all of Amazon EC2, the results aren't
#' meaningful because Amazon EC2 compute hours and data transfer are
#' measured in different units (for example, hour or GB). To get more
#' meaningful `UsageQuantity` metrics, filter by `UsageType` or
#' `UsageTypeGroups`.
#' 
#' `Metrics` is required for
#' [`get_cost_and_usage_with_resources`][costexplorer_get_cost_and_usage_with_resources]
#' requests.
#' @param GroupBy You can group Amazon Web Services costs using up to two different
#' groups: `DIMENSION`, `TAG`, `COST_CATEGORY`.
#' @param NextPageToken The token to retrieve the next set of results. Amazon Web Services
#' provides the token when the response from a previous call has more
#' results than the maximum page size.
#'
#' @keywords internal
#'
#' @rdname costexplorer_get_cost_and_usage_with_resources
costexplorer_get_cost_and_usage_with_resources <- function(TimePeriod, Granularity, Filter, Metrics = NULL, GroupBy = NULL, NextPageToken = NULL) {
  op <- new_operation(
    name = "GetCostAndUsageWithResources",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .costexplorer$get_cost_and_usage_with_resources_input(TimePeriod = TimePeriod, Granularity = Granularity, Filter = Filter, Metrics = Metrics, GroupBy = GroupBy, NextPageToken = NextPageToken)
  output <- .costexplorer$get_cost_and_usage_with_resources_output()
  config <- get_config()
  svc <- .costexplorer$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.costexplorer$operations$get_cost_and_usage_with_resources <- costexplorer_get_cost_and_usage_with_resources

#' Retrieves an array of Cost Category names and values incurred cost
#'
#' @description
#' Retrieves an array of Cost Category names and values incurred cost.
#'
#' See [https://www.paws-r-sdk.com/docs/costexplorer_get_cost_categories/](https://www.paws-r-sdk.com/docs/costexplorer_get_cost_categories/) for full documentation.
#'
#' @param SearchString The value that you want to search the filter values for.
#' 
#' If you don't specify a `CostCategoryName`, `SearchString` is used to
#' filter Cost Category names that match the `SearchString` pattern. If you
#' specify a `CostCategoryName`, `SearchString` is used to filter Cost
#' Category values that match the `SearchString` pattern.
#' @param TimePeriod &#91;required&#93; 
#' @param CostCategoryName 
#' @param Filter 
#' @param SortBy The value that you sort the data by.
#' 
#' The key represents the cost and usage metrics. The following values are
#' supported:
#' 
#' -   `BlendedCost`
#' 
#' -   `UnblendedCost`
#' 
#' -   `AmortizedCost`
#' 
#' -   `NetAmortizedCost`
#' 
#' -   `NetUnblendedCost`
#' 
#' -   `UsageQuantity`
#' 
#' -   `NormalizedUsageAmount`
#' 
#' The supported key values for the `SortOrder` value are `ASCENDING` and
#' `DESCENDING`.
#' 
#' When you use the `SortBy` value, the `NextPageToken` and `SearchString`
#' key values aren't supported.
#' @param MaxResults This field is only used when the `SortBy` value is provided in the
#' request.
#' 
#' The maximum number of objects that are returned for this request. If
#' `MaxResults` isn't specified with the `SortBy` value, the request
#' returns 1000 results as the default value for this parameter.
#' 
#' For [`get_cost_categories`][costexplorer_get_cost_categories],
#' MaxResults has an upper quota of 1000.
#' @param NextPageToken If the number of objects that are still available for retrieval exceeds
#' the quota, Amazon Web Services returns a NextPageToken value in the
#' response. To retrieve the next batch of objects, provide the
#' NextPageToken from the previous call in your next request.
#'
#' @keywords internal
#'
#' @rdname costexplorer_get_cost_categories
costexplorer_get_cost_categories <- function(SearchString = NULL, TimePeriod, CostCategoryName = NULL, Filter = NULL, SortBy = NULL, MaxResults = NULL, NextPageToken = NULL) {
  op <- new_operation(
    name = "GetCostCategories",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .costexplorer$get_cost_categories_input(SearchString = SearchString, TimePeriod = TimePeriod, CostCategoryName = CostCategoryName, Filter = Filter, SortBy = SortBy, MaxResults = MaxResults, NextPageToken = NextPageToken)
  output <- .costexplorer$get_cost_categories_output()
  config <- get_config()
  svc <- .costexplorer$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.costexplorer$operations$get_cost_categories <- costexplorer_get_cost_categories

#' Retrieves a forecast for how much Amazon Web Services predicts that you
#' will spend over the forecast time period that you select, based on your
#' past costs
#'
#' @description
#' Retrieves a forecast for how much Amazon Web Services predicts that you will spend over the forecast time period that you select, based on your past costs.
#'
#' See [https://www.paws-r-sdk.com/docs/costexplorer_get_cost_forecast/](https://www.paws-r-sdk.com/docs/costexplorer_get_cost_forecast/) for full documentation.
#'
#' @param TimePeriod &#91;required&#93; The period of time that you want the forecast to cover. The start date
#' must be equal to or no later than the current date to avoid a validation
#' error.
#' @param Metric &#91;required&#93; Which metric Cost Explorer uses to create your forecast. For more
#' information about blended and unblended rates, see Why does the
#' "blended" annotation appear on some line items in my bill?.
#' 
#' Valid values for a [`get_cost_forecast`][costexplorer_get_cost_forecast]
#' call are the following:
#' 
#' -   AMORTIZED_COST
#' 
#' -   BLENDED_COST
#' 
#' -   NET_AMORTIZED_COST
#' 
#' -   NET_UNBLENDED_COST
#' 
#' -   UNBLENDED_COST
#' @param Granularity &#91;required&#93; How granular you want the forecast to be. You can get 3 months of
#' `DAILY` forecasts or 12 months of `MONTHLY` forecasts.
#' 
#' The [`get_cost_forecast`][costexplorer_get_cost_forecast] operation
#' supports only `DAILY` and `MONTHLY` granularities.
#' @param Filter The filters that you want to use to filter your forecast. The
#' [`get_cost_forecast`][costexplorer_get_cost_forecast] API supports
#' filtering by the following dimensions:
#' 
#' -   `AZ`
#' 
#' -   `INSTANCE_TYPE`
#' 
#' -   `LINKED_ACCOUNT`
#' 
#' -   `LINKED_ACCOUNT_NAME`
#' 
#' -   `OPERATION`
#' 
#' -   `PURCHASE_TYPE`
#' 
#' -   `REGION`
#' 
#' -   `SERVICE`
#' 
#' -   `USAGE_TYPE`
#' 
#' -   `USAGE_TYPE_GROUP`
#' 
#' -   `RECORD_TYPE`
#' 
#' -   `OPERATING_SYSTEM`
#' 
#' -   `TENANCY`
#' 
#' -   `SCOPE`
#' 
#' -   `PLATFORM`
#' 
#' -   `SUBSCRIPTION_ID`
#' 
#' -   `LEGAL_ENTITY_NAME`
#' 
#' -   `DEPLOYMENT_OPTION`
#' 
#' -   `DATABASE_ENGINE`
#' 
#' -   `INSTANCE_TYPE_FAMILY`
#' 
#' -   `BILLING_ENTITY`
#' 
#' -   `RESERVATION_ID`
#' 
#' -   `SAVINGS_PLAN_ARN`
#' @param PredictionIntervalLevel Cost Explorer always returns the mean forecast as a single point. You
#' can request a prediction interval around the mean by specifying a
#' confidence level. The higher the confidence level, the more confident
#' Cost Explorer is about the actual value falling in the prediction
#' interval. Higher confidence levels result in wider prediction intervals.
#'
#' @keywords internal
#'
#' @rdname costexplorer_get_cost_forecast
costexplorer_get_cost_forecast <- function(TimePeriod, Metric, Granularity, Filter = NULL, PredictionIntervalLevel = NULL) {
  op <- new_operation(
    name = "GetCostForecast",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .costexplorer$get_cost_forecast_input(TimePeriod = TimePeriod, Metric = Metric, Granularity = Granularity, Filter = Filter, PredictionIntervalLevel = PredictionIntervalLevel)
  output <- .costexplorer$get_cost_forecast_output()
  config <- get_config()
  svc <- .costexplorer$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.costexplorer$operations$get_cost_forecast <- costexplorer_get_cost_forecast

#' Retrieves all available filter values for a specified filter over a
#' period of time
#'
#' @description
#' Retrieves all available filter values for a specified filter over a period of time. You can search the dimension values for an arbitrary string.
#'
#' See [https://www.paws-r-sdk.com/docs/costexplorer_get_dimension_values/](https://www.paws-r-sdk.com/docs/costexplorer_get_dimension_values/) for full documentation.
#'
#' @param SearchString The value that you want to search the filter values for.
#' @param TimePeriod &#91;required&#93; The start date and end date for retrieving the dimension values. The
#' start date is inclusive, but the end date is exclusive. For example, if
#' `start` is `2017-01-01` and `end` is `2017-05-01`, then the cost and
#' usage data is retrieved from `2017-01-01` up to and including
#' `2017-04-30` but not including `2017-05-01`.
#' @param Dimension &#91;required&#93; The name of the dimension. Each `Dimension` is available for a different
#' `Context`. For more information, see `Context`. `LINK_ACCOUNT_NAME` and
#' `SERVICE_CODE` can only be used in
#' [CostCategoryRule](https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/).
#' @param Context The context for the call to
#' [`get_dimension_values`][costexplorer_get_dimension_values]. This can be
#' `RESERVATIONS` or `COST_AND_USAGE`. The default value is
#' `COST_AND_USAGE`. If the context is set to `RESERVATIONS`, the resulting
#' dimension values can be used in the
#' [`get_reservation_utilization`][costexplorer_get_reservation_utilization]
#' operation. If the context is set to `COST_AND_USAGE`, the resulting
#' dimension values can be used in the
#' [`get_cost_and_usage`][costexplorer_get_cost_and_usage] operation.
#' 
#' If you set the context to `COST_AND_USAGE`, you can use the following
#' dimensions for searching:
#' 
#' -   AZ - The Availability Zone. An example is `us-east-1a`.
#' 
#' -   BILLING_ENTITY - The Amazon Web Services seller that your account is
#'     with. Possible values are the following:
#' 
#'     \- Amazon Web Services(Amazon Web Services): The entity that sells
#'     Amazon Web Services.
#' 
#'     \- AISPL (Amazon Internet Services Pvt. Ltd.): The local Indian
#'     entity that's an acting reseller for Amazon Web Services in India.
#' 
#'     \- Amazon Web Services Marketplace: The entity that supports the
#'     sale of solutions that are built on Amazon Web Services by
#'     third-party software providers.
#' 
#' -   CACHE_ENGINE - The Amazon ElastiCache operating system. Examples are
#'     Windows or Linux.
#' 
#' -   DEPLOYMENT_OPTION - The scope of Amazon Relational Database Service
#'     deployments. Valid values are `SingleAZ` and `MultiAZ`.
#' 
#' -   DATABASE_ENGINE - The Amazon Relational Database Service database.
#'     Examples are Aurora or MySQL.
#' 
#' -   INSTANCE_TYPE - The type of Amazon EC2 instance. An example is
#'     `m4.xlarge`.
#' 
#' -   INSTANCE_TYPE_FAMILY - A family of instance types optimized to fit
#'     different use cases. Examples are `Compute Optimized` (for example,
#'     `C4`, `C5`, `C6g`, and `C7g`), `Memory Optimization` (for example,
#'     `R4`, `R5n`, `R5b`, and `R6g`).
#' 
#' -   INVOICING_ENTITY - The name of the entity that issues the Amazon Web
#'     Services invoice.
#' 
#' -   LEGAL_ENTITY_NAME - The name of the organization that sells you
#'     Amazon Web Services services, such as Amazon Web Services.
#' 
#' -   LINKED_ACCOUNT - The description in the attribute map that includes
#'     the full name of the member account. The value field contains the
#'     Amazon Web Services ID of the member account.
#' 
#' -   OPERATING_SYSTEM - The operating system. Examples are Windows or
#'     Linux.
#' 
#' -   OPERATION - The action performed. Examples include `RunInstance` and
#'     `CreateBucket`.
#' 
#' -   PLATFORM - The Amazon EC2 operating system. Examples are Windows or
#'     Linux.
#' 
#' -   PURCHASE_TYPE - The reservation type of the purchase that this usage
#'     is related to. Examples include On-Demand Instances and Standard
#'     Reserved Instances.
#' 
#' -   RESERVATION_ID - The unique identifier for an Amazon Web Services
#'     Reservation Instance.
#' 
#' -   SAVINGS_PLAN_ARN - The unique identifier for your Savings Plans.
#' 
#' -   SAVINGS_PLANS_TYPE - Type of Savings Plans (EC2 Instance or
#'     Compute).
#' 
#' -   SERVICE - The Amazon Web Services service such as Amazon DynamoDB.
#' 
#' -   TENANCY - The tenancy of a resource. Examples are shared or
#'     dedicated.
#' 
#' -   USAGE_TYPE - The type of usage. An example is DataTransfer-In-Bytes.
#'     The response for the
#'     [`get_dimension_values`][costexplorer_get_dimension_values]
#'     operation includes a unit attribute. Examples include GB and Hrs.
#' 
#' -   USAGE_TYPE_GROUP - The grouping of common usage types. An example is
#'     Amazon EC2: CloudWatch – Alarms. The response for this operation
#'     includes a unit attribute.
#' 
#' -   REGION - The Amazon Web Services Region.
#' 
#' -   RECORD_TYPE - The different types of charges such as Reserved
#'     Instance (RI) fees, usage costs, tax refunds, and credits.
#' 
#' -   RESOURCE_ID - The unique identifier of the resource. ResourceId is
#'     an opt-in feature only available for last 14 days for EC2-Compute
#'     Service.
#' 
#' If you set the context to `RESERVATIONS`, you can use the following
#' dimensions for searching:
#' 
#' -   AZ - The Availability Zone. An example is `us-east-1a`.
#' 
#' -   CACHE_ENGINE - The Amazon ElastiCache operating system. Examples are
#'     Windows or Linux.
#' 
#' -   DEPLOYMENT_OPTION - The scope of Amazon Relational Database Service
#'     deployments. Valid values are `SingleAZ` and `MultiAZ`.
#' 
#' -   INSTANCE_TYPE - The type of Amazon EC2 instance. An example is
#'     `m4.xlarge`.
#' 
#' -   LINKED_ACCOUNT - The description in the attribute map that includes
#'     the full name of the member account. The value field contains the
#'     Amazon Web Services ID of the member account.
#' 
#' -   PLATFORM - The Amazon EC2 operating system. Examples are Windows or
#'     Linux.
#' 
#' -   REGION - The Amazon Web Services Region.
#' 
#' -   SCOPE (Utilization only) - The scope of a Reserved Instance (RI).
#'     Values are regional or a single Availability Zone.
#' 
#' -   TAG (Coverage only) - The tags that are associated with a Reserved
#'     Instance (RI).
#' 
#' -   TENANCY - The tenancy of a resource. Examples are shared or
#'     dedicated.
#' 
#' If you set the context to `SAVINGS_PLANS`, you can use the following
#' dimensions for searching:
#' 
#' -   SAVINGS_PLANS_TYPE - Type of Savings Plans (EC2 Instance or Compute)
#' 
#' -   PAYMENT_OPTION - The payment option for the given Savings Plans (for
#'     example, All Upfront)
#' 
#' -   REGION - The Amazon Web Services Region.
#' 
#' -   INSTANCE_TYPE_FAMILY - The family of instances (For example, `m5`)
#' 
#' -   LINKED_ACCOUNT - The description in the attribute map that includes
#'     the full name of the member account. The value field contains the
#'     Amazon Web Services ID of the member account.
#' 
#' -   SAVINGS_PLAN_ARN - The unique identifier for your Savings Plans.
#' @param Filter 
#' @param SortBy The value that you want to sort the data by.
#' 
#' The key represents cost and usage metrics. The following values are
#' supported:
#' 
#' -   `BlendedCost`
#' 
#' -   `UnblendedCost`
#' 
#' -   `AmortizedCost`
#' 
#' -   `NetAmortizedCost`
#' 
#' -   `NetUnblendedCost`
#' 
#' -   `UsageQuantity`
#' 
#' -   `NormalizedUsageAmount`
#' 
#' The supported values for the `SortOrder` key are `ASCENDING` or
#' `DESCENDING`.
#' 
#' When you specify a `SortBy` paramater, the context must be
#' `COST_AND_USAGE`. Further, when using `SortBy`, `NextPageToken` and
#' `SearchString` aren't supported.
#' @param MaxResults This field is only used when SortBy is provided in the request. The
#' maximum number of objects that are returned for this request. If
#' MaxResults isn't specified with SortBy, the request returns 1000 results
#' as the default value for this parameter.
#' 
#' For [`get_dimension_values`][costexplorer_get_dimension_values],
#' MaxResults has an upper limit of 1000.
#' @param NextPageToken The token to retrieve the next set of results. Amazon Web Services
#' provides the token when the response from a previous call has more
#' results than the maximum page size.
#'
#' @keywords internal
#'
#' @rdname costexplorer_get_dimension_values
costexplorer_get_dimension_values <- function(SearchString = NULL, TimePeriod, Dimension, Context = NULL, Filter = NULL, SortBy = NULL, MaxResults = NULL, NextPageToken = NULL) {
  op <- new_operation(
    name = "GetDimensionValues",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .costexplorer$get_dimension_values_input(SearchString = SearchString, TimePeriod = TimePeriod, Dimension = Dimension, Context = Context, Filter = Filter, SortBy = SortBy, MaxResults = MaxResults, NextPageToken = NextPageToken)
  output <- .costexplorer$get_dimension_values_output()
  config <- get_config()
  svc <- .costexplorer$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.costexplorer$operations$get_dimension_values <- costexplorer_get_dimension_values

#' Retrieves the reservation coverage for your account, which you can use
#' to see how much of your Amazon Elastic Compute Cloud, Amazon
#' ElastiCache, Amazon Relational Database Service, or Amazon Redshift
#' usage is covered by a reservation
#'
#' @description
#' Retrieves the reservation coverage for your account, which you can use to see how much of your Amazon Elastic Compute Cloud, Amazon ElastiCache, Amazon Relational Database Service, or Amazon Redshift usage is covered by a reservation. An organization's management account can see the coverage of the associated member accounts. This supports dimensions, Cost Categories, and nested expressions. For any time period, you can filter data about reservation usage by the following dimensions:
#'
#' See [https://www.paws-r-sdk.com/docs/costexplorer_get_reservation_coverage/](https://www.paws-r-sdk.com/docs/costexplorer_get_reservation_coverage/) for full documentation.
#'
#' @param TimePeriod &#91;required&#93; The start and end dates of the period that you want to retrieve data
#' about reservation coverage for. You can retrieve data for a maximum of
#' 13 months: the last 12 months and the current month. The start date is
#' inclusive, but the end date is exclusive. For example, if `start` is
#' `2017-01-01` and `end` is `2017-05-01`, then the cost and usage data is
#' retrieved from `2017-01-01` up to and including `2017-04-30` but not
#' including `2017-05-01`.
#' @param GroupBy You can group the data by the following attributes:
#' 
#' -   AZ
#' 
#' -   CACHE_ENGINE
#' 
#' -   DATABASE_ENGINE
#' 
#' -   DEPLOYMENT_OPTION
#' 
#' -   INSTANCE_TYPE
#' 
#' -   INVOICING_ENTITY
#' 
#' -   LINKED_ACCOUNT
#' 
#' -   OPERATING_SYSTEM
#' 
#' -   PLATFORM
#' 
#' -   REGION
#' 
#' -   TENANCY
#' @param Granularity The granularity of the Amazon Web Services cost data for the
#' reservation. Valid values are `MONTHLY` and `DAILY`.
#' 
#' If `GroupBy` is set, `Granularity` can't be set. If `Granularity` isn't
#' set, the response object doesn't include `Granularity`, either `MONTHLY`
#' or `DAILY`.
#' 
#' The [`get_reservation_coverage`][costexplorer_get_reservation_coverage]
#' operation supports only `DAILY` and `MONTHLY` granularities.
#' @param Filter Filters utilization data by dimensions. You can filter by the following
#' dimensions:
#' 
#' -   AZ
#' 
#' -   CACHE_ENGINE
#' 
#' -   DATABASE_ENGINE
#' 
#' -   DEPLOYMENT_OPTION
#' 
#' -   INSTANCE_TYPE
#' 
#' -   LINKED_ACCOUNT
#' 
#' -   OPERATING_SYSTEM
#' 
#' -   PLATFORM
#' 
#' -   REGION
#' 
#' -   SERVICE
#' 
#' -   TAG
#' 
#' -   TENANCY
#' 
#' [`get_reservation_coverage`][costexplorer_get_reservation_coverage] uses
#' the same
#' [Expression](https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_Expression.html)
#' object as the other operations, but only `AND` is supported among each
#' dimension. You can nest only one level deep. If there are multiple
#' values for a dimension, they are OR'd together.
#' 
#' If you don't provide a `SERVICE` filter, Cost Explorer defaults to EC2.
#' 
#' Cost category is also supported.
#' @param Metrics The measurement that you want your reservation coverage reported in.
#' 
#' Valid values are `Hour`, `Unit`, and `Cost`. You can use multiple values
#' in a request.
#' @param NextPageToken The token to retrieve the next set of results. Amazon Web Services
#' provides the token when the response from a previous call has more
#' results than the maximum page size.
#' @param SortBy The value by which you want to sort the data.
#' 
#' The following values are supported for `Key`:
#' 
#' -   `OnDemandCost`
#' 
#' -   `CoverageHoursPercentage`
#' 
#' -   `OnDemandHours`
#' 
#' -   `ReservedHours`
#' 
#' -   `TotalRunningHours`
#' 
#' -   `CoverageNormalizedUnitsPercentage`
#' 
#' -   `OnDemandNormalizedUnits`
#' 
#' -   `ReservedNormalizedUnits`
#' 
#' -   `TotalRunningNormalizedUnits`
#' 
#' -   `Time`
#' 
#' Supported values for `SortOrder` are `ASCENDING` or `DESCENDING`.
#' @param MaxResults The maximum number of objects that you returned for this request. If
#' more objects are available, in the response, Amazon Web Services
#' provides a NextPageToken value that you can use in a subsequent call to
#' get the next batch of objects.
#'
#' @keywords internal
#'
#' @rdname costexplorer_get_reservation_coverage
costexplorer_get_reservation_coverage <- function(TimePeriod, GroupBy = NULL, Granularity = NULL, Filter = NULL, Metrics = NULL, NextPageToken = NULL, SortBy = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "GetReservationCoverage",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .costexplorer$get_reservation_coverage_input(TimePeriod = TimePeriod, GroupBy = GroupBy, Granularity = Granularity, Filter = Filter, Metrics = Metrics, NextPageToken = NextPageToken, SortBy = SortBy, MaxResults = MaxResults)
  output <- .costexplorer$get_reservation_coverage_output()
  config <- get_config()
  svc <- .costexplorer$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.costexplorer$operations$get_reservation_coverage <- costexplorer_get_reservation_coverage

#' Gets recommendations for reservation purchases
#'
#' @description
#' Gets recommendations for reservation purchases. These recommendations might help you to reduce your costs. Reservations provide a discounted hourly rate (up to 75%) compared to On-Demand pricing.
#'
#' See [https://www.paws-r-sdk.com/docs/costexplorer_get_reservation_purchase_recommendation/](https://www.paws-r-sdk.com/docs/costexplorer_get_reservation_purchase_recommendation/) for full documentation.
#'
#' @param AccountId The account ID that's associated with the recommendation.
#' @param Service &#91;required&#93; The specific service that you want recommendations for.
#' @param Filter 
#' @param AccountScope The account scope that you want your recommendations for. Amazon Web
#' Services calculates recommendations including the management account and
#' member accounts if the value is set to `PAYER`. If the value is
#' `LINKED`, recommendations are calculated for individual member accounts
#' only.
#' @param LookbackPeriodInDays The number of previous days that you want Amazon Web Services to
#' consider when it calculates your recommendations.
#' @param TermInYears The reservation term that you want recommendations for.
#' @param PaymentOption The reservation purchase option that you want recommendations for.
#' @param ServiceSpecification The hardware specifications for the service instances that you want
#' recommendations for, such as standard or convertible Amazon EC2
#' instances.
#' @param PageSize The number of recommendations that you want returned in a single
#' response object.
#' @param NextPageToken The pagination token that indicates the next set of results that you
#' want to retrieve.
#'
#' @keywords internal
#'
#' @rdname costexplorer_get_reservation_purchase_recommendation
costexplorer_get_reservation_purchase_recommendation <- function(AccountId = NULL, Service, Filter = NULL, AccountScope = NULL, LookbackPeriodInDays = NULL, TermInYears = NULL, PaymentOption = NULL, ServiceSpecification = NULL, PageSize = NULL, NextPageToken = NULL) {
  op <- new_operation(
    name = "GetReservationPurchaseRecommendation",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .costexplorer$get_reservation_purchase_recommendation_input(AccountId = AccountId, Service = Service, Filter = Filter, AccountScope = AccountScope, LookbackPeriodInDays = LookbackPeriodInDays, TermInYears = TermInYears, PaymentOption = PaymentOption, ServiceSpecification = ServiceSpecification, PageSize = PageSize, NextPageToken = NextPageToken)
  output <- .costexplorer$get_reservation_purchase_recommendation_output()
  config <- get_config()
  svc <- .costexplorer$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.costexplorer$operations$get_reservation_purchase_recommendation <- costexplorer_get_reservation_purchase_recommendation

#' Retrieves the reservation utilization for your account
#'
#' @description
#' Retrieves the reservation utilization for your account. Management account in an organization have access to member accounts. You can filter data by dimensions in a time period. You can use [`get_dimension_values`][costexplorer_get_dimension_values] to determine the possible dimension values. Currently, you can group only by `SUBSCRIPTION_ID`.
#'
#' See [https://www.paws-r-sdk.com/docs/costexplorer_get_reservation_utilization/](https://www.paws-r-sdk.com/docs/costexplorer_get_reservation_utilization/) for full documentation.
#'
#' @param TimePeriod &#91;required&#93; Sets the start and end dates for retrieving Reserved Instance (RI)
#' utilization. The start date is inclusive, but the end date is exclusive.
#' For example, if `start` is `2017-01-01` and `end` is `2017-05-01`, then
#' the cost and usage data is retrieved from `2017-01-01` up to and
#' including `2017-04-30` but not including `2017-05-01`.
#' @param GroupBy Groups only by `SUBSCRIPTION_ID`. Metadata is included.
#' @param Granularity If `GroupBy` is set, `Granularity` can't be set. If `Granularity` isn't
#' set, the response object doesn't include `Granularity`, either `MONTHLY`
#' or `DAILY`. If both `GroupBy` and `Granularity` aren't set,
#' [`get_reservation_utilization`][costexplorer_get_reservation_utilization]
#' defaults to `DAILY`.
#' 
#' The
#' [`get_reservation_utilization`][costexplorer_get_reservation_utilization]
#' operation supports only `DAILY` and `MONTHLY` granularities.
#' @param Filter Filters utilization data by dimensions. You can filter by the following
#' dimensions:
#' 
#' -   AZ
#' 
#' -   CACHE_ENGINE
#' 
#' -   DEPLOYMENT_OPTION
#' 
#' -   INSTANCE_TYPE
#' 
#' -   LINKED_ACCOUNT
#' 
#' -   OPERATING_SYSTEM
#' 
#' -   PLATFORM
#' 
#' -   REGION
#' 
#' -   SERVICE
#' 
#' -   SCOPE
#' 
#' -   TENANCY
#' 
#' [`get_reservation_utilization`][costexplorer_get_reservation_utilization]
#' uses the same
#' [Expression](https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_Expression.html)
#' object as the other operations, but only `AND` is supported among each
#' dimension, and nesting is supported up to only one level deep. If there
#' are multiple values for a dimension, they are OR'd together.
#' @param SortBy The value that you want to sort the data by.
#' 
#' The following values are supported for `Key`:
#' 
#' -   `UtilizationPercentage`
#' 
#' -   `UtilizationPercentageInUnits`
#' 
#' -   `PurchasedHours`
#' 
#' -   `PurchasedUnits`
#' 
#' -   `TotalActualHours`
#' 
#' -   `TotalActualUnits`
#' 
#' -   `UnusedHours`
#' 
#' -   `UnusedUnits`
#' 
#' -   `OnDemandCostOfRIHoursUsed`
#' 
#' -   `NetRISavings`
#' 
#' -   `TotalPotentialRISavings`
#' 
#' -   `AmortizedUpfrontFee`
#' 
#' -   `AmortizedRecurringFee`
#' 
#' -   `TotalAmortizedFee`
#' 
#' -   `RICostForUnusedHours`
#' 
#' -   `RealizedSavings`
#' 
#' -   `UnrealizedSavings`
#' 
#' The supported values for `SortOrder` are `ASCENDING` and `DESCENDING`.
#' @param NextPageToken The token to retrieve the next set of results. Amazon Web Services
#' provides the token when the response from a previous call has more
#' results than the maximum page size.
#' @param MaxResults The maximum number of objects that you returned for this request. If
#' more objects are available, in the response, Amazon Web Services
#' provides a NextPageToken value that you can use in a subsequent call to
#' get the next batch of objects.
#'
#' @keywords internal
#'
#' @rdname costexplorer_get_reservation_utilization
costexplorer_get_reservation_utilization <- function(TimePeriod, GroupBy = NULL, Granularity = NULL, Filter = NULL, SortBy = NULL, NextPageToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "GetReservationUtilization",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .costexplorer$get_reservation_utilization_input(TimePeriod = TimePeriod, GroupBy = GroupBy, Granularity = Granularity, Filter = Filter, SortBy = SortBy, NextPageToken = NextPageToken, MaxResults = MaxResults)
  output <- .costexplorer$get_reservation_utilization_output()
  config <- get_config()
  svc <- .costexplorer$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.costexplorer$operations$get_reservation_utilization <- costexplorer_get_reservation_utilization

#' Creates recommendations that help you save cost by identifying idle and
#' underutilized Amazon EC2 instances
#'
#' @description
#' Creates recommendations that help you save cost by identifying idle and underutilized Amazon EC2 instances.
#'
#' See [https://www.paws-r-sdk.com/docs/costexplorer_get_rightsizing_recommendation/](https://www.paws-r-sdk.com/docs/costexplorer_get_rightsizing_recommendation/) for full documentation.
#'
#' @param Filter 
#' @param Configuration You can use Configuration to customize recommendations across two
#' attributes. You can choose to view recommendations for instances within
#' the same instance families or across different instance families. You
#' can also choose to view your estimated savings that are associated with
#' recommendations with consideration of existing Savings Plans or RI
#' benefits, or neither.
#' @param Service &#91;required&#93; The specific service that you want recommendations for. The only valid
#' value for
#' [`get_rightsizing_recommendation`][costexplorer_get_rightsizing_recommendation]
#' is "`AmazonEC2`".
#' @param PageSize The number of recommendations that you want returned in a single
#' response object.
#' @param NextPageToken The pagination token that indicates the next set of results that you
#' want to retrieve.
#'
#' @keywords internal
#'
#' @rdname costexplorer_get_rightsizing_recommendation
costexplorer_get_rightsizing_recommendation <- function(Filter = NULL, Configuration = NULL, Service, PageSize = NULL, NextPageToken = NULL) {
  op <- new_operation(
    name = "GetRightsizingRecommendation",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .costexplorer$get_rightsizing_recommendation_input(Filter = Filter, Configuration = Configuration, Service = Service, PageSize = PageSize, NextPageToken = NextPageToken)
  output <- .costexplorer$get_rightsizing_recommendation_output()
  config <- get_config()
  svc <- .costexplorer$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.costexplorer$operations$get_rightsizing_recommendation <- costexplorer_get_rightsizing_recommendation

#' Retrieves the Savings Plans covered for your account
#'
#' @description
#' Retrieves the Savings Plans covered for your account. This enables you to see how much of your cost is covered by a Savings Plan. An organization’s management account can see the coverage of the associated member accounts. This supports dimensions, Cost Categories, and nested expressions. For any time period, you can filter data for Savings Plans usage with the following dimensions:
#'
#' See [https://www.paws-r-sdk.com/docs/costexplorer_get_savings_plans_coverage/](https://www.paws-r-sdk.com/docs/costexplorer_get_savings_plans_coverage/) for full documentation.
#'
#' @param TimePeriod &#91;required&#93; The time period that you want the usage and costs for. The `Start` date
#' must be within 13 months. The `End` date must be after the `Start` date,
#' and before the current date. Future dates can't be used as an `End`
#' date.
#' @param GroupBy You can group the data using the attributes `INSTANCE_FAMILY`, `REGION`,
#' or `SERVICE`.
#' @param Granularity The granularity of the Amazon Web Services cost data for your Savings
#' Plans. `Granularity` can't be set if `GroupBy` is set.
#' 
#' The
#' [`get_savings_plans_coverage`][costexplorer_get_savings_plans_coverage]
#' operation supports only `DAILY` and `MONTHLY` granularities.
#' @param Filter Filters Savings Plans coverage data by dimensions. You can filter data
#' for Savings Plans usage with the following dimensions:
#' 
#' -   `LINKED_ACCOUNT`
#' 
#' -   `REGION`
#' 
#' -   `SERVICE`
#' 
#' -   `INSTANCE_FAMILY`
#' 
#' [`get_savings_plans_coverage`][costexplorer_get_savings_plans_coverage]
#' uses the same
#' [Expression](https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_Expression.html)
#' object as the other operations, but only `AND` is supported among each
#' dimension. If there are multiple values for a dimension, they are OR'd
#' together.
#' 
#' Cost category is also supported.
#' @param Metrics The measurement that you want your Savings Plans coverage reported in.
#' The only valid value is `SpendCoveredBySavingsPlans`.
#' @param NextToken The token to retrieve the next set of results. Amazon Web Services
#' provides the token when the response from a previous call has more
#' results than the maximum page size.
#' @param MaxResults The number of items to be returned in a response. The default is `20`,
#' with a minimum value of `1`.
#' @param SortBy The value that you want to sort the data by.
#' 
#' The following values are supported for `Key`:
#' 
#' -   `SpendCoveredBySavingsPlan`
#' 
#' -   `OnDemandCost`
#' 
#' -   `CoveragePercentage`
#' 
#' -   `TotalCost`
#' 
#' -   `InstanceFamily`
#' 
#' -   `Region`
#' 
#' -   `Service`
#' 
#' The supported values for `SortOrder` are `ASCENDING` and `DESCENDING`.
#'
#' @keywords internal
#'
#' @rdname costexplorer_get_savings_plans_coverage
costexplorer_get_savings_plans_coverage <- function(TimePeriod, GroupBy = NULL, Granularity = NULL, Filter = NULL, Metrics = NULL, NextToken = NULL, MaxResults = NULL, SortBy = NULL) {
  op <- new_operation(
    name = "GetSavingsPlansCoverage",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .costexplorer$get_savings_plans_coverage_input(TimePeriod = TimePeriod, GroupBy = GroupBy, Granularity = Granularity, Filter = Filter, Metrics = Metrics, NextToken = NextToken, MaxResults = MaxResults, SortBy = SortBy)
  output <- .costexplorer$get_savings_plans_coverage_output()
  config <- get_config()
  svc <- .costexplorer$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.costexplorer$operations$get_savings_plans_coverage <- costexplorer_get_savings_plans_coverage

#' Retrieves the Savings Plans recommendations for your account
#'
#' @description
#' Retrieves the Savings Plans recommendations for your account. First use [`start_savings_plans_purchase_recommendation_generation`][costexplorer_start_savings_plans_purchase_recommendation_generation] to generate a new set of recommendations, and then use [`get_savings_plans_purchase_recommendation`][costexplorer_get_savings_plans_purchase_recommendation] to retrieve them.
#'
#' See [https://www.paws-r-sdk.com/docs/costexplorer_get_savings_plans_purchase_recommendation/](https://www.paws-r-sdk.com/docs/costexplorer_get_savings_plans_purchase_recommendation/) for full documentation.
#'
#' @param SavingsPlansType &#91;required&#93; The Savings Plans recommendation type that's requested.
#' @param TermInYears &#91;required&#93; The savings plan recommendation term that's used to generate these
#' recommendations.
#' @param PaymentOption &#91;required&#93; The payment option that's used to generate these recommendations.
#' @param AccountScope The account scope that you want your recommendations for. Amazon Web
#' Services calculates recommendations including the management account and
#' member accounts if the value is set to `PAYER`. If the value is
#' `LINKED`, recommendations are calculated for individual member accounts
#' only.
#' @param NextPageToken The token to retrieve the next set of results. Amazon Web Services
#' provides the token when the response from a previous call has more
#' results than the maximum page size.
#' @param PageSize The number of recommendations that you want returned in a single
#' response object.
#' @param LookbackPeriodInDays &#91;required&#93; The lookback period that's used to generate the recommendation.
#' @param Filter You can filter your recommendations by Account ID with the
#' `LINKED_ACCOUNT` dimension. To filter your recommendations by Account
#' ID, specify `Key` as `LINKED_ACCOUNT` and `Value` as the comma-separated
#' Acount ID(s) that you want to see Savings Plans purchase recommendations
#' for.
#' 
#' For GetSavingsPlansPurchaseRecommendation, the `Filter` doesn't include
#' `CostCategories` or `Tags`. It only includes `Dimensions`. With
#' `Dimensions`, `Key` must be `LINKED_ACCOUNT` and `Value` can be a single
#' Account ID or multiple comma-separated Account IDs that you want to see
#' Savings Plans Purchase Recommendations for. `AND` and `OR` operators are
#' not supported.
#'
#' @keywords internal
#'
#' @rdname costexplorer_get_savings_plans_purchase_recommendation
costexplorer_get_savings_plans_purchase_recommendation <- function(SavingsPlansType, TermInYears, PaymentOption, AccountScope = NULL, NextPageToken = NULL, PageSize = NULL, LookbackPeriodInDays, Filter = NULL) {
  op <- new_operation(
    name = "GetSavingsPlansPurchaseRecommendation",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .costexplorer$get_savings_plans_purchase_recommendation_input(SavingsPlansType = SavingsPlansType, TermInYears = TermInYears, PaymentOption = PaymentOption, AccountScope = AccountScope, NextPageToken = NextPageToken, PageSize = PageSize, LookbackPeriodInDays = LookbackPeriodInDays, Filter = Filter)
  output <- .costexplorer$get_savings_plans_purchase_recommendation_output()
  config <- get_config()
  svc <- .costexplorer$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.costexplorer$operations$get_savings_plans_purchase_recommendation <- costexplorer_get_savings_plans_purchase_recommendation

#' Retrieves the Savings Plans utilization for your account across date
#' ranges with daily or monthly granularity
#'
#' @description
#' Retrieves the Savings Plans utilization for your account across date ranges with daily or monthly granularity. Management account in an organization have access to member accounts. You can use [`get_dimension_values`][costexplorer_get_dimension_values] in `SAVINGS_PLANS` to determine the possible dimension values.
#'
#' See [https://www.paws-r-sdk.com/docs/costexplorer_get_savings_plans_utilization/](https://www.paws-r-sdk.com/docs/costexplorer_get_savings_plans_utilization/) for full documentation.
#'
#' @param TimePeriod &#91;required&#93; The time period that you want the usage and costs for. The `Start` date
#' must be within 13 months. The `End` date must be after the `Start` date,
#' and before the current date. Future dates can't be used as an `End`
#' date.
#' @param Granularity The granularity of the Amazon Web Services utillization data for your
#' Savings Plans.
#' 
#' The
#' [`get_savings_plans_utilization`][costexplorer_get_savings_plans_utilization]
#' operation supports only `DAILY` and `MONTHLY` granularities.
#' @param Filter Filters Savings Plans utilization coverage data for active Savings Plans
#' dimensions. You can filter data with the following dimensions:
#' 
#' -   `LINKED_ACCOUNT`
#' 
#' -   `SAVINGS_PLAN_ARN`
#' 
#' -   `SAVINGS_PLANS_TYPE`
#' 
#' -   `REGION`
#' 
#' -   `PAYMENT_OPTION`
#' 
#' -   `INSTANCE_TYPE_FAMILY`
#' 
#' [`get_savings_plans_utilization`][costexplorer_get_savings_plans_utilization]
#' uses the same
#' [Expression](https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_Expression.html)
#' object as the other operations, but only `AND` is supported among each
#' dimension.
#' @param SortBy The value that you want to sort the data by.
#' 
#' The following values are supported for `Key`:
#' 
#' -   `UtilizationPercentage`
#' 
#' -   `TotalCommitment`
#' 
#' -   `UsedCommitment`
#' 
#' -   `UnusedCommitment`
#' 
#' -   `NetSavings`
#' 
#' The supported values for `SortOrder` are `ASCENDING` and `DESCENDING`.
#'
#' @keywords internal
#'
#' @rdname costexplorer_get_savings_plans_utilization
costexplorer_get_savings_plans_utilization <- function(TimePeriod, Granularity = NULL, Filter = NULL, SortBy = NULL) {
  op <- new_operation(
    name = "GetSavingsPlansUtilization",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .costexplorer$get_savings_plans_utilization_input(TimePeriod = TimePeriod, Granularity = Granularity, Filter = Filter, SortBy = SortBy)
  output <- .costexplorer$get_savings_plans_utilization_output()
  config <- get_config()
  svc <- .costexplorer$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.costexplorer$operations$get_savings_plans_utilization <- costexplorer_get_savings_plans_utilization

#' Retrieves attribute data along with aggregate utilization and savings
#' data for a given time period
#'
#' @description
#' Retrieves attribute data along with aggregate utilization and savings data for a given time period. This doesn't support granular or grouped data (daily/monthly) in response. You can't retrieve data by dates in a single response similar to `GetSavingsPlanUtilization`, but you have the option to make multiple calls to `GetSavingsPlanUtilizationDetails` by providing individual dates. You can use [`get_dimension_values`][costexplorer_get_dimension_values] in `SAVINGS_PLANS` to determine the possible dimension values.
#'
#' See [https://www.paws-r-sdk.com/docs/costexplorer_get_savings_plans_utilization_details/](https://www.paws-r-sdk.com/docs/costexplorer_get_savings_plans_utilization_details/) for full documentation.
#'
#' @param TimePeriod &#91;required&#93; The time period that you want the usage and costs for. The `Start` date
#' must be within 13 months. The `End` date must be after the `Start` date,
#' and before the current date. Future dates can't be used as an `End`
#' date.
#' @param Filter Filters Savings Plans utilization coverage data for active Savings Plans
#' dimensions. You can filter data with the following dimensions:
#' 
#' -   `LINKED_ACCOUNT`
#' 
#' -   `SAVINGS_PLAN_ARN`
#' 
#' -   `REGION`
#' 
#' -   `PAYMENT_OPTION`
#' 
#' -   `INSTANCE_TYPE_FAMILY`
#' 
#' [`get_savings_plans_utilization_details`][costexplorer_get_savings_plans_utilization_details]
#' uses the same
#' [Expression](https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_Expression.html)
#' object as the other operations, but only `AND` is supported among each
#' dimension.
#' @param DataType The data type.
#' @param NextToken The token to retrieve the next set of results. Amazon Web Services
#' provides the token when the response from a previous call has more
#' results than the maximum page size.
#' @param MaxResults The number of items to be returned in a response. The default is `20`,
#' with a minimum value of `1`.
#' @param SortBy The value that you want to sort the data by.
#' 
#' The following values are supported for `Key`:
#' 
#' -   `UtilizationPercentage`
#' 
#' -   `TotalCommitment`
#' 
#' -   `UsedCommitment`
#' 
#' -   `UnusedCommitment`
#' 
#' -   `NetSavings`
#' 
#' -   `AmortizedRecurringCommitment`
#' 
#' -   `AmortizedUpfrontCommitment`
#' 
#' The supported values for `SortOrder` are `ASCENDING` and `DESCENDING`.
#'
#' @keywords internal
#'
#' @rdname costexplorer_get_savings_plans_utilization_details
costexplorer_get_savings_plans_utilization_details <- function(TimePeriod, Filter = NULL, DataType = NULL, NextToken = NULL, MaxResults = NULL, SortBy = NULL) {
  op <- new_operation(
    name = "GetSavingsPlansUtilizationDetails",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .costexplorer$get_savings_plans_utilization_details_input(TimePeriod = TimePeriod, Filter = Filter, DataType = DataType, NextToken = NextToken, MaxResults = MaxResults, SortBy = SortBy)
  output <- .costexplorer$get_savings_plans_utilization_details_output()
  config <- get_config()
  svc <- .costexplorer$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.costexplorer$operations$get_savings_plans_utilization_details <- costexplorer_get_savings_plans_utilization_details

#' Queries for available tag keys and tag values for a specified period
#'
#' @description
#' Queries for available tag keys and tag values for a specified period. You can search the tag values for an arbitrary string.
#'
#' See [https://www.paws-r-sdk.com/docs/costexplorer_get_tags/](https://www.paws-r-sdk.com/docs/costexplorer_get_tags/) for full documentation.
#'
#' @param SearchString The value that you want to search for.
#' @param TimePeriod &#91;required&#93; The start and end dates for retrieving the dimension values. The start
#' date is inclusive, but the end date is exclusive. For example, if
#' `start` is `2017-01-01` and `end` is `2017-05-01`, then the cost and
#' usage data is retrieved from `2017-01-01` up to and including
#' `2017-04-30` but not including `2017-05-01`.
#' @param TagKey The key of the tag that you want to return values for.
#' @param Filter 
#' @param SortBy The value that you want to sort the data by.
#' 
#' The key represents cost and usage metrics. The following values are
#' supported:
#' 
#' -   `BlendedCost`
#' 
#' -   `UnblendedCost`
#' 
#' -   `AmortizedCost`
#' 
#' -   `NetAmortizedCost`
#' 
#' -   `NetUnblendedCost`
#' 
#' -   `UsageQuantity`
#' 
#' -   `NormalizedUsageAmount`
#' 
#' The supported values for `SortOrder` are `ASCENDING` and `DESCENDING`.
#' 
#' When you use `SortBy`, `NextPageToken` and `SearchString` aren't
#' supported.
#' @param MaxResults This field is only used when SortBy is provided in the request. The
#' maximum number of objects that are returned for this request. If
#' MaxResults isn't specified with SortBy, the request returns 1000 results
#' as the default value for this parameter.
#' 
#' For [`get_tags`][costexplorer_get_tags], MaxResults has an upper quota
#' of 1000.
#' @param NextPageToken The token to retrieve the next set of results. Amazon Web Services
#' provides the token when the response from a previous call has more
#' results than the maximum page size.
#'
#' @keywords internal
#'
#' @rdname costexplorer_get_tags
costexplorer_get_tags <- function(SearchString = NULL, TimePeriod, TagKey = NULL, Filter = NULL, SortBy = NULL, MaxResults = NULL, NextPageToken = NULL) {
  op <- new_operation(
    name = "GetTags",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .costexplorer$get_tags_input(SearchString = SearchString, TimePeriod = TimePeriod, TagKey = TagKey, Filter = Filter, SortBy = SortBy, MaxResults = MaxResults, NextPageToken = NextPageToken)
  output <- .costexplorer$get_tags_output()
  config <- get_config()
  svc <- .costexplorer$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.costexplorer$operations$get_tags <- costexplorer_get_tags

#' Retrieves a forecast for how much Amazon Web Services predicts that you
#' will use over the forecast time period that you select, based on your
#' past usage
#'
#' @description
#' Retrieves a forecast for how much Amazon Web Services predicts that you will use over the forecast time period that you select, based on your past usage.
#'
#' See [https://www.paws-r-sdk.com/docs/costexplorer_get_usage_forecast/](https://www.paws-r-sdk.com/docs/costexplorer_get_usage_forecast/) for full documentation.
#'
#' @param TimePeriod &#91;required&#93; The start and end dates of the period that you want to retrieve usage
#' forecast for. The start date is included in the period, but the end date
#' isn't included in the period. For example, if `start` is `2017-01-01`
#' and `end` is `2017-05-01`, then the cost and usage data is retrieved
#' from `2017-01-01` up to and including `2017-04-30` but not including
#' `2017-05-01`. The start date must be equal to or later than the current
#' date to avoid a validation error.
#' @param Metric &#91;required&#93; Which metric Cost Explorer uses to create your forecast.
#' 
#' Valid values for a
#' [`get_usage_forecast`][costexplorer_get_usage_forecast] call are the
#' following:
#' 
#' -   USAGE_QUANTITY
#' 
#' -   NORMALIZED_USAGE_AMOUNT
#' @param Granularity &#91;required&#93; How granular you want the forecast to be. You can get 3 months of
#' `DAILY` forecasts or 12 months of `MONTHLY` forecasts.
#' 
#' The [`get_usage_forecast`][costexplorer_get_usage_forecast] operation
#' supports only `DAILY` and `MONTHLY` granularities.
#' @param Filter The filters that you want to use to filter your forecast. The
#' [`get_usage_forecast`][costexplorer_get_usage_forecast] API supports
#' filtering by the following dimensions:
#' 
#' -   `AZ`
#' 
#' -   `INSTANCE_TYPE`
#' 
#' -   `LINKED_ACCOUNT`
#' 
#' -   `LINKED_ACCOUNT_NAME`
#' 
#' -   `OPERATION`
#' 
#' -   `PURCHASE_TYPE`
#' 
#' -   `REGION`
#' 
#' -   `SERVICE`
#' 
#' -   `USAGE_TYPE`
#' 
#' -   `USAGE_TYPE_GROUP`
#' 
#' -   `RECORD_TYPE`
#' 
#' -   `OPERATING_SYSTEM`
#' 
#' -   `TENANCY`
#' 
#' -   `SCOPE`
#' 
#' -   `PLATFORM`
#' 
#' -   `SUBSCRIPTION_ID`
#' 
#' -   `LEGAL_ENTITY_NAME`
#' 
#' -   `DEPLOYMENT_OPTION`
#' 
#' -   `DATABASE_ENGINE`
#' 
#' -   `INSTANCE_TYPE_FAMILY`
#' 
#' -   `BILLING_ENTITY`
#' 
#' -   `RESERVATION_ID`
#' 
#' -   `SAVINGS_PLAN_ARN`
#' @param PredictionIntervalLevel Amazon Web Services Cost Explorer always returns the mean forecast as a
#' single point. You can request a prediction interval around the mean by
#' specifying a confidence level. The higher the confidence level, the more
#' confident Cost Explorer is about the actual value falling in the
#' prediction interval. Higher confidence levels result in wider prediction
#' intervals.
#'
#' @keywords internal
#'
#' @rdname costexplorer_get_usage_forecast
costexplorer_get_usage_forecast <- function(TimePeriod, Metric, Granularity, Filter = NULL, PredictionIntervalLevel = NULL) {
  op <- new_operation(
    name = "GetUsageForecast",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .costexplorer$get_usage_forecast_input(TimePeriod = TimePeriod, Metric = Metric, Granularity = Granularity, Filter = Filter, PredictionIntervalLevel = PredictionIntervalLevel)
  output <- .costexplorer$get_usage_forecast_output()
  config <- get_config()
  svc <- .costexplorer$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.costexplorer$operations$get_usage_forecast <- costexplorer_get_usage_forecast

#' Get a list of cost allocation tags
#'
#' @description
#' Get a list of cost allocation tags. All inputs in the API are optional and serve as filters. By default, all cost allocation tags are returned.
#'
#' See [https://www.paws-r-sdk.com/docs/costexplorer_list_cost_allocation_tags/](https://www.paws-r-sdk.com/docs/costexplorer_list_cost_allocation_tags/) for full documentation.
#'
#' @param Status The status of cost allocation tag keys that are returned for this
#' request.
#' @param TagKeys The list of cost allocation tag keys that are returned for this request.
#' @param Type The type of `CostAllocationTag` object that are returned for this
#' request. The `AWSGenerated` type tags are tags that Amazon Web Services
#' defines and applies to support Amazon Web Services resources for cost
#' allocation purposes. The `UserDefined` type tags are tags that you
#' define, create, and apply to resources.
#' @param NextToken The token to retrieve the next set of results. Amazon Web Services
#' provides the token when the response from a previous call has more
#' results than the maximum page size.
#' @param MaxResults The maximum number of objects that are returned for this request. By
#' default, the request returns 100 results.
#'
#' @keywords internal
#'
#' @rdname costexplorer_list_cost_allocation_tags
costexplorer_list_cost_allocation_tags <- function(Status = NULL, TagKeys = NULL, Type = NULL, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "ListCostAllocationTags",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .costexplorer$list_cost_allocation_tags_input(Status = Status, TagKeys = TagKeys, Type = Type, NextToken = NextToken, MaxResults = MaxResults)
  output <- .costexplorer$list_cost_allocation_tags_output()
  config <- get_config()
  svc <- .costexplorer$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.costexplorer$operations$list_cost_allocation_tags <- costexplorer_list_cost_allocation_tags

#' Returns the name, Amazon Resource Name (ARN), NumberOfRules and
#' effective dates of all Cost Categories defined in the account
#'
#' @description
#' Returns the name, Amazon Resource Name (ARN), `NumberOfRules` and effective dates of all Cost Categories defined in the account. You have the option to use `EffectiveOn` to return a list of Cost Categories that were active on a specific date. If there is no `EffectiveOn` specified, you’ll see Cost Categories that are effective on the current date. If Cost Category is still effective, `EffectiveEnd` is omitted in the response. [`list_cost_category_definitions`][costexplorer_list_cost_category_definitions] supports pagination. The request can have a `MaxResults` range up to 100.
#'
#' See [https://www.paws-r-sdk.com/docs/costexplorer_list_cost_category_definitions/](https://www.paws-r-sdk.com/docs/costexplorer_list_cost_category_definitions/) for full documentation.
#'
#' @param EffectiveOn The date when the Cost Category was effective.
#' @param NextToken The token to retrieve the next set of results. Amazon Web Services
#' provides the token when the response from a previous call has more
#' results than the maximum page size.
#' @param MaxResults The number of entries a paginated response contains.
#'
#' @keywords internal
#'
#' @rdname costexplorer_list_cost_category_definitions
costexplorer_list_cost_category_definitions <- function(EffectiveOn = NULL, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "ListCostCategoryDefinitions",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .costexplorer$list_cost_category_definitions_input(EffectiveOn = EffectiveOn, NextToken = NextToken, MaxResults = MaxResults)
  output <- .costexplorer$list_cost_category_definitions_output()
  config <- get_config()
  svc <- .costexplorer$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.costexplorer$operations$list_cost_category_definitions <- costexplorer_list_cost_category_definitions

#' Retrieves a list of your historical recommendation generations within
#' the past 30 days
#'
#' @description
#' Retrieves a list of your historical recommendation generations within the past 30 days.
#'
#' See [https://www.paws-r-sdk.com/docs/costexplorer_list_savings_plans_purchase_recommendation_generation/](https://www.paws-r-sdk.com/docs/costexplorer_list_savings_plans_purchase_recommendation_generation/) for full documentation.
#'
#' @param GenerationStatus The status of the recommendation generation.
#' @param RecommendationIds The IDs for each specific recommendation.
#' @param PageSize The number of recommendations that you want returned in a single
#' response object.
#' @param NextPageToken The token to retrieve the next set of results.
#'
#' @keywords internal
#'
#' @rdname costexplorer_list_saving_plans_purcha_recomm_genera
costexplorer_list_savings_plans_purchase_recommendation_generation <- function(GenerationStatus = NULL, RecommendationIds = NULL, PageSize = NULL, NextPageToken = NULL) {
  op <- new_operation(
    name = "ListSavingsPlansPurchaseRecommendationGeneration",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .costexplorer$list_savings_plans_purchase_recommendation_generation_input(GenerationStatus = GenerationStatus, RecommendationIds = RecommendationIds, PageSize = PageSize, NextPageToken = NextPageToken)
  output <- .costexplorer$list_savings_plans_purchase_recommendation_generation_output()
  config <- get_config()
  svc <- .costexplorer$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.costexplorer$operations$list_savings_plans_purchase_recommendation_generation <- costexplorer_list_savings_plans_purchase_recommendation_generation

#' Returns a list of resource tags associated with the resource specified
#' by the Amazon Resource Name (ARN)
#'
#' @description
#' Returns a list of resource tags associated with the resource specified by the Amazon Resource Name (ARN).
#'
#' See [https://www.paws-r-sdk.com/docs/costexplorer_list_tags_for_resource/](https://www.paws-r-sdk.com/docs/costexplorer_list_tags_for_resource/) for full documentation.
#'
#' @param ResourceArn &#91;required&#93; The Amazon Resource Name (ARN) of the resource. For a list of supported
#' resources, see
#' [ResourceTag](https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_ResourceTag.html).
#'
#' @keywords internal
#'
#' @rdname costexplorer_list_tags_for_resource
costexplorer_list_tags_for_resource <- function(ResourceArn) {
  op <- new_operation(
    name = "ListTagsForResource",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .costexplorer$list_tags_for_resource_input(ResourceArn = ResourceArn)
  output <- .costexplorer$list_tags_for_resource_output()
  config <- get_config()
  svc <- .costexplorer$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.costexplorer$operations$list_tags_for_resource <- costexplorer_list_tags_for_resource

#' Modifies the feedback property of a given cost anomaly
#'
#' @description
#' Modifies the feedback property of a given cost anomaly.
#'
#' See [https://www.paws-r-sdk.com/docs/costexplorer_provide_anomaly_feedback/](https://www.paws-r-sdk.com/docs/costexplorer_provide_anomaly_feedback/) for full documentation.
#'
#' @param AnomalyId &#91;required&#93; A cost anomaly ID.
#' @param Feedback &#91;required&#93; Describes whether the cost anomaly was a planned activity or you
#' considered it an anomaly.
#'
#' @keywords internal
#'
#' @rdname costexplorer_provide_anomaly_feedback
costexplorer_provide_anomaly_feedback <- function(AnomalyId, Feedback) {
  op <- new_operation(
    name = "ProvideAnomalyFeedback",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .costexplorer$provide_anomaly_feedback_input(AnomalyId = AnomalyId, Feedback = Feedback)
  output <- .costexplorer$provide_anomaly_feedback_output()
  config <- get_config()
  svc <- .costexplorer$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.costexplorer$operations$provide_anomaly_feedback <- costexplorer_provide_anomaly_feedback

#' Requests a Savings Plans recommendation generation
#'
#' @description
#' Requests a Savings Plans recommendation generation. This enables you to calculate a fresh set of Savings Plans recommendations that takes your latest usage data and current Savings Plans inventory into account. You can refresh Savings Plans recommendations up to three times daily for a consolidated billing family.
#'
#' See [https://www.paws-r-sdk.com/docs/costexplorer_start_savings_plans_purchase_recommendation_generation/](https://www.paws-r-sdk.com/docs/costexplorer_start_savings_plans_purchase_recommendation_generation/) for full documentation.
#'
#' @keywords internal
#'
#' @rdname costexplorer_start_saving_plans_purcha_recomm_genera
costexplorer_start_savings_plans_purchase_recommendation_generation <- function() {
  op <- new_operation(
    name = "StartSavingsPlansPurchaseRecommendationGeneration",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .costexplorer$start_savings_plans_purchase_recommendation_generation_input()
  output <- .costexplorer$start_savings_plans_purchase_recommendation_generation_output()
  config <- get_config()
  svc <- .costexplorer$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.costexplorer$operations$start_savings_plans_purchase_recommendation_generation <- costexplorer_start_savings_plans_purchase_recommendation_generation

#' An API operation for adding one or more tags (key-value pairs) to a
#' resource
#'
#' @description
#' An API operation for adding one or more tags (key-value pairs) to a resource.
#'
#' See [https://www.paws-r-sdk.com/docs/costexplorer_tag_resource/](https://www.paws-r-sdk.com/docs/costexplorer_tag_resource/) for full documentation.
#'
#' @param ResourceArn &#91;required&#93; The Amazon Resource Name (ARN) of the resource. For a list of supported
#' resources, see
#' [ResourceTag](https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_ResourceTag.html).
#' @param ResourceTags &#91;required&#93; A list of tag key-value pairs to be added to the resource.
#' 
#' Each tag consists of a key and a value, and each key must be unique for
#' the resource. The following restrictions apply to resource tags:
#' 
#' -   Although the maximum number of array members is 200, you can assign
#'     a maximum of 50 user-tags to one resource. The remaining are
#'     reserved for Amazon Web Services use
#' 
#' -   The maximum length of a key is 128 characters
#' 
#' -   The maximum length of a value is 256 characters
#' 
#' -   Keys and values can only contain alphanumeric characters, spaces,
#'     and any of the following: `_.:/=+@@-`
#' 
#' -   Keys and values are case sensitive
#' 
#' -   Keys and values are trimmed for any leading or trailing whitespaces
#' 
#' -   Don’t use `aws:` as a prefix for your keys. This prefix is reserved
#'     for Amazon Web Services use
#'
#' @keywords internal
#'
#' @rdname costexplorer_tag_resource
costexplorer_tag_resource <- function(ResourceArn, ResourceTags) {
  op <- new_operation(
    name = "TagResource",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .costexplorer$tag_resource_input(ResourceArn = ResourceArn, ResourceTags = ResourceTags)
  output <- .costexplorer$tag_resource_output()
  config <- get_config()
  svc <- .costexplorer$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.costexplorer$operations$tag_resource <- costexplorer_tag_resource

#' Removes one or more tags from a resource
#'
#' @description
#' Removes one or more tags from a resource. Specify only tag keys in your request. Don't specify the value.
#'
#' See [https://www.paws-r-sdk.com/docs/costexplorer_untag_resource/](https://www.paws-r-sdk.com/docs/costexplorer_untag_resource/) for full documentation.
#'
#' @param ResourceArn &#91;required&#93; The Amazon Resource Name (ARN) of the resource. For a list of supported
#' resources, see
#' [ResourceTag](https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_ResourceTag.html).
#' @param ResourceTagKeys &#91;required&#93; A list of tag keys associated with tags that need to be removed from the
#' resource. If you specify a tag key that doesn't exist, it's ignored.
#' Although the maximum number of array members is 200, user-tag maximum is
#' 50. The remaining are reserved for Amazon Web Services use.
#'
#' @keywords internal
#'
#' @rdname costexplorer_untag_resource
costexplorer_untag_resource <- function(ResourceArn, ResourceTagKeys) {
  op <- new_operation(
    name = "UntagResource",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .costexplorer$untag_resource_input(ResourceArn = ResourceArn, ResourceTagKeys = ResourceTagKeys)
  output <- .costexplorer$untag_resource_output()
  config <- get_config()
  svc <- .costexplorer$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.costexplorer$operations$untag_resource <- costexplorer_untag_resource

#' Updates an existing cost anomaly monitor
#'
#' @description
#' Updates an existing cost anomaly monitor. The changes made are applied going forward, and doesn't change anomalies detected in the past.
#'
#' See [https://www.paws-r-sdk.com/docs/costexplorer_update_anomaly_monitor/](https://www.paws-r-sdk.com/docs/costexplorer_update_anomaly_monitor/) for full documentation.
#'
#' @param MonitorArn &#91;required&#93; Cost anomaly monitor Amazon Resource Names (ARNs).
#' @param MonitorName The new name for the cost anomaly monitor.
#'
#' @keywords internal
#'
#' @rdname costexplorer_update_anomaly_monitor
costexplorer_update_anomaly_monitor <- function(MonitorArn, MonitorName = NULL) {
  op <- new_operation(
    name = "UpdateAnomalyMonitor",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .costexplorer$update_anomaly_monitor_input(MonitorArn = MonitorArn, MonitorName = MonitorName)
  output <- .costexplorer$update_anomaly_monitor_output()
  config <- get_config()
  svc <- .costexplorer$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.costexplorer$operations$update_anomaly_monitor <- costexplorer_update_anomaly_monitor

#' Updates an existing cost anomaly monitor subscription
#'
#' @description
#' Updates an existing cost anomaly monitor subscription.
#'
#' See [https://www.paws-r-sdk.com/docs/costexplorer_update_anomaly_subscription/](https://www.paws-r-sdk.com/docs/costexplorer_update_anomaly_subscription/) for full documentation.
#'
#' @param SubscriptionArn &#91;required&#93; A cost anomaly subscription Amazon Resource Name (ARN).
#' @param Threshold (deprecated)
#' 
#' The update to the threshold value for receiving notifications.
#' 
#' This field has been deprecated. To update a threshold, use
#' ThresholdExpression. Continued use of Threshold will be treated as
#' shorthand syntax for a ThresholdExpression.
#' @param Frequency The update to the frequency value that subscribers receive
#' notifications.
#' @param MonitorArnList A list of cost anomaly monitor ARNs.
#' @param Subscribers The update to the subscriber list.
#' @param SubscriptionName The new name of the subscription.
#' @param ThresholdExpression The update to the
#' [Expression](https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_Expression.html)
#' object used to specify the anomalies that you want to generate alerts
#' for. This supports dimensions and nested expressions. The supported
#' dimensions are `ANOMALY_TOTAL_IMPACT_ABSOLUTE` and
#' `ANOMALY_TOTAL_IMPACT_PERCENTAGE`. The supported nested expression types
#' are `AND` and `OR`. The match option `GREATER_THAN_OR_EQUAL` is
#' required. Values must be numbers between 0 and 10,000,000,000.
#' 
#' The following are examples of valid ThresholdExpressions:
#' 
#' -   Absolute threshold:
#'     `{ "Dimensions": { "Key": "ANOMALY_TOTAL_IMPACT_ABSOLUTE", "MatchOptions": [ "GREATER_THAN_OR_EQUAL" ], "Values": [ "100" ] } }`
#' 
#' -   Percentage threshold:
#'     `{ "Dimensions": { "Key": "ANOMALY_TOTAL_IMPACT_PERCENTAGE", "MatchOptions": [ "GREATER_THAN_OR_EQUAL" ], "Values": [ "100" ] } }`
#' 
#' -   `AND` two thresholds together:
#'     `{ "And": [ { "Dimensions": { "Key": "ANOMALY_TOTAL_IMPACT_ABSOLUTE", "MatchOptions": [ "GREATER_THAN_OR_EQUAL" ], "Values": [ "100" ] } }, { "Dimensions": { "Key": "ANOMALY_TOTAL_IMPACT_PERCENTAGE", "MatchOptions": [ "GREATER_THAN_OR_EQUAL" ], "Values": [ "100" ] } } ] }`
#' 
#' -   `OR` two thresholds together:
#'     `{ "Or": [ { "Dimensions": { "Key": "ANOMALY_TOTAL_IMPACT_ABSOLUTE", "MatchOptions": [ "GREATER_THAN_OR_EQUAL" ], "Values": [ "100" ] } }, { "Dimensions": { "Key": "ANOMALY_TOTAL_IMPACT_PERCENTAGE", "MatchOptions": [ "GREATER_THAN_OR_EQUAL" ], "Values": [ "100" ] } } ] }`
#'
#' @keywords internal
#'
#' @rdname costexplorer_update_anomaly_subscription
costexplorer_update_anomaly_subscription <- function(SubscriptionArn, Threshold = NULL, Frequency = NULL, MonitorArnList = NULL, Subscribers = NULL, SubscriptionName = NULL, ThresholdExpression = NULL) {
  op <- new_operation(
    name = "UpdateAnomalySubscription",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .costexplorer$update_anomaly_subscription_input(SubscriptionArn = SubscriptionArn, Threshold = Threshold, Frequency = Frequency, MonitorArnList = MonitorArnList, Subscribers = Subscribers, SubscriptionName = SubscriptionName, ThresholdExpression = ThresholdExpression)
  output <- .costexplorer$update_anomaly_subscription_output()
  config <- get_config()
  svc <- .costexplorer$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.costexplorer$operations$update_anomaly_subscription <- costexplorer_update_anomaly_subscription

#' Updates status for cost allocation tags in bulk, with maximum batch size
#' of 20
#'
#' @description
#' Updates status for cost allocation tags in bulk, with maximum batch size of 20. If the tag status that's updated is the same as the existing tag status, the request doesn't fail. Instead, it doesn't have any effect on the tag status (for example, activating the active tag).
#'
#' See [https://www.paws-r-sdk.com/docs/costexplorer_update_cost_allocation_tags_status/](https://www.paws-r-sdk.com/docs/costexplorer_update_cost_allocation_tags_status/) for full documentation.
#'
#' @param CostAllocationTagsStatus &#91;required&#93; The list of `CostAllocationTagStatusEntry` objects that are used to
#' update cost allocation tags status for this request.
#'
#' @keywords internal
#'
#' @rdname costexplorer_update_cost_allocation_tags_status
costexplorer_update_cost_allocation_tags_status <- function(CostAllocationTagsStatus) {
  op <- new_operation(
    name = "UpdateCostAllocationTagsStatus",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .costexplorer$update_cost_allocation_tags_status_input(CostAllocationTagsStatus = CostAllocationTagsStatus)
  output <- .costexplorer$update_cost_allocation_tags_status_output()
  config <- get_config()
  svc <- .costexplorer$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.costexplorer$operations$update_cost_allocation_tags_status <- costexplorer_update_cost_allocation_tags_status

#' Updates an existing Cost Category
#'
#' @description
#' Updates an existing Cost Category. Changes made to the Cost Category rules will be used to categorize the current month’s expenses and future expenses. This won’t change categorization for the previous months.
#'
#' See [https://www.paws-r-sdk.com/docs/costexplorer_update_cost_category_definition/](https://www.paws-r-sdk.com/docs/costexplorer_update_cost_category_definition/) for full documentation.
#'
#' @param CostCategoryArn &#91;required&#93; The unique identifier for your Cost Category.
#' @param EffectiveStart The Cost Category's effective start date. It can only be a billing start
#' date (first day of the month). If the date isn't provided, it's the
#' first day of the current month. Dates can't be before the previous
#' twelve months, or in the future.
#' @param RuleVersion &#91;required&#93; 
#' @param Rules &#91;required&#93; The `Expression` object used to categorize costs. For more information,
#' see
#' [CostCategoryRule](https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_CostCategoryRule.html)
#' .
#' @param DefaultValue 
#' @param SplitChargeRules The split charge rules used to allocate your charges between your Cost
#' Category values.
#'
#' @keywords internal
#'
#' @rdname costexplorer_update_cost_category_definition
costexplorer_update_cost_category_definition <- function(CostCategoryArn, EffectiveStart = NULL, RuleVersion, Rules, DefaultValue = NULL, SplitChargeRules = NULL) {
  op <- new_operation(
    name = "UpdateCostCategoryDefinition",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .costexplorer$update_cost_category_definition_input(CostCategoryArn = CostCategoryArn, EffectiveStart = EffectiveStart, RuleVersion = RuleVersion, Rules = Rules, DefaultValue = DefaultValue, SplitChargeRules = SplitChargeRules)
  output <- .costexplorer$update_cost_category_definition_output()
  config <- get_config()
  svc <- .costexplorer$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.costexplorer$operations$update_cost_category_definition <- costexplorer_update_cost_category_definition
