% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/marketplaceentitlementservice_service.R
\name{marketplaceentitlementservice}
\alias{marketplaceentitlementservice}
\title{AWS Marketplace Entitlement Service}
\usage{
marketplaceentitlementservice(config = list())
}
\arguments{
\item{config}{Optional configuration of credentials, endpoint, and/or region.}
}
\value{
A client for the service. You can call the service's operations using
syntax like \code{svc$operation(...)}, where \code{svc} is the name you've assigned
to the client. The available operations are listed in the
Operations section.
}
\description{
This reference provides descriptions of the AWS Marketplace Entitlement
Service API.

AWS Marketplace Entitlement Service is used to determine the entitlement
of a customer to a given product. An entitlement represents capacity in
a product owned by the customer. For example, a customer might own some
number of users or seats in an SaaS application or some amount of data
capacity in a multi-tenant database.

\strong{Getting Entitlement Records}
\itemize{
\item \emph{GetEntitlements}- Gets the entitlements for a Marketplace product.
}
}
\section{Service syntax}{
\preformatted{svc <- marketplaceentitlementservice(
  config = list(
    credentials = list(
      creds = list(
        access_key_id = "string",
        secret_access_key = "string",
        session_token = "string"
      ),
      profile = "string"
    ),
    endpoint = "string",
    region = "string"
  )
)
}
}

\section{Operations}{

\tabular{ll}{
\link[=marketplaceentitlementservice_get_entitlements]{get_entitlements} \tab GetEntitlements retrieves entitlement values for a given product
}
}

\examples{
\dontrun{
svc <- marketplaceentitlementservice()
svc$get_entitlements(
  Foo = 123
)
}

}
