% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/budgets_operations.R
\name{budgets_describe_subscribers_for_notification}
\alias{budgets_describe_subscribers_for_notification}
\title{Lists the subscribers that are associated with a notification}
\usage{
budgets_describe_subscribers_for_notification(AccountId, BudgetName,
  Notification, MaxResults, NextToken)
}
\arguments{
\item{AccountId}{[required] The \code{accountId} that is associated with the budget whose subscribers you
want descriptions of.}

\item{BudgetName}{[required] The name of the budget whose subscribers you want descriptions of.}

\item{Notification}{[required] The notification whose subscribers you want to list.}

\item{MaxResults}{An optional integer that represents how many entries a paginated
response contains. The maximum is 100.}

\item{NextToken}{The pagination token that you include in your request to indicate the
next set of results that you want to retrieve.}
}
\value{
A list with the following syntax:\preformatted{list(
  Subscribers = list(
    list(
      SubscriptionType = "SNS"|"EMAIL",
      Address = "string"
    )
  ),
  NextToken = "string"
)
}
}
\description{
Lists the subscribers that are associated with a notification.
}
\section{Request syntax}{
\preformatted{svc$describe_subscribers_for_notification(
  AccountId = "string",
  BudgetName = "string",
  Notification = list(
    NotificationType = "ACTUAL"|"FORECASTED",
    ComparisonOperator = "GREATER_THAN"|"LESS_THAN"|"EQUAL_TO",
    Threshold = 123.0,
    ThresholdType = "PERCENTAGE"|"ABSOLUTE_VALUE",
    NotificationState = "OK"|"ALARM"
  ),
  MaxResults = 123,
  NextToken = "string"
)
}
}

\keyword{internal}
