% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lambda_operations.R
\name{lambda_put_function_recursion_config}
\alias{lambda_put_function_recursion_config}
\title{Sets your function's recursive loop detection configuration}
\usage{
lambda_put_function_recursion_config(FunctionName, RecursiveLoop)
}
\arguments{
\item{FunctionName}{[required] The name or ARN of the Lambda function.

\strong{Name formats}
\itemize{
\item \strong{Function name} – \verb{my-function}.
\item \strong{Function ARN} –
\verb{arn:aws:lambda:us-west-2:123456789012:function:my-function}.
\item \strong{Partial ARN} – \verb{123456789012:function:my-function}.
}

The length constraint applies only to the full ARN. If you specify only
the function name, it is limited to 64 characters in length.}

\item{RecursiveLoop}{[required] If you set your function's recursive loop detection configuration to
\code{Allow}, Lambda doesn't take any action when it detects your function
being invoked as part of a recursive loop. We recommend that you only
use this setting if your design intentionally uses a Lambda function to
write data back to the same Amazon Web Services resource that invokes
it.

If you set your function's recursive loop detection configuration to
\code{Terminate}, Lambda stops your function being invoked and notifies you
when it detects your function being invoked as part of a recursive loop.

By default, Lambda sets your function's configuration to \code{Terminate}.

If your design intentionally uses a Lambda function to write data back
to the same Amazon Web Services resource that invokes the function, then
use caution and implement suitable guard rails to prevent unexpected
charges being billed to your Amazon Web Services account. To learn more
about best practices for using recursive invocation patterns, see
\href{https://serverlessland.com/content/service/lambda/guides/aws-lambda-operator-guide/recursive-runaway}{Recursive patterns that cause run-away Lambda functions}
in Serverless Land.}
}
\description{
Sets your function's \href{https://docs.aws.amazon.com/lambda/latest/dg/invocation-recursion.html}{recursive loop detection} configuration.

See \url{https://www.paws-r-sdk.com/docs/lambda_put_function_recursion_config/} for full documentation.
}
\keyword{internal}
