% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/emrcontainers_operations.R
\name{emrcontainers_get_managed_endpoint_session_credentials}
\alias{emrcontainers_get_managed_endpoint_session_credentials}
\title{Generate a session token to connect to a managed endpoint}
\usage{
emrcontainers_get_managed_endpoint_session_credentials(
  endpointIdentifier,
  virtualClusterIdentifier,
  executionRoleArn,
  credentialType,
  durationInSeconds = NULL,
  logContext = NULL,
  clientToken = NULL
)
}
\arguments{
\item{endpointIdentifier}{[required] The ARN of the managed endpoint for which the request is submitted.}

\item{virtualClusterIdentifier}{[required] The ARN of the Virtual Cluster which the Managed Endpoint belongs to.}

\item{executionRoleArn}{[required] The IAM Execution Role ARN that will be used by the job run.}

\item{credentialType}{[required] Type of the token requested. Currently supported and default value of
this field is “TOKEN.”}

\item{durationInSeconds}{Duration in seconds for which the session token is valid. The default
duration is 15 minutes and the maximum is 12 hours.}

\item{logContext}{String identifier used to separate sections of the execution logs
uploaded to S3.}

\item{clientToken}{The client idempotency token of the job run request.}
}
\description{
Generate a session token to connect to a managed endpoint.

See \url{https://www.paws-r-sdk.com/docs/emrcontainers_get_managed_endpoint_session_credentials/} for full documentation.
}
\keyword{internal}
