% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2_operations.R
\name{ec2_run_instances}
\alias{ec2_run_instances}
\title{Launches the specified number of instances using an AMI for which you
have permissions}
\usage{
ec2_run_instances(
  BlockDeviceMappings = NULL,
  ImageId = NULL,
  InstanceType = NULL,
  Ipv6AddressCount = NULL,
  Ipv6Addresses = NULL,
  KernelId = NULL,
  KeyName = NULL,
  MaxCount,
  MinCount,
  Monitoring = NULL,
  Placement = NULL,
  RamdiskId = NULL,
  SecurityGroupIds = NULL,
  SecurityGroups = NULL,
  SubnetId = NULL,
  UserData = NULL,
  AdditionalInfo = NULL,
  ClientToken = NULL,
  DisableApiTermination = NULL,
  DryRun = NULL,
  EbsOptimized = NULL,
  IamInstanceProfile = NULL,
  InstanceInitiatedShutdownBehavior = NULL,
  NetworkInterfaces = NULL,
  PrivateIpAddress = NULL,
  ElasticGpuSpecification = NULL,
  ElasticInferenceAccelerators = NULL,
  TagSpecifications = NULL,
  LaunchTemplate = NULL,
  InstanceMarketOptions = NULL,
  CreditSpecification = NULL,
  CpuOptions = NULL,
  CapacityReservationSpecification = NULL,
  HibernationOptions = NULL,
  LicenseSpecifications = NULL,
  MetadataOptions = NULL,
  EnclaveOptions = NULL,
  PrivateDnsNameOptions = NULL,
  MaintenanceOptions = NULL,
  DisableApiStop = NULL
)
}
\arguments{
\item{BlockDeviceMappings}{The block device mapping, which defines the EBS volumes and instance
store volumes to attach to the instance at launch. For more information,
see \href{https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/block-device-mapping-concepts.html}{Block device mappings}
in the \emph{Amazon EC2 User Guide}.}

\item{ImageId}{The ID of the AMI. An AMI ID is required to launch an instance and must
be specified here or in a launch template.}

\item{InstanceType}{The instance type. For more information, see \href{https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html}{Instance types}
in the \emph{Amazon EC2 User Guide}.

Default: \code{m1.small}}

\item{Ipv6AddressCount}{The number of IPv6 addresses to associate with the primary network
interface. Amazon EC2 chooses the IPv6 addresses from the range of your
subnet. You cannot specify this option and the option to assign specific
IPv6 addresses in the same request. You can specify this option if
you've specified a minimum number of instances to launch.

You cannot specify this option and the network interfaces option in the
same request.}

\item{Ipv6Addresses}{The IPv6 addresses from the range of the subnet to associate with the
primary network interface. You cannot specify this option and the option
to assign a number of IPv6 addresses in the same request. You cannot
specify this option if you've specified a minimum number of instances to
launch.

You cannot specify this option and the network interfaces option in the
same request.}

\item{KernelId}{The ID of the kernel.

We recommend that you use PV-GRUB instead of kernels and RAM disks. For
more information, see
\href{https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/UserProvidedKernels.html}{PV-GRUB}
in the \emph{Amazon EC2 User Guide}.}

\item{KeyName}{The name of the key pair. You can create a key pair using
\code{\link[=ec2_create_key_pair]{create_key_pair}} or
\code{\link[=ec2_import_key_pair]{import_key_pair}}.

If you do not specify a key pair, you can't connect to the instance
unless you choose an AMI that is configured to allow users another way
to log in.}

\item{MaxCount}{[required] The maximum number of instances to launch. If you specify more instances
than Amazon EC2 can launch in the target Availability Zone, Amazon EC2
launches the largest possible number of instances above \code{MinCount}.

Constraints: Between 1 and the maximum number you're allowed for the
specified instance type. For more information about the default limits,
and how to request an increase, see \href{https://aws.amazon.com/ec2/faqs/#How_many_instances_can_I_run_in_Amazon_EC2}{How many instances can I run in Amazon EC2}
in the Amazon EC2 FAQ.}

\item{MinCount}{[required] The minimum number of instances to launch. If you specify a minimum that
is more instances than Amazon EC2 can launch in the target Availability
Zone, Amazon EC2 launches no instances.

Constraints: Between 1 and the maximum number you're allowed for the
specified instance type. For more information about the default limits,
and how to request an increase, see \href{https://aws.amazon.com/ec2/faqs/#How_many_instances_can_I_run_in_Amazon_EC2}{How many instances can I run in Amazon EC2}
in the Amazon EC2 General FAQ.}

\item{Monitoring}{Specifies whether detailed monitoring is enabled for the instance.}

\item{Placement}{The placement for the instance.}

\item{RamdiskId}{The ID of the RAM disk to select. Some kernels require additional
drivers at launch. Check the kernel requirements for information about
whether you need to specify a RAM disk. To find kernel requirements, go
to the Amazon Web Services Resource Center and search for the kernel ID.

We recommend that you use PV-GRUB instead of kernels and RAM disks. For
more information, see
\href{https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/UserProvidedKernels.html}{PV-GRUB}
in the \emph{Amazon EC2 User Guide}.}

\item{SecurityGroupIds}{The IDs of the security groups. You can create a security group using
\code{\link[=ec2_create_security_group]{create_security_group}}.

If you specify a network interface, you must specify any security groups
as part of the network interface.}

\item{SecurityGroups}{[Default VPC] The names of the security groups.

If you specify a network interface, you must specify any security groups
as part of the network interface.

Default: Amazon EC2 uses the default security group.}

\item{SubnetId}{The ID of the subnet to launch the instance into.

If you specify a network interface, you must specify any subnets as part
of the network interface.}

\item{UserData}{The user data script to make available to the instance. For more
information, see \href{https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/user-data.html}{Run commands on your Linux instance at launch}
and \href{https://docs.aws.amazon.com/AWSEC2/latest/WindowsGuide/ec2-windows-user-data.html}{Run commands on your Windows instance at launch}.
If you are using a command line tool, base64-encoding is performed for
you, and you can load the text from a file. Otherwise, you must provide
base64-encoded text. User data is limited to 16 KB.}

\item{AdditionalInfo}{Reserved.}

\item{ClientToken}{Unique, case-sensitive identifier you provide to ensure the idempotency
of the request. If you do not specify a client token, a randomly
generated token is used for the request to ensure idempotency.

For more information, see \href{https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html}{Ensuring Idempotency}.

Constraints: Maximum 64 ASCII characters}

\item{DisableApiTermination}{If you set this parameter to \code{true}, you can't terminate the instance
using the Amazon EC2 console, CLI, or API; otherwise, you can. To change
this attribute after launch, use
\code{\link[=ec2_modify_instance_attribute]{modify_instance_attribute}}.
Alternatively, if you set \code{InstanceInitiatedShutdownBehavior} to
\code{terminate}, you can terminate the instance by running the shutdown
command from the instance.

Default: \code{false}}

\item{DryRun}{Checks whether you have the required permissions for the action, without
actually making the request, and provides an error response. If you have
the required permissions, the error response is \code{DryRunOperation}.
Otherwise, it is \code{UnauthorizedOperation}.}

\item{EbsOptimized}{Indicates whether the instance is optimized for Amazon EBS I/O. This
optimization provides dedicated throughput to Amazon EBS and an
optimized configuration stack to provide optimal Amazon EBS I/O
performance. This optimization isn't available with all instance types.
Additional usage charges apply when using an EBS-optimized instance.

Default: \code{false}}

\item{IamInstanceProfile}{The name or Amazon Resource Name (ARN) of an IAM instance profile.}

\item{InstanceInitiatedShutdownBehavior}{Indicates whether an instance stops or terminates when you initiate
shutdown from the instance (using the operating system command for
system shutdown).

Default: \code{stop}}

\item{NetworkInterfaces}{The network interfaces to associate with the instance. If you specify a
network interface, you must specify any security groups and subnets as
part of the network interface.}

\item{PrivateIpAddress}{The primary IPv4 address. You must specify a value from the IPv4 address
range of the subnet.

Only one private IP address can be designated as primary. You can't
specify this option if you've specified the option to designate a
private IP address as the primary IP address in a network interface
specification. You cannot specify this option if you're launching more
than one instance in the request.

You cannot specify this option and the network interfaces option in the
same request.}

\item{ElasticGpuSpecification}{An elastic GPU to associate with the instance. An Elastic GPU is a GPU
resource that you can attach to your Windows instance to accelerate the
graphics performance of your applications. For more information, see
\href{https://docs.aws.amazon.com/AWSEC2/latest/WindowsGuide/elastic-graphics.html}{Amazon EC2 Elastic GPUs}
in the \emph{Amazon EC2 User Guide}.}

\item{ElasticInferenceAccelerators}{An elastic inference accelerator to associate with the instance. Elastic
inference accelerators are a resource you can attach to your Amazon EC2
instances to accelerate your Deep Learning (DL) inference workloads.

You cannot specify accelerators from different generations in the same
request.

Starting April 15, 2023, Amazon Web Services will not onboard new
customers to Amazon Elastic Inference (EI), and will help current
customers migrate their workloads to options that offer better price and
performance. After April 15, 2023, new customers will not be able to
launch instances with Amazon EI accelerators in Amazon SageMaker, Amazon
ECS, or Amazon EC2. However, customers who have used Amazon EI at least
once during the past 30-day period are considered current customers and
will be able to continue using the service.}

\item{TagSpecifications}{The tags to apply to the resources that are created during instance
launch.

You can specify tags for the following resources only:
\itemize{
\item Instances
\item Volumes
\item Elastic graphics
\item Spot Instance requests
\item Network interfaces
}

To tag a resource after it has been created, see
\code{\link[=ec2_create_tags]{create_tags}}.}

\item{LaunchTemplate}{The launch template to use to launch the instances. Any parameters that
you specify in \code{\link[=ec2_run_instances]{run_instances}} override the same
parameters in the launch template. You can specify either the name or ID
of a launch template, but not both.}

\item{InstanceMarketOptions}{The market (purchasing) option for the instances.

For \code{\link[=ec2_run_instances]{run_instances}}, persistent Spot Instance
requests are only supported when \strong{InstanceInterruptionBehavior} is set
to either \code{hibernate} or \code{stop}.}

\item{CreditSpecification}{The credit option for CPU usage of the burstable performance instance.
Valid values are \code{standard} and \code{unlimited}. To change this attribute
after launch, use
\href{https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ModifyInstanceCreditSpecification.html}{ModifyInstanceCreditSpecification}.
For more information, see \href{https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/burstable-performance-instances.html}{Burstable performance instances}
in the \emph{Amazon EC2 User Guide}.

Default: \code{standard} (T2 instances) or \code{unlimited} (T3/T3a/T4g instances)

For T3 instances with \code{host} tenancy, only \code{standard} is supported.}

\item{CpuOptions}{The CPU options for the instance. For more information, see \href{https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-optimize-cpu.html}{Optimize CPU options}
in the \emph{Amazon EC2 User Guide}.}

\item{CapacityReservationSpecification}{Information about the Capacity Reservation targeting option. If you do
not specify this parameter, the instance's Capacity Reservation
preference defaults to \code{open}, which enables it to run in any open
Capacity Reservation that has matching attributes (instance type,
platform, Availability Zone).}

\item{HibernationOptions}{Indicates whether an instance is enabled for hibernation. For more
information, see \href{https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Hibernate.html}{Hibernate your instance}
in the \emph{Amazon EC2 User Guide}.

You can't enable hibernation and Amazon Web Services Nitro Enclaves on
the same instance.}

\item{LicenseSpecifications}{The license configurations.}

\item{MetadataOptions}{The metadata options for the instance. For more information, see
\href{https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-instance-metadata.html}{Instance metadata and user data}.}

\item{EnclaveOptions}{Indicates whether the instance is enabled for Amazon Web Services Nitro
Enclaves. For more information, see \href{https://docs.aws.amazon.com/enclaves/latest/user/nitro-enclave.html}{What is Amazon Web Services Nitro Enclaves?}
in the \emph{Amazon Web Services Nitro Enclaves User Guide}.

You can't enable Amazon Web Services Nitro Enclaves and hibernation on
the same instance.}

\item{PrivateDnsNameOptions}{The options for the instance hostname. The default values are inherited
from the subnet.}

\item{MaintenanceOptions}{The maintenance and recovery options for the instance.}

\item{DisableApiStop}{Indicates whether an instance is enabled for stop protection. For more
information, see \href{https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Stop_Start.html#Using_StopProtection}{Stop protection}.}
}
\description{
Launches the specified number of instances using an AMI for which you have permissions.

See \url{https://www.paws-r-sdk.com/docs/ec2_run_instances/} for full documentation.
}
\keyword{internal}
