% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/elasticbeanstalk_operations.R
\name{elasticbeanstalk_update_configuration_template}
\alias{elasticbeanstalk_update_configuration_template}
\title{Updates the specified configuration template to have the specified
properties or configuration option values}
\usage{
elasticbeanstalk_update_configuration_template(
  ApplicationName,
  TemplateName,
  Description = NULL,
  OptionSettings = NULL,
  OptionsToRemove = NULL
)
}
\arguments{
\item{ApplicationName}{[required] The name of the application associated with the configuration template
to update.

If no application is found with this name,
\code{\link[=elasticbeanstalk_update_configuration_template]{update_configuration_template}}
returns an \code{InvalidParameterValue} error.}

\item{TemplateName}{[required] The name of the configuration template to update.

If no configuration template is found with this name,
\code{\link[=elasticbeanstalk_update_configuration_template]{update_configuration_template}}
returns an \code{InvalidParameterValue} error.}

\item{Description}{A new description for the configuration.}

\item{OptionSettings}{A list of configuration option settings to update with the new specified
option value.}

\item{OptionsToRemove}{A list of configuration options to remove from the configuration set.

Constraint: You can remove only \code{UserDefined} configuration options.}
}
\description{
Updates the specified configuration template to have the specified properties or configuration option values.

See \url{https://paws-r.github.io/docs/elasticbeanstalk/update_configuration_template.html} for full documentation.
}
\keyword{internal}
