% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eks_operations.R
\name{eks_create_nodegroup}
\alias{eks_create_nodegroup}
\title{Creates a managed node group for an Amazon EKS cluster}
\usage{
eks_create_nodegroup(
  clusterName,
  nodegroupName,
  scalingConfig = NULL,
  diskSize = NULL,
  subnets,
  instanceTypes = NULL,
  amiType = NULL,
  remoteAccess = NULL,
  nodeRole,
  labels = NULL,
  taints = NULL,
  tags = NULL,
  clientRequestToken = NULL,
  launchTemplate = NULL,
  updateConfig = NULL,
  capacityType = NULL,
  version = NULL,
  releaseVersion = NULL
)
}
\arguments{
\item{clusterName}{[required] The name of the cluster to create the node group in.}

\item{nodegroupName}{[required] The unique name to give your node group.}

\item{scalingConfig}{The scaling configuration details for the Auto Scaling group that is
created for your node group.}

\item{diskSize}{The root device disk size (in GiB) for your node group instances. The
default disk size is 20 GiB. If you specify \code{launchTemplate}, then don't
specify \code{diskSize}, or the node group deployment will fail. For more
information about using launch templates with Amazon EKS, see \href{https://docs.aws.amazon.com/eks/latest/userguide/launch-templates.html}{Launch template support}
in the \emph{Amazon EKS User Guide}.}

\item{subnets}{[required] The subnets to use for the Auto Scaling group that is created for your
node group. If you specify \code{launchTemplate}, then don't specify
\href{https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateNetworkInterface.html}{\code{SubnetId}}
in your launch template, or the node group deployment will fail. For
more information about using launch templates with Amazon EKS, see
\href{https://docs.aws.amazon.com/eks/latest/userguide/launch-templates.html}{Launch template support}
in the \emph{Amazon EKS User Guide}.}

\item{instanceTypes}{Specify the instance types for a node group. If you specify a GPU
instance type, be sure to specify \code{AL2_x86_64_GPU} with the \code{amiType}
parameter. If you specify \code{launchTemplate}, then you can specify zero or
one instance type in your launch template \emph{or} you can specify 0-20
instance types for \code{instanceTypes}. If however, you specify an instance
type in your launch template \emph{and} specify any \code{instanceTypes}, the node
group deployment will fail. If you don't specify an instance type in a
launch template or for \code{instanceTypes}, then \code{t3.medium} is used, by
default. If you specify \code{Spot} for \code{capacityType}, then we recommend
specifying multiple values for \code{instanceTypes}. For more information,
see \href{https://docs.aws.amazon.com/eks/latest/userguide/managed-node-groups.html#managed-node-group-capacity-types}{Managed node group capacity types}
and \href{https://docs.aws.amazon.com/eks/latest/userguide/launch-templates.html}{Launch template support}
in the \emph{Amazon EKS User Guide}.}

\item{amiType}{The AMI type for your node group. GPU instance types should use the
\code{AL2_x86_64_GPU} AMI type. Non-GPU instances should use the \code{AL2_x86_64}
AMI type. Arm instances should use the \code{AL2_ARM_64} AMI type. All types
use the Amazon EKS optimized Amazon Linux 2 AMI. If you specify
\code{launchTemplate}, and your launch template uses a custom AMI, then don't
specify \code{amiType}, or the node group deployment will fail. For more
information about using launch templates with Amazon EKS, see \href{https://docs.aws.amazon.com/eks/latest/userguide/launch-templates.html}{Launch template support}
in the \emph{Amazon EKS User Guide}.}

\item{remoteAccess}{The remote access (SSH) configuration to use with your node group. If
you specify \code{launchTemplate}, then don't specify \code{remoteAccess}, or the
node group deployment will fail. For more information about using launch
templates with Amazon EKS, see \href{https://docs.aws.amazon.com/eks/latest/userguide/launch-templates.html}{Launch template support}
in the \emph{Amazon EKS User Guide}.}

\item{nodeRole}{[required] The Amazon Resource Name (ARN) of the IAM role to associate with your
node group. The Amazon EKS worker node \code{kubelet} daemon makes calls to
Amazon Web Services APIs on your behalf. Nodes receive permissions for
these API calls through an IAM instance profile and associated policies.
Before you can launch nodes and register them into a cluster, you must
create an IAM role for those nodes to use when they are launched. For
more information, see \href{https://docs.aws.amazon.com/eks/latest/userguide/create-node-role.html}{Amazon EKS node IAM role}
in the \emph{Amazon EKS User Guide} . If you specify \code{launchTemplate}, then
don't specify
\href{https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_IamInstanceProfile.html}{\code{IamInstanceProfile}}
in your launch template, or the node group deployment will fail. For
more information about using launch templates with Amazon EKS, see
\href{https://docs.aws.amazon.com/eks/latest/userguide/launch-templates.html}{Launch template support}
in the \emph{Amazon EKS User Guide}.}

\item{labels}{The Kubernetes labels to be applied to the nodes in the node group when
they are created.}

\item{taints}{The Kubernetes taints to be applied to the nodes in the node group. For
more information, see \href{https://docs.aws.amazon.com/eks/latest/userguide/node-taints-managed-node-groups.html}{Node taints on managed node groups}.}

\item{tags}{The metadata to apply to the node group to assist with categorization
and organization. Each tag consists of a key and an optional value. You
define both. Node group tags do not propagate to any other resources
associated with the node group, such as the Amazon EC2 instances or
subnets.}

\item{clientRequestToken}{Unique, case-sensitive identifier that you provide to ensure the
idempotency of the request.}

\item{launchTemplate}{An object representing a node group's launch template specification. If
specified, then do not specify \code{instanceTypes}, \code{diskSize}, or
\code{remoteAccess} and make sure that the launch template meets the
requirements in \code{launchTemplateSpecification}.}

\item{updateConfig}{The node group update configuration.}

\item{capacityType}{The capacity type for your node group.}

\item{version}{The Kubernetes version to use for your managed nodes. By default, the
Kubernetes version of the cluster is used, and this is the only accepted
specified value. If you specify \code{launchTemplate}, and your launch
template uses a custom AMI, then don't specify \code{version}, or the node
group deployment will fail. For more information about using launch
templates with Amazon EKS, see \href{https://docs.aws.amazon.com/eks/latest/userguide/launch-templates.html}{Launch template support}
in the \emph{Amazon EKS User Guide}.}

\item{releaseVersion}{The AMI version of the Amazon EKS optimized AMI to use with your node
group. By default, the latest available AMI version for the node group's
current Kubernetes version is used. For more information, see \href{https://docs.aws.amazon.com/eks/latest/userguide/eks-linux-ami-versions.html}{Amazon EKS optimized Amazon Linux 2 AMI versions}
in the \emph{Amazon EKS User Guide}. If you specify \code{launchTemplate}, and
your launch template uses a custom AMI, then don't specify
\code{releaseVersion}, or the node group deployment will fail. For more
information about using launch templates with Amazon EKS, see \href{https://docs.aws.amazon.com/eks/latest/userguide/launch-templates.html}{Launch template support}
in the \emph{Amazon EKS User Guide}.}
}
\description{
Creates a managed node group for an Amazon EKS cluster. You can only create a node group for your cluster that is equal to the current Kubernetes version for the cluster. All node groups are created with the latest AMI release version for the respective minor Kubernetes version of the cluster, unless you deploy a custom AMI using a launch template. For more information about using launch templates, see \href{https://docs.aws.amazon.com/eks/latest/userguide/launch-templates.html}{Launch template support}.

See \url{https://paws-r.github.io/docs/eks/create_nodegroup.html} for full documentation.
}
\keyword{internal}
