% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ecs_operations.R
\name{ecs_put_cluster_capacity_providers}
\alias{ecs_put_cluster_capacity_providers}
\title{Modifies the available capacity providers and the default capacity
provider strategy for a cluster}
\usage{
ecs_put_cluster_capacity_providers(
  cluster,
  capacityProviders,
  defaultCapacityProviderStrategy
)
}
\arguments{
\item{cluster}{[required] The short name or full Amazon Resource Name (ARN) of the cluster to
modify the capacity provider settings for. If you don't specify a
cluster, the default cluster is assumed.}

\item{capacityProviders}{[required] The name of one or more capacity providers to associate with the
cluster.

If specifying a capacity provider that uses an Auto Scaling group, the
capacity provider must already be created. New capacity providers can be
created with the
\code{\link[=ecs_create_capacity_provider]{create_capacity_provider}} API
operation.

To use a Fargate capacity provider, specify either the \code{FARGATE} or
\code{FARGATE_SPOT} capacity providers. The Fargate capacity providers are
available to all accounts and only need to be associated with a cluster
to be used.}

\item{defaultCapacityProviderStrategy}{[required] The capacity provider strategy to use by default for the cluster.

When creating a service or running a task on a cluster, if no capacity
provider or launch type is specified then the default capacity provider
strategy for the cluster is used.

A capacity provider strategy consists of one or more capacity providers
along with the \code{base} and \code{weight} to assign to them. A capacity
provider must be associated with the cluster to be used in a capacity
provider strategy. The
\code{\link[=ecs_put_cluster_capacity_providers]{put_cluster_capacity_providers}}
API is used to associate a capacity provider with a cluster. Only
capacity providers with an \code{ACTIVE} or \code{UPDATING} status can be used.

If specifying a capacity provider that uses an Auto Scaling group, the
capacity provider must already be created. New capacity providers can be
created with the
\code{\link[=ecs_create_capacity_provider]{create_capacity_provider}} API
operation.

To use a Fargate capacity provider, specify either the \code{FARGATE} or
\code{FARGATE_SPOT} capacity providers. The Fargate capacity providers are
available to all accounts and only need to be associated with a cluster
to be used.}
}
\description{
Modifies the available capacity providers and the default capacity provider strategy for a cluster.

See \url{https://paws-r.github.io/docs/ecs/put_cluster_capacity_providers.html} for full documentation.
}
\keyword{internal}
