% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2_operations.R
\name{ec2_describe_network_interface_permissions}
\alias{ec2_describe_network_interface_permissions}
\title{Describes the permissions for your network interfaces}
\usage{
ec2_describe_network_interface_permissions(
  NetworkInterfacePermissionIds = NULL,
  Filters = NULL,
  NextToken = NULL,
  MaxResults = NULL
)
}
\arguments{
\item{NetworkInterfacePermissionIds}{One or more network interface permission IDs.}

\item{Filters}{One or more filters.
\itemize{
\item \code{network-interface-permission.network-interface-permission-id} - The
ID of the permission.
\item \code{network-interface-permission.network-interface-id} - The ID of the
network interface.
\item \code{network-interface-permission.aws-account-id} - The Amazon Web
Services account ID.
\item \code{network-interface-permission.aws-service} - The Amazon Web Service.
\item \code{network-interface-permission.permission} - The type of permission
(\code{INSTANCE-ATTACH} | \code{EIP-ASSOCIATE}).
}}

\item{NextToken}{The token to request the next page of results.}

\item{MaxResults}{The maximum number of results to return in a single call. To retrieve
the remaining results, make another call with the returned \code{NextToken}
value. If this parameter is not specified, up to 50 results are returned
by default.}
}
\description{
Describes the permissions for your network interfaces.

See \url{https://paws-r.github.io/docs/ec2/describe_network_interface_permissions.html} for full documentation.
}
\keyword{internal}
